/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.datasource;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bigobjectcache.BigObjectCacheMap;
import com.kingdee.bos.bigobjectcache.BigObjectCacheMapFactory;
import com.kingdee.bos.streamwork.DataSourceTimeoutException;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCachedPage;
import com.kingdee.bos.streamwork.datasource.TimeoutMap;
import com.kingdee.bos.streamwork.service.IStreamWorkService;
import com.kingdee.bos.streamwork.service.StreamWorkService;
import com.kingdee.bos.streamwork.service.StreamWorkServiceFactory;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MultiDataSource
implements DataSource {
    private List<DataSource> dataSourceList;
    private DataSource dataSource0;
    private int rowCount = 0;
    private int[] rowCounts;
    private boolean cache;
    private HashMap<Integer, Object> cacheKeys = new HashMap(2);
    private transient TimeoutMap localDataSourceMap;
    private transient IStreamWorkService streamWorkService;

    public MultiDataSource(List<DataSource> dataSourceList) {
        this(dataSourceList, false, 0);
    }

    public MultiDataSource(List<DataSource> dataSourceList, boolean cache, int cacheTimeout) {
        this.dataSourceList = dataSourceList;
        this.cache = cache;
        this.dataSource0 = dataSourceList.get(0);
        this.rowCounts = new int[dataSourceList.size()];
        for (int i = 0; i < dataSourceList.size(); ++i) {
            this.rowCounts[i] = dataSourceList.get(i).getRowCount();
            this.rowCount += this.rowCounts[i];
        }
        if (cache) {
            BigObjectCacheMap cacheMap = BigObjectCacheMapFactory.getBigCacheMap(StreamWorkService.class);
            for (int i = 1; i < dataSourceList.size(); ++i) {
                String key;
                while (cacheMap.containsKey((Object)(key = Uuid.create().toString()))) {
                }
                cacheMap.put((Object)key, (Serializable)dataSourceList.get(i), cacheTimeout);
                this.cacheKeys.put(i, key);
                dataSourceList.set(i, null);
            }
        }
    }

    public MultiDataSource(DataSourceWithCachedPage dataSource, int cacheTimeout) throws BOSException {
        this.cache = true;
        this.dataSource0 = dataSource;
        List cachedPageKeys = dataSource.getCachedPageKeys();
        if (cachedPageKeys != null && cachedPageKeys.size() > 0) {
            this.rowCounts = new int[cachedPageKeys.size() + 1];
            this.dataSourceList = new ArrayList<DataSource>();
            this.dataSourceList.add(dataSource);
            this.rowCounts[0] = dataSource.getRowCount();
            this.rowCount += this.rowCounts[0];
            IStreamWorkService pig = StreamWorkServiceFactory.createRemoteObject();
            BigObjectCacheMap cacheMap = BigObjectCacheMapFactory.getBigCacheMap(StreamWorkService.class);
            int index = 1;
            Iterator iter = cachedPageKeys.iterator();
            while (iter.hasNext()) {
                String key2;
                DataSource dataSource2 = pig.getCachedDataSourcePage(iter.next(), true);
                while (cacheMap.containsKey((Object)(key2 = Uuid.create().toString()))) {
                }
                cacheMap.put((Object)key2, (Serializable)dataSource2, cacheTimeout);
                this.cacheKeys.put(index, key2);
                this.dataSourceList.add(null);
                this.rowCounts[index++] = dataSource2.getRowCount();
                this.rowCount += dataSource2.getRowCount();
            }
        }
    }

    @Override
    public int[] getColumnTypes() {
        return this.dataSource0.getColumnTypes();
    }

    @Override
    public String[] getColumnNames() {
        return this.dataSource0.getColumnNames();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    private DataSource getDataSource(int index) {
        DataSource ds = this.dataSourceList.get(index);
        if (ds != null) {
            return ds;
        }
        if (this.cache) {
            if (this.localDataSourceMap != null) {
                ds = (DataSource)this.localDataSourceMap.get(index);
            }
            if (ds != null) {
                return ds;
            }
            Object key = this.cacheKeys.get(index);
            BigObjectCacheMap cacheMap = BigObjectCacheMapFactory.getBigCacheMap(StreamWorkService.class);
            ds = (DataSource)cacheMap.get(key);
            if (ds == null && this.streamWorkService != null && (ds = this.streamWorkService.getCachedDataSourcePage(key)) != null) {
                cacheMap.put(key, (Serializable)ds);
            }
            if (ds == null) {
                throw new DataSourceTimeoutException();
            }
            if (this.localDataSourceMap == null) {
                this.createLocalDataSourceMap();
            }
            this.localDataSourceMap.put(index, ds);
            return ds;
        }
        return null;
    }

    @Override
    public Object getCell(int columnIndex, int rowIndex) {
        int i;
        for (i = 0; i < this.rowCounts.length && rowIndex >= this.rowCounts[i]; rowIndex -= this.rowCounts[i], ++i) {
        }
        return this.getDataSource(i).getCell(columnIndex, rowIndex);
    }

    @Override
    public Object getProperty(Object key) {
        return this.dataSource0.getProperty(key);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.dataSource0.setProperty(key, value);
    }

    public void createLocalDataSourceMap() {
        this.localDataSourceMap = new TimeoutMap(60000, 30000);
    }

    public void finalize() {
        try {
            if (this.localDataSourceMap != null) {
                this.localDataSourceMap.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

