/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.datasource;

import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCachedPage;
import com.kingdee.bos.streamwork.pivot.PivotException;
import com.kingdee.bos.streamwork.service.StreamWorkService;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultSetDataSource
extends DataSourceWithCachedPage
implements DataSource,
Serializable {
    private int[] columnTypes;
    private String[] columnNames;
    private int rowCount;
    private List<Object[]> values;

    @Override
    public int[] getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public Object[] getRow(int index) {
        return this.values.get(index);
    }

    @Override
    public Object getCell(int columnIndex, int rowIndex) {
        return this.values.get(rowIndex)[columnIndex];
    }

    public ResultSetDataSource(ResultSet rs) {
        this.build(rs, Integer.MAX_VALUE, null);
    }

    public ResultSetDataSource(ResultSet rs, String[] columnNames) {
        this.build(rs, Integer.MAX_VALUE, columnNames);
    }

    public ResultSetDataSource(ResultSet rs, int limit) {
        this.build(rs, limit, null);
    }

    public ResultSetDataSource(ResultSet rs, int limit, String[] columnNames) {
        this.build(rs, limit, columnNames);
    }

    public ResultSetDataSource(ResultSet rs, int limit, String[] columnNames, List<PropertyUnitDele> properties, Map aliasMap) {
        this.build(rs, limit, columnNames, properties, aliasMap);
    }

    private int getIndex(ResultSetMetaData rsmd, String columnName) throws SQLException {
        int n = rsmd.getColumnCount() + 1;
        for (int i = 1; i < n; ++i) {
            if (!columnName.equalsIgnoreCase(rsmd.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    private PropertyUnitDele getDele(List<PropertyUnitDele> properties, String name) {
        for (PropertyUnitDele dele : properties) {
            if (!dele.getName().equalsIgnoreCase(name)) continue;
            return dele;
        }
        return null;
    }

    private void build(ResultSet rs, int limit, String[] columnNames) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            this.columnTypes = new int[columnCount];
            int[] columnIndexes = new int[columnCount];
            this.columnNames = columnNames == null ? new String[columnCount] : columnNames;
            for (int i = 0; i < columnCount; ++i) {
                columnIndexes[i] = i + 1;
                this.columnTypes[i] = rsmd.getColumnType(i + 1);
                if (columnNames != null) continue;
                this.columnNames[i] = rsmd.getColumnName(i + 1);
            }
            HashMap<Object, Object> valueMap = new HashMap<Object, Object>();
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            HashMap cache = new HashMap();
            HashMap enumPkCache = new HashMap();
            int index = 0;
            while (rs.next() && index++ < limit) {
                Object[] row = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    Object v = null;
                    int type = this.columnTypes[i];
                    switch (type) {
                        case 91: 
                        case 92: 
                        case 93: {
                            v = rs.getDate(i + 1);
                            break;
                        }
                        default: {
                            v = rs.getObject(i + 1);
                        }
                    }
                    if (v == null) continue;
                    if ((v = this.transferValue(v)) != null) {
                        Object v2 = valueMap.get(v);
                        if (v2 == null) {
                            valueMap.put(v, v);
                        } else {
                            v = v2;
                        }
                    }
                    row[i] = v;
                }
                list.add(row);
            }
            this.rowCount = list.size();
            this.values = list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PivotException(e);
        }
    }

    private void build(ResultSet rs, int limit, String[] columnNames, List<PropertyUnitDele> properties, Map aliasMap) {
        this.columnNames = columnNames;
        int columnCount = columnNames.length;
        this.columnTypes = new int[columnCount];
        int[] columnIndexes = new int[columnCount];
        PropertyUnitDele[] deles = new PropertyUnitDele[columnCount];
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 0; i < columnCount; ++i) {
                int index = this.getIndex(rsmd, columnNames[i]);
                if (index == -1 && aliasMap != null && aliasMap.get(columnNames[i]) != null) {
                    index = this.getIndex(rsmd, aliasMap.get(columnNames[i]).toString());
                }
                columnIndexes[i] = index;
                this.columnTypes[i] = rsmd.getColumnType(index);
                deles[i] = this.getDele(properties, columnNames[i]);
            }
            HashMap<Object, Object> valueMap = new HashMap<Object, Object>();
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            HashMap cache = new HashMap();
            HashMap enumPkCache = new HashMap();
            int index = 0;
            while (rs.next() && index++ < limit) {
                Object[] row = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    Object v = StreamWorkService.getObject(rs, columnIndexes[i], deles[i], cache, enumPkCache);
                    if (v == null) continue;
                    if ((v = this.transferValue(v)) != null) {
                        Object v2 = valueMap.get(v);
                        if (v2 == null) {
                            valueMap.put(v, v);
                        } else {
                            v = v2;
                        }
                    }
                    row[i] = v;
                }
                list.add(row);
            }
            this.rowCount = list.size();
            this.values = list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PivotException(e);
        }
    }
}

