/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TimeoutMap {
    private static int id = 0;
    private HashMap<Object, Object> objectMap = new HashMap(2);
    private HashMap<Object, Long> timeMap = new HashMap(2);
    private TimeoutCleaner cleaner;
    private int timeout;
    private int loopInterval;

    public TimeoutMap(int timeout, int loopInterval) {
        this.timeout = timeout;
        this.loopInterval = loopInterval;
    }

    public synchronized void close() {
        if (this.cleaner != null) {
            this.cleaner.stop = true;
            this.cleaner = null;
            this.objectMap.clear();
            this.timeMap.clear();
        }
    }

    public synchronized void put(Object key, Object value) {
        this.objectMap.put(key, value);
        this.timeMap.put(key, System.currentTimeMillis());
        if (this.cleaner == null || this.cleaner.stop) {
            this.cleaner = new TimeoutCleaner("TimeoutMap-cleaner-" + id++, this.timeout, this.loopInterval);
            this.cleaner.stop = false;
            this.cleaner.start();
        }
    }

    public synchronized Object get(Object key) {
        Object value = this.objectMap.get(key);
        if (value != null) {
            this.timeMap.put(key, System.currentTimeMillis());
        }
        return value;
    }

    public synchronized Object remove(Object key) {
        this.timeMap.remove(key);
        return this.objectMap.remove(key);
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class TimeoutCleaner
    extends Thread {
        boolean stop;
        int timeout;
        int loopInterval;

        TimeoutCleaner(String name, int timeout, int loopInterval) {
            super(name);
            this.stop = true;
            this.timeout = timeout;
            this.loopInterval = loopInterval;
        }

        @Override
        public void run() {
            while (!this.stop) {
                ArrayList keys = null;
                for (Map.Entry entry : TimeoutMap.this.timeMap.entrySet()) {
                    long time = (Long)entry.getValue();
                    if (System.currentTimeMillis() - time <= (long)this.timeout) continue;
                    if (keys == null) {
                        keys = new ArrayList();
                    }
                    keys.add(entry.getKey());
                }
                if (keys != null) {
                    for (Map.Entry key : keys) {
                        TimeoutMap.this.timeMap.remove(key);
                        TimeoutMap.this.objectMap.remove(key);
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.loopInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!TimeoutMap.this.objectMap.isEmpty()) continue;
                this.stop = true;
            }
            TimeoutMap.this.timeMap.clear();
            TimeoutMap.this.objectMap.clear();
        }
    }
}

