/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.metric;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.metric.MetricType;
import com.kingdee.bos.streamwork.metric.MetricUI;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.model.DataModel2;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class MetricDialog
extends KDDialog {
    DataModel2 dataModel;
    KDTextField tfName;
    KDLabelContainer lcName;
    KDComboBox cbType;
    KDPanel bodyPanel;
    HashMap<MetricType, MetricUI> uiMap = new HashMap();
    CardLayout cardLayout = null;
    private boolean isOk = false;
    private Metric metric;
    private Metric initMetric;

    public MetricDialog(Frame owner) {
        super(owner, true);
        this.dataModel = this.dataModel;
        this.setTitle("\u8bbe\u7f6e\u7edf\u8ba1\u6307\u6807");
        this.setSize(800, 600);
        this.initUI();
    }

    public void initUI() {
        this.tfName = new KDTextField();
        this.lcName = new KDLabelContainer("\u540d\u79f0", (JComponent)this.tfName);
        this.lcName.setBoundLabelLength(100);
        this.cbType = new KDComboBox();
        this.setLayout(new BorderLayout());
        this.add((Component)this.initToolBar(), "South");
        this.bodyPanel = new KDPanel();
        this.add((Component)this.bodyPanel, "Center");
        this.bodyPanel.setLayout((LayoutManager)new BorderLayout());
        this.bodyPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        KDLabelContainer lcType = new KDLabelContainer("\u8bf7\u9009\u62e9\u6307\u6807\u7c7b\u578b", (JComponent)this.cbType);
        lcType.setBoundLabelLength(100);
        KDPanel topPanel = new KDPanel();
        topPanel.setLayout((LayoutManager)new GridLayout(2, 1));
        topPanel.add((Component)this.lcName);
        topPanel.add((Component)lcType);
        this.add((Component)topPanel, "North");
        this.cbType.addItems((Object[])MetricType.getAllType());
        this.cbType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MetricDialog.this.typeChanged((MetricType)e.getItem());
                }
            }
        });
    }

    private KDPanel initToolBar() {
        KDPanel toolbar = new KDPanel();
        toolbar.setLayout((LayoutManager)new FlowLayout(2));
        KDButton btnOk = new KDButton("\u786e\u5b9a");
        KDButton btnCancel = new KDButton("\u53d6\u6d88");
        toolbar.add((Component)btnOk);
        toolbar.add((Component)btnCancel);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetricDialog.this.ok();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetricDialog.this.cancel();
            }
        });
        return toolbar;
    }

    private void typeChanged(final MetricType type) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MetricDialog.this.typeChanged0(type);
            }
        });
    }

    private void typeChanged0(MetricType type) {
        MetricUI ui = this.getUI(type, true);
        this.bodyPanel.removeAll();
        this.bodyPanel.setLayout((LayoutManager)new BorderLayout());
        this.bodyPanel.add((Component)((Object)ui), (Object)"Center");
        this.bodyPanel.validate();
        this.bodyPanel.repaint();
    }

    private MetricUI getUI(MetricType type, boolean create) {
        MetricUI ui = this.uiMap.get(type);
        if (ui == null && create) {
            ui = type.createMetricUI();
            ui.initUI();
            ui.setDataModel(this.dataModel);
            this.uiMap.put(type, ui);
            ui.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        }
        return ui;
    }

    public void setDataModel(DataModel2 dataModel) {
        this.dataModel = dataModel;
        if (this.uiMap.size() > 0) {
            Iterator<MetricUI> iter = this.uiMap.values().iterator();
            while (iter.hasNext()) {
                iter.next().setDataModel(dataModel);
            }
        } else {
            this.typeChanged((MetricType)this.cbType.getSelectedItem());
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            PivotUtils.makeCenter((Window)((Object)this));
        }
        super.setVisible(b);
    }

    private void ok() {
        MetricType type;
        MetricUI ui;
        String name = this.tfName.getText().trim();
        if (this.tfName.isEnabled()) {
            if (name.length() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "\u8bf7\u5b57\u6bb5\u540d\u79f0");
                this.tfName.requestFocusInWindow();
                return;
            }
            String[] fields = this.dataModel.getAllColumns();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equalsIgnoreCase(name)) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "\u540d\u79f0" + name + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                this.tfName.requestFocusInWindow();
                return;
            }
            Measure measure = this.dataModel.getMeasure(name);
            if (measure != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "\u540d\u79f0" + name + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                this.tfName.requestFocusInWindow();
                return;
            }
            if (this.dataModel.getMetric(name) != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "\u540d\u79f0" + name + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                this.tfName.requestFocusInWindow();
                return;
            }
        }
        if ((ui = this.uiMap.get(type = (MetricType)this.cbType.getSelectedItem())).verify((Window)((Object)this))) {
            this.metric = ui.getMetric(name, name);
            this.isOk = true;
            this.setVisible(false);
        }
    }

    private void cancel() {
        this.isOk = false;
        this.metric = null;
        this.setVisible(false);
    }

    public boolean isOk() {
        return this.isOk;
    }

    public Metric getMetric() {
        if (this.initMetric != null) {
            this.initMetric.spec = this.metric.spec;
            return this.initMetric;
        }
        return this.metric;
    }

    public void setInitMetric(Metric initMetric) {
        this.initMetric = initMetric;
        this.tfName.setText(initMetric.name);
        this.tfName.setEnabled(false);
        this.cbType.setSelectedItem((Object)initMetric.getType());
        this.cbType.setEnabled(false);
        MetricUI ui = this.getUI(initMetric.getType(), true);
        ui.setInitMetric(initMetric);
    }
}

