/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.metric;

import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.metric.MetricSpec;
import com.kingdee.bos.streamwork.metric.MetricType;
import com.kingdee.bos.streamwork.pivot.model.Dimension;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;

public class PercentMetric
extends Metric {
    public PercentMetric(String name, String caption, MetricSpec spec) {
        super(name, caption, spec);
    }

    @Override
    public MetricType getType() {
        return MetricType.PERCENT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getFormular(QueryModel queryModel) {
        String measure = this.spec.get("measure");
        if ((measure = this.checkMeasure(queryModel, measure)) == null) {
            return "0";
        }
        String dim = this.spec.get("dimension");
        if (dim != null) {
            if ((dim = this.checkDim(queryModel, dim)) == null) return "0";
            return "(" + this.quoteMeasure(measure) + "," + this.currentmember(dim) + ")/(" + this.quoteMeasure(measure) + "," + this.vall(dim) + ")";
        }
        String[] dims = queryModel.getDimensionNameOnRows().toArray(new String[0]);
        return this.currentmember(dims, measure) + "/" + this.vall(dims, measure);
    }

    private String checkDim(QueryModel queryModel, String name) {
        for (Dimension dim : queryModel.dimensionsOnRow) {
            if (!dim.name.equals(name)) continue;
            return name;
        }
        return null;
    }

    private String checkMeasure(QueryModel queryModel, String name) {
        for (Measure measure : queryModel.measures) {
            if (!measure.getId().equals(name)) continue;
            return name;
        }
        if (queryModel.metrics != null) {
            for (Metric metric : queryModel.metrics) {
                if (!metric.name.equals(name)) continue;
                return name;
            }
        }
        String another = null;
        for (Measure measure : queryModel.measures) {
            if (!measure.name.equals(name)) continue;
            if (another == null) {
                another = measure.getId();
                continue;
            }
            return null;
        }
        return another;
    }

    @Override
    public String getFormatString(int defaultScale) {
        String showPercent;
        String precision = this.spec.get("precision");
        if (precision != null) {
            defaultScale = Integer.parseInt(precision);
        }
        String fAmount = "#,###";
        if (defaultScale > 0) {
            fAmount = fAmount + ".";
            for (int i = 0; i < defaultScale; ++i) {
                fAmount = fAmount + "0";
            }
        }
        if ("true".equals(showPercent = this.spec.get("showPercent"))) {
            fAmount = fAmount + "%";
        }
        return fAmount;
    }

    private String vall(String dim) {
        return this.quote(dim) + ".[V$ALL]";
    }

    private String currentmember(String dim) {
        return this.quote(dim) + ".currentmember";
    }

    private String vall(String[] dims, String measure) {
        String result = "(" + this.quote(measure);
        for (int i = 0; i < dims.length; ++i) {
            if (i < dims.length) {
                result = result + ",";
            }
            result = result + this.vall(dims[i]);
        }
        result = result + ")";
        return result;
    }

    private String currentmember(String[] dims, String measure) {
        String result = "(" + this.quote(measure);
        for (int i = 0; i < dims.length; ++i) {
            if (i < dims.length) {
                result = result + ",";
            }
            result = result + this.currentmember(dims[i]);
        }
        result = result + ")";
        return result;
    }

    @Override
    public String[] getReference() {
        String measure = this.spec.get("measure");
        String dimension = this.spec.get("dimension");
        if (dimension == null) {
            return new String[]{measure};
        }
        return new String[]{measure, dimension};
    }
}

