/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import com.kingdee.bos.streamwork.pivot.worksheet.FileChooserUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class DetailListUI
extends JPanel {
    DataSource dataSource;
    QueryModel queryModel;
    private Map memberContext;
    FactTable factTable;
    int rowCount = 0;
    int showCountMax = 10000;
    int showCount;
    KDLabelContainer lcFilterInfo;
    KDTextArea taFilterInfo;
    KDLabel labelCount;
    KDTable table;
    boolean initHeader = false;
    private MyRender myRender = new MyRender();
    KDTMouseListener mouseListener = new KDTMouseListener(){

        public void tableClicked(KDTMouseEvent e) {
            int row = e.getRowIndex();
            int column = e.getColIndex();
            if (row >= 0 && column >= 0 && SwingUtilities.isRightMouseButton((MouseEvent)e)) {
                DetailListUI.this.popup(DetailListUI.this.table, row, column, e.getOriginView(), e.getX(), e.getY(), e.getType() == 0);
            }
        }
    };
    JPopupMenu popupMenu;
    private FileChooserUtil chooser;

    public DetailListUI(DataSource dataSource, QueryModel queryModel) {
        this.dataSource = dataSource;
        this.queryModel = queryModel;
        this.initUI();
    }

    public void setMemberContext(Map memberContext) {
        this.memberContext = memberContext;
        try {
            this.buildData();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void buildData() throws CUBAException {
        this.factTable = new FactTable();
        while (this.factTable.next()) {
            ++this.rowCount;
        }
        this.factTable.close();
    }

    public void initUI() {
        this.taFilterInfo = new KDTextArea();
        this.taFilterInfo.setFocusable(false);
        this.taFilterInfo.setBackground(Color.WHITE);
        this.taFilterInfo.setSelectAllOnFocus(false);
        KDScrollPane sp = new KDScrollPane((Component)this.taFilterInfo);
        this.table = new KDTable();
        this.table.setAutoscrolls(true);
        this.table.addKDTMouseListener(this.mouseListener);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)new KDLabelContainer("\u8fc7\u6ee4\u6761\u4ef6:    ", (JComponent)this.taFilterInfo), "North");
        this.labelCount = new KDLabel();
        Font f = this.labelCount.getFont();
        f = f.deriveFont(1);
        this.labelCount.setFont(f);
        KDPanel p2 = new KDPanel();
        p2.setLayout((LayoutManager)new BorderLayout());
        p2.add((Component)this.labelCount, (Object)"North");
        p2.add((Component)this.table, (Object)"Center");
        this.add((Component)p2, "Center");
    }

    public void refreshUI() {
        String filterInfo = "";
        filterInfo = filterInfo + this.memberContext.toString();
        this.taFilterInfo.setRows(this.memberContext.size());
        this.taFilterInfo.setText("");
        int index = 0;
        Iterator iter = this.memberContext.entrySet().iterator();
        while (iter.hasNext()) {
            ++index;
            Map.Entry entry = iter.next();
            String str = (String)entry.getKey() + ":";
            List values = (List)entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                if (value == null) {
                    value = "(\u7a7a\u767d)";
                }
                if (value instanceof Date) {
                    value = PivotUtils.formatSimpleDate((Date)value);
                }
                str = i > 0 ? str + "," + value : str + value;
            }
            this.taFilterInfo.append(str);
            if (index >= this.memberContext.size()) continue;
            this.taFilterInfo.append("\r\n");
        }
        if (!this.initHeader) {
            this.initHeader = true;
            String[] headerName = null;
            try {
                headerName = this.factTable.getColumnNames();
            }
            catch (CUBAException e) {
                e.printStackTrace();
            }
            IRow row = this.table.addHeadRow();
            for (int i = 0; i < headerName.length; ++i) {
                this.table.addColumn();
                row.getCell(i).setValue((Object)headerName[i]);
                this.table.getColumn(i).setRenderer((IBasicRender)this.myRender);
            }
        }
        this.table.removeRows();
        this.requestData();
        this.table.requestFocus(true);
        this.table.getSelectManager().select(0, 0);
        this.table.setEditable(false);
    }

    protected void requestData() {
        int index = 0;
        try {
            this.factTable.close();
            int columnCount = this.factTable.getColumnCount();
            boolean overflow = false;
            while (this.factTable.next()) {
                Object[] values = this.factTable.getValues();
                IRow tableRow = this.table.addRow();
                for (int i = 0; i < columnCount; ++i) {
                    Object value = values[i];
                    tableRow.getCell(i).setValue(value);
                }
                if (++index < this.showCountMax) continue;
                overflow = true;
                break;
            }
            this.showCount = index;
            if (overflow) {
                this.labelCount.setText("\u5171" + this.rowCount + "\u884c,\u53ea\u663e\u793a\u524d" + this.showCount + "\u6761");
            } else {
                this.labelCount.setText("\u5171" + this.rowCount + "\u884c");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void popup(KDTable table, int row, int column, Component originView, int x, int y, boolean b) {
        this.getPopupMenu().show((Component)table, x + 30, y + 30);
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new AbstractAction("\u5bfc\u51faExcel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailListUI.this.export2Excel();
                }
            });
        }
        return this.popupMenu;
    }

    public void export2Excel() {
        if (this.chooser == null) {
            this.chooser = new FileChooserUtil(PivotUtils.getMainFrame());
        }
        ExportManager man = new ExportManager();
        man.setExporterParmeter(ExporterParameter.BOOK_LOCKED, (Object)Boolean.FALSE);
        man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
        man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
        File f = this.chooser.saveFile("\u5bfc\u51fa\u5230Excel", "xls", "Excel\u683c\u5f0f\u6587\u4ef6(xls)");
        if (f != null) {
            KDSBook book = null;
            book = new KDSBook("kdtable export");
            String fileName = f.getAbsolutePath();
            if (!fileName.toLowerCase().endsWith(".xls")) {
                fileName = fileName + ".xls";
            }
            try {
                book.addSheet(null, this.table.getIOManager().saveToKDSSheet(book, true, false, false, this.table.getName() == null ? "Sheet 1" : this.table.getName()));
                man.exportToExcel(book, fileName);
                int r = JOptionPane.showConfirmDialog(PivotUtils.getMainFrame(), fileName + "\n" + "\u4fdd\u5b58\u6210\u529f,\u73b0\u5728\u6253\u5f00\u5417?", "\u63d0\u793a", 0);
                if (r == 0 || r == 0) {
                    Runtime.getRuntime().exec("explorer " + fileName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(PivotUtils.getMainFrame(), "\u5bfc\u51fa\u5931\u8d25,\u6587\u4ef6\u6b63\u5728\u4f7f\u7528,\u8bf7\u5148\u5173\u95ed\u518d\u91cd\u8bd5.");
                return;
            }
        }
    }

    class FactTable
    implements Table {
        String[] header;
        HashMap<String, Integer> indexMap = new HashMap();
        int[] dataTypes;
        int dataSourceRowCount;
        HashSet[] valuesSelectedList;
        private int cursor = -1;
        private Object[] row = null;

        public FactTable() {
            int i;
            this.header = DetailListUI.this.dataSource.getColumnNames();
            ArrayList<String> measureNames = new ArrayList<String>();
            for (i = 0; i < DetailListUI.this.queryModel.measures.length; ++i) {
                measureNames.add(DetailListUI.this.queryModel.measures[i].name);
            }
            this.dataTypes = new int[this.header.length];
            for (i = 0; i < this.header.length; ++i) {
                String name = this.header[i];
                this.indexMap.put(name, i);
                this.dataTypes[i] = measureNames.contains(name) ? 2 : 12;
            }
            if (DetailListUI.this.memberContext != null) {
                this.valuesSelectedList = new HashSet[this.header.length];
                for (i = 0; i < this.header.length; ++i) {
                    ArrayList list = (ArrayList)DetailListUI.this.memberContext.get(this.header[i]);
                    if (list == null) continue;
                    HashSet set = new HashSet();
                    set.addAll(list);
                    this.valuesSelectedList[i] = set;
                }
            }
            this.dataSourceRowCount = DetailListUI.this.dataSource.getRowCount();
        }

        @Override
        public int getColumnCount() throws CUBAException {
            return this.header.length;
        }

        @Override
        public int getColumnType(int index) throws CUBAException {
            return this.dataTypes[index];
        }

        @Override
        public int getColumnIndex(String name) throws CUBAException {
            return this.indexMap.get(name);
        }

        @Override
        public String[] getColumnNames() throws CUBAException {
            return this.header;
        }

        @Override
        public boolean next() throws CUBAException {
            do {
                ++this.cursor;
                if (this.cursor >= this.dataSourceRowCount) {
                    return false;
                }
                this.row = this.getRow(this.cursor);
            } while (!this.isGoodRow());
            return true;
        }

        private Object[] getRow(int cursor) {
            int columnCount = DetailListUI.this.dataSource.getColumnNames().length;
            Object[] array = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                array[i] = DetailListUI.this.dataSource.getCell(i, cursor);
            }
            return array;
        }

        @Override
        public Object getValue(int index) throws CUBAException {
            return this.row[index];
        }

        @Override
        public Object[] getValues() throws CUBAException {
            return this.row;
        }

        @Override
        public void close() {
            this.cursor = -1;
        }

        public boolean isGoodRow() {
            if (this.valuesSelectedList == null) {
                return true;
            }
            for (int i = 0; i < this.valuesSelectedList.length; ++i) {
                if (this.valuesSelectedList[i] == null || this.valuesSelectedList[i].contains(this.row[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class MyRender
    extends CellTextRender {
        private MyRender() {
        }

        public void draw(Graphics graphics, Shape clip, Object value, Style cellStyle) {
            if (value instanceof Number) {
                value = NumberFormat.getInstance().format((Number)value);
            } else if (value instanceof Date) {
                value = PivotUtils.formatSimpleDate((Date)value);
            }
            super.draw(graphics, clip, value, cellStyle);
        }
    }
}

