/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.streamwork.pivot.Location;
import com.kingdee.bos.streamwork.pivot.excelui.CheckItemOption;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItem;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItemWidget;
import com.kingdee.bos.streamwork.pivot.excelui.FilterItemWidget;
import com.kingdee.bos.streamwork.pivot.excelui.MemberSelectTreeDialog;
import com.kingdee.bos.streamwork.pivot.excelui.MemberSelectTreePanel;
import com.kingdee.bos.streamwork.pivot.excelui.WidgetListener;
import com.kingdee.bos.streamwork.pivot.model.ColumnValues;
import com.kingdee.bos.streamwork.pivot.model.DataModel;
import com.kingdee.bos.streamwork.pivot.model.DataType;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ExcelPivotConditionPanel
extends KDPanel {
    public CheckedItemWidget fieldListWidget;
    public CheckedItemWidget filterWidget;
    public CheckedItemWidget rowLabelWidget;
    public CheckedItemWidget columnLabelWidget;
    public CheckedItemWidget metricWidget;
    private CheckedItemWidget[] fourWidgets;
    private FilterItemWidget filterItemWidget;
    KDSplitPane splitPane;
    private DataModel dataModel;
    MemberSelectTreeDialog memberSelectTreeDialog;
    ArrayList<String> allColumns = new ArrayList();
    private ConditionListener conditionListener;

    public ExcelPivotConditionPanel(DataModel dataModel, FilterItemWidget filterItemWidget, ConditionListener conditionListener) {
        this.dataModel = dataModel;
        this.filterItemWidget = filterItemWidget;
        this.conditionListener = conditionListener;
        CheckItemOption option1 = CheckItemOption.getCheckItemOptionForFieldList();
        option1.location = Location.FIELDLIST;
        this.fieldListWidget = new CheckedItemWidget(option1, dataModel);
        CheckItemOption option2 = CheckItemOption.getCheckItemOptionForLabelList();
        option2.title = "\u62a5\u8868\u7b5b\u9009";
        option2.location = Location.FILTER;
        this.filterWidget = new CheckedItemWidget(option2, dataModel);
        option2 = CheckItemOption.getCheckItemOptionForLabelList();
        option2.title = "\u884c\u6807\u7b7e";
        option2.location = Location.ROWLABEL;
        this.rowLabelWidget = new CheckedItemWidget(option2, dataModel);
        option2 = CheckItemOption.getCheckItemOptionForLabelList();
        option2.title = "\u5217\u6807\u7b7e";
        option2.location = Location.COLUMNLABEL;
        this.columnLabelWidget = new CheckedItemWidget(option2, dataModel);
        option2 = CheckItemOption.getCheckItemOptionForLabelList();
        option2.title = "\u6570\u503c";
        option2.location = Location.METRIC;
        this.metricWidget = new CheckedItemWidget(option2, dataModel);
        KDPanel fieldListWidgetPanel = new KDPanel();
        fieldListWidgetPanel.setLayout((LayoutManager)new BorderLayout());
        fieldListWidgetPanel.add((Component)new KDLabel("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u5230\u62a5\u8868\u4e2d\u7684\u5b57\u6bb5:"), (Object)"North");
        fieldListWidgetPanel.add((Component)this.fieldListWidget, (Object)"Center");
        fieldListWidgetPanel.setBorder((Border)new EmptyBorder(2, 2, 6, 2));
        KDPanel fourLabelPanel = new KDPanel();
        fourLabelPanel.setLayout((LayoutManager)new GridLayout(2, 2, 4, 4));
        fourLabelPanel.add((Component)this.filterWidget);
        fourLabelPanel.add((Component)this.columnLabelWidget);
        fourLabelPanel.add((Component)this.rowLabelWidget);
        fourLabelPanel.add((Component)this.metricWidget);
        this.fourWidgets = new CheckedItemWidget[]{this.filterWidget, this.columnLabelWidget, this.rowLabelWidget, this.metricWidget};
        KDPanel fourLabelPanelWithTitle = new KDPanel();
        fourLabelPanelWithTitle.setLayout((LayoutManager)new BorderLayout());
        fourLabelPanelWithTitle.add((Component)new KDLabel("\u5728\u4ee5\u4e0b\u533a\u57df\u95f4\u62d6\u52a8\u5b57\u6bb5:"), (Object)"North");
        fourLabelPanelWithTitle.add((Component)fourLabelPanel, (Object)"Center");
        fourLabelPanelWithTitle.setBorder((Border)new EmptyBorder(2, 2, 2, 2));
        this.splitPane = new KDSplitPane(0, (Component)fieldListWidgetPanel, (Component)fourLabelPanelWithTitle);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setDividerSize(5);
        this.splitPane.setDividerBackground(new Color(175, 222, 250));
        this.splitPane.setDividerOpaque(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        String[] columns = this.dataModel.getColumns();
        this.allColumns.addAll(Arrays.asList(columns));
        this.fieldListWidget.setCheckedItems(columns);
        Measure[] measures = this.dataModel.getMeasures();
        columns = new String[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            columns[i] = measures[i].name;
        }
        this.metricWidget.setCheckedItems(new String[0]);
        this.filterWidget.setCheckedItems(new String[0]);
        this.rowLabelWidget.setCheckedItems(new String[0]);
        this.columnLabelWidget.setCheckedItems(new String[0]);
    }

    private void initListener() {
        this.fieldListWidget.setWidgetListener(new WidgetListener(){

            @Override
            public void selectedChanged(CheckedItem checkedItem, boolean selected) {
                ExcelPivotConditionPanel.this.selectedChanged_fieldListWidget(checkedItem, selected);
            }

            @Override
            public void menuClicked(CheckedItem item) {
                ExcelPivotConditionPanel.this.commonMenuClicked(item, ExcelPivotConditionPanel.this.fieldListWidget);
            }

            @Override
            public void itemRemoved(CheckedItem checkedItem) {
            }

            @Override
            public void itemMoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemMoved(checkedItem, ExcelPivotConditionPanel.this.fieldListWidget);
            }

            @Override
            public void itemAdded(CheckedItem checkedItem) {
            }
        });
        this.filterWidget.setWidgetListener(new WidgetListener(){

            @Override
            public void selectedChanged(CheckedItem checkedItem, boolean selected) {
            }

            @Override
            public void menuClicked(CheckedItem item) {
            }

            @Override
            public void itemRemoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemRemoved(checkedItem, ExcelPivotConditionPanel.this.filterWidget);
            }

            @Override
            public void itemMoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemMoved(checkedItem, ExcelPivotConditionPanel.this.filterWidget);
            }

            @Override
            public void itemAdded(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.itemAdded_filterWidget(checkedItem);
            }
        });
        this.rowLabelWidget.setWidgetListener(new WidgetListener(){

            @Override
            public void selectedChanged(CheckedItem checkedItem, boolean selected) {
            }

            @Override
            public void menuClicked(CheckedItem item) {
            }

            @Override
            public void itemRemoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemRemoved(checkedItem, ExcelPivotConditionPanel.this.rowLabelWidget);
            }

            @Override
            public void itemMoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemMoved(checkedItem, ExcelPivotConditionPanel.this.rowLabelWidget);
            }

            @Override
            public void itemAdded(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.itemAdded_rowLabelWidget(checkedItem);
            }
        });
        this.columnLabelWidget.setWidgetListener(new WidgetListener(){

            @Override
            public void selectedChanged(CheckedItem checkedItem, boolean selected) {
            }

            @Override
            public void menuClicked(CheckedItem item) {
            }

            @Override
            public void itemRemoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemRemoved(checkedItem, ExcelPivotConditionPanel.this.columnLabelWidget);
            }

            @Override
            public void itemAdded(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.itemAdded_columnLabelWidget(checkedItem);
            }

            @Override
            public void itemMoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemMoved(checkedItem, ExcelPivotConditionPanel.this.columnLabelWidget);
            }
        });
        this.metricWidget.setWidgetListener(new WidgetListener(){

            @Override
            public void selectedChanged(CheckedItem checkedItem, boolean selected) {
            }

            @Override
            public void menuClicked(CheckedItem item) {
            }

            @Override
            public void itemRemoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemRemoved(checkedItem, ExcelPivotConditionPanel.this.metricWidget);
            }

            @Override
            public void itemMoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemMoved(checkedItem, ExcelPivotConditionPanel.this.metricWidget);
            }

            @Override
            public void itemAdded(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.itemAdded_metricWidget(checkedItem);
            }
        });
        this.filterItemWidget.setWidgetListener(new WidgetListener(){

            @Override
            public void selectedChanged(CheckedItem checkedItem, boolean selected) {
            }

            @Override
            public void menuClicked(CheckedItem item) {
                ExcelPivotConditionPanel.this.commonMenuClicked(item, ExcelPivotConditionPanel.this.filterItemWidget);
            }

            @Override
            public void itemRemoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemRemoved(checkedItem, ExcelPivotConditionPanel.this.filterItemWidget);
            }

            @Override
            public void itemMoved(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.commonItemMoved(checkedItem, ExcelPivotConditionPanel.this.filterItemWidget);
            }

            @Override
            public void itemAdded(CheckedItem checkedItem) {
                ExcelPivotConditionPanel.this.itemAdded_filterItemWidget(checkedItem);
            }
        });
    }

    protected void commonItemMoved(CheckedItem checkedItem, FilterItemWidget filterItemWidget) {
        String[] names = filterItemWidget.getAllCheckedItemNames();
        this.filterWidget.setCheckedItems(names);
    }

    protected void commonItemMoved(CheckedItem checkedItem, CheckedItemWidget widget) {
        if (widget == this.rowLabelWidget || widget == this.columnLabelWidget || widget == this.metricWidget) {
            this.conditionChanged();
        } else if (widget == this.filterWidget) {
            String[] names = this.filterWidget.getAllCheckedItemNames();
            this.filterItemWidget.setCheckedItems(names);
        }
    }

    MemberSelectTreeDialog getMemberSelectTreeDialog() {
        if (this.memberSelectTreeDialog == null) {
            this.memberSelectTreeDialog = MemberSelectTreeDialog.createMemberSelectTreeDialog((JComponent)((Object)this), this.dataModel);
        }
        return this.memberSelectTreeDialog;
    }

    protected void commonMenuClicked(CheckedItem item, FilterItemWidget filterItemWidget) {
        boolean success = false;
        success = this.getMemberSelectTreeDialog().showForItem(this.dataModel, item.name, MemberSelectTreePanel.TYPE_ONFILTER);
        if (success) {
            this.conditionChanged();
        }
    }

    public void commonMenuClicked(CheckedItem item, CheckedItemWidget widget) {
        boolean success = false;
        if (widget == this.fieldListWidget) {
            if (!item.selected) {
                success = this.getMemberSelectTreeDialog().showForItem(this.dataModel, item.name, MemberSelectTreePanel.TYPE_NOTSHOW);
            } else if (this.filterWidget.containsCheckedItem(item.name)) {
                success = this.getMemberSelectTreeDialog().showForItem(this.dataModel, item.name, MemberSelectTreePanel.TYPE_ONFILTER);
                this.filterWidget.refreshFilterIcon();
            } else if (this.rowLabelWidget.containsCheckedItem(item.name) || this.columnLabelWidget.containsCheckedItem(item.name)) {
                success = this.getMemberSelectTreeDialog().showForItem(this.dataModel, item.name, MemberSelectTreePanel.TYPE_ONROWCOLUMN);
            }
            this.fieldListWidget.getCheckedItemPanel(item.name).refreshFilterIcon();
            if (success) {
                this.conditionChanged();
            }
        }
    }

    private void commonItemAdded(CheckedItem checkedItem) {
        this.fieldListWidget.setSelected(checkedItem.name, true, false);
    }

    private void commonItemRemoved(CheckedItem checkedItem, CheckedItemWidget widget) {
        ArrayList<CheckedItemWidget> list = new ArrayList<CheckedItemWidget>();
        list.add(widget);
        if (widget == this.filterWidget) {
            this.filterItemWidget.removeCheckedItem(checkedItem.name);
        }
        if (!this.getAllShowColumnsExcept(list).contains(checkedItem.name)) {
            this.fieldListWidget.setSelected(checkedItem.name, false, false);
        }
        this.conditionChanged();
    }

    private void commonItemRemoved(CheckedItem checkedItem, FilterItemWidget widget) {
        ArrayList<CheckedItemWidget> list = new ArrayList<CheckedItemWidget>();
        list.add((CheckedItemWidget)((Object)widget));
        this.filterWidget.removeCheckedItem(checkedItem.name);
        if (!this.getAllShowColumnsExcept(list).contains(checkedItem.name)) {
            this.fieldListWidget.setSelected(checkedItem.name, false, false);
        }
        this.conditionChanged();
    }

    protected void itemAdded_filterWidget(CheckedItem checkedItem) {
        this.commonItemAdded(checkedItem);
        this.rowLabelWidget.removeCheckedItem(checkedItem.name);
        this.columnLabelWidget.removeCheckedItem(checkedItem.name);
        this.metricWidget.removeCheckedItem(checkedItem.name);
        this.filterItemWidget.addCheckedItem(checkedItem.name);
        this.conditionChanged();
    }

    protected void itemAdded_filterItemWidget(CheckedItem checkedItem) {
        this.commonItemAdded(checkedItem);
        this.rowLabelWidget.removeCheckedItem(checkedItem.name);
        this.columnLabelWidget.removeCheckedItem(checkedItem.name);
        this.metricWidget.removeCheckedItem(checkedItem.name);
        this.filterWidget.addCheckedItem(checkedItem.name);
        this.conditionChanged();
    }

    protected void itemAdded_metricWidget(CheckedItem checkedItem) {
        this.commonItemAdded(checkedItem);
        this.rowLabelWidget.removeCheckedItem(checkedItem.name);
        this.columnLabelWidget.removeCheckedItem(checkedItem.name);
        this.filterWidget.removeCheckedItem(checkedItem.name);
        this.filterItemWidget.removeCheckedItem(checkedItem.name);
        this.conditionChanged();
    }

    protected void itemAdded_columnLabelWidget(CheckedItem checkedItem) {
        this.commonItemAdded(checkedItem);
        this.rowLabelWidget.removeCheckedItem(checkedItem.name);
        this.filterWidget.removeCheckedItem(checkedItem.name);
        this.filterItemWidget.removeCheckedItem(checkedItem.name);
        this.metricWidget.removeCheckedItem(checkedItem.name);
        this.conditionChanged();
    }

    protected void itemAdded_rowLabelWidget(CheckedItem checkedItem) {
        this.commonItemAdded(checkedItem);
        this.columnLabelWidget.removeCheckedItem(checkedItem.name);
        this.filterWidget.removeCheckedItem(checkedItem.name);
        this.filterItemWidget.removeCheckedItem(checkedItem.name);
        this.metricWidget.removeCheckedItem(checkedItem.name);
        this.conditionChanged();
    }

    protected void selectedChanged_fieldListWidget(CheckedItem checkedItem, boolean selected) {
        if (selected) {
            ColumnValues cv = this.dataModel.getColumnValues(checkedItem.name);
            if (DataType.isNumber(cv.getDataType())) {
                this.metricWidget.addCheckedItem(checkedItem.name);
            } else {
                this.rowLabelWidget.addCheckedItem(checkedItem.name);
            }
        } else {
            this.filterWidget.removeCheckedItem(checkedItem.name);
            this.filterItemWidget.removeCheckedItem(checkedItem.name);
            this.rowLabelWidget.removeCheckedItem(checkedItem.name);
            this.columnLabelWidget.removeCheckedItem(checkedItem.name);
            this.metricWidget.removeCheckedItem(checkedItem.name);
        }
        this.conditionChanged();
    }

    public void conditionChanged() {
        this.conditionListener.conditionChanged();
    }

    private ArrayList<String> getAllShowColumnsExcept(ArrayList<CheckedItemWidget> exceptWidgets) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.fourWidgets.length; ++i) {
            if (exceptWidgets.contains(this.fourWidgets[i])) continue;
            list.addAll(Arrays.asList(this.fourWidgets[i].getAllCheckedItemNames()));
        }
        return list;
    }

    public QueryModel getQueryModel() {
        String[] onRows = this.rowLabelWidget.getAllCheckedItemNames();
        String[] onColumns = this.columnLabelWidget.getAllCheckedItemNames();
        String[] onMetrics = this.metricWidget.getAllCheckedItemNames();
        this.dataModel.setSelectedDimensionOnRows(onRows);
        this.dataModel.setSelectedDimensionOnColumns(onColumns);
        this.dataModel.setSelectedMeasures(onMetrics);
        CheckedItem[] measureItems = this.metricWidget.getAllCheckedItems();
        ArrayList<Measure> measures = new ArrayList<Measure>();
        for (int i = 0; i < measureItems.length; ++i) {
            String column = measureItems[i].name;
            Measure measure = this.dataModel.createMeasure(measureItems[i].name);
            measure.caption = measureItems[i].getCaption(this.dataModel);
            measure.aggType = measureItems[i].aggType;
            measure.dataType = this.dataModel.getColumnValues(column).getDataType();
            measures.add(measure);
        }
        this.dataModel.setMeasures(measures.toArray(new Measure[0]));
        QueryModel queryModel = this.dataModel.getQueryModel();
        if (queryModel == null) {
            return queryModel;
        }
        String[] onRowsAndColumns = new String[onRows.length + onColumns.length];
        System.arraycopy(onRows, 0, onRowsAndColumns, 0, onRows.length);
        System.arraycopy(onColumns, 0, onRowsAndColumns, onRows.length, onColumns.length);
        return queryModel;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public CheckedItemWidget getFieldListWidget() {
        return this.fieldListWidget;
    }

    public static interface ConditionListener {
        public void conditionChanged();
    }
}

