/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.easui;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.dao.query.server.analysis.DateUtil;
import com.kingdee.bos.streamwork.cuba.InnerMemberFactory;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.easui.ValueSelectContainer;
import com.kingdee.bos.streamwork.pivot.model.ColumnValues;
import com.kingdee.bos.streamwork.pivot.model.DataModelSupport2;
import com.kingdee.bos.streamwork.pivot.resource.Icons;
import com.kingdee.bos.streamwork.pivot.resource.Resources;
import com.kingdee.bos.streamwork.pivot.ui.BackgroundTextPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ValueSelectWidget
extends KDPanel {
    private DataModelSupport2 dataModelSupport;
    private String dim;
    ValueSelectContainer parentContainer;
    private ColumnValues cv;
    private KDLabel labName;
    private KDLabel labClose;
    private KDList list;
    private KDScrollPane scrollPane;
    private KDLabel labResizeTag;
    private KDPanel bodyPanel = new KDPanel();
    private JPanel searchPanel = null;
    private static final Cursor CURSOR_DEFAULT = Cursor.getDefaultCursor();
    private static final Cursor CURSOR_RESIZE = Cursor.getPredefinedCursor(11);
    private static final Cursor CURSOR_MOVE = Cursor.getPredefinedCursor(13);
    private static final Cursor CURSOR_DRAG = Toolkit.getDefaultToolkit().createCustomCursor(Icons.createImage("icon/cursors/mos_movedrop.gif"), new Point(0, 0), "CanDrop");
    private static final Cursor CURSOR_FORBID = Toolkit.getDefaultToolkit().createCustomCursor(Icons.createImage("icon/cursors/cursor_lock.gif"), new Point(0, 0), "Forbid");
    final KDTextField tf = new KDTextField(10);
    private String lastText = null;
    private int wOld = 0;
    private int hOld = 0;
    private boolean isDraged;
    private int xPress;
    private int yPress;
    private boolean onChange = false;
    private int[] beforeSelectedIndices;
    private boolean selectChanged;

    public ValueSelectWidget(ValueSelectContainer parentContainer, DataModelSupport2 dataModelSupport, String dim) {
        this.parentContainer = parentContainer;
        this.dataModelSupport = dataModelSupport;
        this.dim = dim;
        this.initUI();
    }

    public String getDimensionName() {
        return this.dim;
    }

    public KDList getKDList() {
        return this.list;
    }

    public void initUI() {
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.labName = new KDLabel(this.dim);
        this.labName.setPreferredSize(new Dimension(1, 15));
        this.labName.setOpaque(true);
        this.labName.setHorizontalAlignment(0);
        this.setMouseIcon((JComponent)this.labName, CURSOR_MOVE);
        this.labClose = new KDLabel();
        this.labClose.setIcon(Resources.getIcon("icon/tbtn_close3.gif"));
        this.labClose.setCursor(Cursor.getPredefinedCursor(12));
        this.labResizeTag = new KDLabel();
        this.labResizeTag.setPreferredSize(new Dimension(2, 5));
        this.labResizeTag.setHorizontalAlignment(2);
        this.labResizeTag.setVerticalAlignment(1);
        this.setMouseIcon((JComponent)this.labResizeTag, CURSOR_RESIZE);
        this.list = new KDList();
        this.list.setUserObject((Object)this);
        this.cv = this.dataModelSupport.getColumnValues(this.dim);
        Collections.sort(this.cv.getValues());
        this.loadData(this.cv.getValues());
        this.list.setSelectionMode(2);
        this.scrollPane = new KDScrollPane((Component)this.list);
        this.searchPanel = new BackgroundTextPanel("\u8f93\u5165\u5173\u952e\u5b57\u641c\u7d22");
        this.bodyPanel.setLayout((LayoutManager)new BorderLayout());
        this.bodyPanel.add((Component)this.scrollPane, (Object)"Center");
        this.bodyPanel.add((Component)this.searchPanel, (Object)"North");
        this.setLayout(new BorderLayout());
        KDPanel topPanel = new KDPanel();
        topPanel.setLayout((LayoutManager)new BorderLayout());
        topPanel.add((Component)this.labName, (Object)"Center");
        topPanel.add((Component)this.labClose, (Object)"East");
        this.add((Component)topPanel, "North");
        this.add((Component)this.bodyPanel, "Center");
        this.add((Component)this.labResizeTag, "East");
        this.initSearchUI();
        this.installListener();
        this.setMaximumSize(new Dimension(250, 200));
        this.setMinimumSize(new Dimension(120, 100));
        this.setPreferredSize(this.caculateDefaultSize());
        this.list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Boolean) {
                    value = (Boolean)value != false ? "\u662f" : "\u5426";
                } else if (value instanceof Date) {
                    value = DateUtil.formatSimpleDate((Date)value);
                }
                value = "" + (index + 1) + ": " + value;
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
    }

    private void initSearchUI() {
        Icon icon = Resources.getIcon("icon/filter.png");
        KDLabel lblFilter = new KDLabel("");
        lblFilter.setIcon(icon);
        KDLabel lblLeft = new KDLabel(" ");
        final KDTextPane taFormula = new KDTextPane();
        this.searchPanel.setLayout(new BorderLayout());
        this.searchPanel.add((Component)this.tf, "Center");
        this.searchPanel.add((Component)lblFilter, "East");
        this.searchPanel.add((Component)lblLeft, "West");
        this.searchPanel.requestFocus(false);
        taFormula.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        taFormula.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ValueSelectWidget.this.searchChanged(taFormula.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ValueSelectWidget.this.searchChanged(taFormula.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ValueSelectWidget.this.searchChanged(taFormula.getText());
            }
        });
        this.tf.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    ValueSelectWidget.this.goToList();
                } else {
                    ValueSelectWidget.this.searchChanged(ValueSelectWidget.this.tf.getText());
                }
            }
        });
        this.list.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    ValueSelectWidget.this.goToSearch();
                } else if (e.getKeyCode() == 27) {
                    ValueSelectWidget.this.list.clearSelection();
                    ValueSelectWidget.this.tf.requestFocus(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void goToSearch() {
        if (this.list.getSelectedIndex() == 0) {
            this.list.clearSelection();
            this.tf.requestFocus(false);
        }
    }

    private void goToList() {
        if (this.list.getModel().getSize() > 0) {
            this.list.requestFocus();
            this.list.setSelectedIndex(0);
        }
    }

    protected void searchChanged(String text) {
        int[] indices;
        if ((text = text.trim()).equals(this.lastText)) {
            return;
        }
        this.lastText = text;
        Object[] selectedValues = this.list.getSelectedValues();
        List values = this.filterData(text);
        this.list.clearSelection();
        this.loadData(values);
        boolean contains = false;
        int pos = 0;
        Object v2 = null;
        for (Object v2 : values) {
            if (v2.toString().equalsIgnoreCase(text)) {
                contains = true;
                break;
            }
            ++pos;
        }
        if (contains) {
            indices = new int[]{pos};
            this.list.setSelectedIndices(indices);
            selectedValues = new Object[]{v2};
            this.dataModelSupport.setSelectedValues(this.dim, selectedValues);
            return;
        }
        if (values.size() == 1) {
            indices = new int[]{0};
            this.list.setSelectedIndices(indices);
            selectedValues = new Object[]{values.get(0)};
            this.dataModelSupport.setSelectedValues(this.dim, selectedValues);
            return;
        }
        this.dataModelSupport.setSelectedValues(this.dim, null);
    }

    private List filterData(String text) {
        if ("".equals(text)) {
            return this.cv.getValues();
        }
        text = PivotUtils.replace(text, " and ", " ", Integer.MAX_VALUE);
        boolean or = false;
        if (text.toLowerCase().contains(" or ") || text.contains("|")) {
            or = true;
            text = PivotUtils.replace(text, " or ", " ", Integer.MAX_VALUE);
            text = PivotUtils.replace(text, " oR ", " ", Integer.MAX_VALUE);
            text = PivotUtils.replace(text, " OR ", " ", Integer.MAX_VALUE);
            text = PivotUtils.replace(text, " Or ", " ", Integer.MAX_VALUE);
            text = PivotUtils.replace(text, " | ", " ", Integer.MAX_VALUE);
            text = PivotUtils.replace(text, " |", " ", Integer.MAX_VALUE);
            text = PivotUtils.replace(text, "| ", " ", Integer.MAX_VALUE);
            text = PivotUtils.replace(text, "|", " ", Integer.MAX_VALUE);
        }
        if (text.toLowerCase().endsWith(" or")) {
            text = text.substring(0, text.length() - 3);
        }
        if (text.toLowerCase().endsWith(" and")) {
            text = text.substring(0, text.length() - 4);
        }
        String[] parts = text.split(" ");
        ArrayList values = new ArrayList();
        for (Object v : this.cv.getValues()) {
            boolean contains = true;
            for (int i = 0; i < parts.length; ++i) {
                block33: {
                    if (parts[i].length() == 0 || "=".equals(parts[i]) || "<".equals(parts[i]) || ">".equals(parts[i]) || ">=".equals(parts[i]) || "<=".equals(parts[i])) continue;
                    if (v instanceof Number) {
                        if (parts[i].length() > 2 && parts[i].startsWith(">=")) {
                            double v1 = ((Number)v).doubleValue();
                            try {
                                double v2 = Double.parseDouble(parts[i].substring(2));
                                if (v1 < v2) {
                                    contains = false;
                                }
                                break block33;
                            }
                            catch (Throwable t) {
                                contains = false;
                            }
                            continue;
                        }
                        if (parts[i].length() > 2 && parts[i].startsWith("<=")) {
                            double v1 = ((Number)v).doubleValue();
                            try {
                                double v2 = Double.parseDouble(parts[i].substring(2));
                                if (v1 > v2) {
                                    contains = false;
                                }
                                break block33;
                            }
                            catch (Throwable t) {
                                contains = false;
                            }
                            continue;
                        }
                        if (parts[i].length() > 1 && parts[i].startsWith(">")) {
                            double v1 = ((Number)v).doubleValue();
                            try {
                                double v2 = Double.parseDouble(parts[i].substring(1));
                                if (v1 <= v2) {
                                    contains = false;
                                }
                                break block33;
                            }
                            catch (Throwable t) {
                                contains = false;
                            }
                            continue;
                        }
                        if (parts[i].length() > 1 && parts[i].startsWith("<")) {
                            double v1 = ((Number)v).doubleValue();
                            try {
                                double v2 = Double.parseDouble(parts[i].substring(1));
                                if (v1 >= v2) {
                                    contains = false;
                                }
                                break block33;
                            }
                            catch (Throwable t) {
                                contains = false;
                            }
                            continue;
                        }
                        if (parts[i].length() > 1 && parts[i].startsWith("=")) {
                            double v1 = ((Number)v).doubleValue();
                            try {
                                double v2 = Double.parseDouble(parts[i].substring(1));
                                if (v2 != v1) {
                                    contains = false;
                                }
                                break block33;
                            }
                            catch (Throwable t) {
                                contains = false;
                            }
                            continue;
                        }
                        if (!v.toString().toLowerCase().contains(parts[i].toLowerCase())) {
                            contains = false;
                            continue;
                        }
                    } else if (v instanceof Date) {
                        String t = DateUtil.formatSimpleDate((Date)v);
                        if (!t.toString().toLowerCase().contains(parts[i].toLowerCase())) {
                            contains = false;
                            continue;
                        }
                    } else if (!v.toString().toLowerCase().contains(parts[i].toLowerCase())) {
                        contains = false;
                        continue;
                    }
                }
                if (!or) continue;
                contains = true;
                break;
            }
            if (!contains) continue;
            values.add(v);
        }
        return values;
    }

    private void loadData(List values) {
        DefaultListModel lm = new DefaultListModel();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            lm.addElement(it.next());
        }
        if (this.cv.hasNull()) {
            lm.addElement(InnerMemberFactory.getCaption("V$NULL"));
        }
        this.list.setModel(lm);
    }

    private void installListener() {
        this.labClose.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ValueSelectWidget.this.closeMe();
            }
        });
        this.labResizeTag.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ValueSelectWidget.this.xPress = e.getX();
                ValueSelectWidget.this.yPress = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ValueSelectWidget.this.isDraged) {
                    ValueSelectWidget.this.setBounds(ValueSelectWidget.this.getX(), ValueSelectWidget.this.getY(), ValueSelectWidget.this.wOld, ValueSelectWidget.this.hOld);
                    ValueSelectWidget.this.setPreferredSize(new Dimension(ValueSelectWidget.this.wOld, ValueSelectWidget.this.hOld));
                    ValueSelectWidget.this.validate();
                    ValueSelectWidget.this.getParent().repaint();
                    ValueSelectWidget.this.parentContainer.updateUI();
                    ValueSelectWidget.this.isDraged = false;
                }
            }
        });
        this.labResizeTag.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Graphics g2d = ValueSelectWidget.this.getParent().getGraphics();
                g2d.setColor(Color.WHITE);
                g2d.setXORMode(Color.DARK_GRAY);
                if (ValueSelectWidget.this.isDraged) {
                    g2d.drawRect(ValueSelectWidget.this.getX() - 1, ValueSelectWidget.this.getY() - 1, ValueSelectWidget.this.wOld, ValueSelectWidget.this.hOld);
                }
                ValueSelectWidget.this.wOld = ValueSelectWidget.this.getWidth() + e.getX() - ValueSelectWidget.this.xPress;
                ValueSelectWidget.this.hOld = ValueSelectWidget.this.getHeight() + e.getY() - ValueSelectWidget.this.yPress;
                ValueSelectWidget.this.wOld = ValueSelectWidget.this.wOld < 80 ? 80 : ValueSelectWidget.this.wOld;
                ValueSelectWidget.this.hOld = ValueSelectWidget.this.hOld < 40 ? 40 : ValueSelectWidget.this.hOld;
                g2d.drawRect(ValueSelectWidget.this.getX() - 1, ValueSelectWidget.this.getY() - 1, ValueSelectWidget.this.wOld, ValueSelectWidget.this.hOld);
                ValueSelectWidget.this.isDraged = true;
            }
        });
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx;
                if (!ValueSelectWidget.this.selectChanged && (idx = ValueSelectWidget.this.list.locationToIndex(e.getPoint())) >= 0) {
                    ValueSelectWidget.this.memberClicked();
                }
                ValueSelectWidget.this.selectChanged = false;
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!ValueSelectWidget.this.onChange && !e.getValueIsAdjusting()) {
                    ValueSelectWidget.this.selectChanged();
                }
            }
        });
    }

    protected void selectChanged() {
        int[] indices = this.list.getSelectedIndices();
        if (this.beforeSelectedIndices != null && this.beforeSelectedIndices.length == 1 && indices.length == 1 && this.beforeSelectedIndices[0] == indices[0]) {
            this.onChange = true;
            this.list.clearSelection();
            this.beforeSelectedIndices = null;
            this.onChange = false;
        } else {
            this.beforeSelectedIndices = this.list.getSelectedIndices();
        }
        Object[] values = this.list.getSelectedValues();
        if (values == null || values.length == 0) {
            this.dataModelSupport.setSelectedValues(this.dim, null);
        } else {
            this.dataModelSupport.setSelectedValues(this.dim, values);
        }
        this.selectChanged = true;
        this.parentContainer.valueChangeCallback();
    }

    private void memberClicked() {
        int[] indices = this.list.getSelectedIndices();
        if (this.beforeSelectedIndices != null && this.beforeSelectedIndices.length == 1 && indices.length == 1 && this.beforeSelectedIndices[0] == indices[0]) {
            this.onChange = true;
            this.list.clearSelection();
            this.beforeSelectedIndices = null;
            this.onChange = false;
            Object[] values = this.list.getSelectedValues();
            if (values == null || values.length == 0) {
                this.dataModelSupport.setSelectedValues(this.dim, null);
            } else {
                this.dataModelSupport.setSelectedValues(this.dim, values);
            }
            this.parentContainer.valueChangeCallback();
        }
    }

    private void setMouseIcon(JComponent source, Cursor cs) {
        if (source.getCursor() != cs) {
            source.setCursor(cs);
        }
    }

    private void closeMe() {
        this.parentContainer.removeWidget(this.dim);
        if (this.list.getSelectedIndices().length > 0) {
            this.dataModelSupport.setSelectedValues(this.dim, null);
            this.parentContainer.valueChangeCallback();
        }
    }

    public Dimension caculateDefaultSize() {
        int fieldCount = this.dataModelSupport.getColumnValues(this.dim).getValues().size();
        if (fieldCount < 2) {
            fieldCount = 2;
        }
        if (fieldCount > 10) {
            fieldCount = 10;
        }
        fieldCount = 20;
        int w = 80 + fieldCount * 5;
        int h = fieldCount * 20 + 46;
        return new Dimension(w, h);
    }

    public void setIcon(Icon icon) {
        this.labName.setIcon(icon);
    }

    public void setTableBackground(Color color) {
        this.labName.setBackground(color);
        this.labResizeTag.setBackground(color);
    }

    public void setSelectdValues(Object[] values) {
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < values.length; ++i) {
            set.add(values[i]);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int count = this.list.getElementCount();
        for (int i = 0; i < count; ++i) {
            Object v = this.list.getElement(i);
            if (!set.contains(v)) continue;
            indexes.add(i);
        }
        int[] is = new int[indexes.size()];
        for (int i = 0; i < is.length; ++i) {
            is[i] = (Integer)indexes.get(i);
        }
        this.list.setSelectedIndices(is);
    }
}

