/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.easui.dnd;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.streamwork.pivot.easui.ColumnItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;

public class PanelDropTarget
implements DropTargetListener {
    private JComponent panel;
    private Point lastP;
    private DropCallBack dropCallBack;

    public PanelDropTarget(JComponent aPanel, DropCallBack dropCallBack) {
        this.panel = aPanel;
        new DropTarget(this.panel, this);
        this.dropCallBack = dropCallBack;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    private Color brighter(Color c, float FACTOR) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(1.0 / (1.0 - (double)FACTOR));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / FACTOR), 255), Math.min((int)((float)g / FACTOR), 255), Math.min((int)((float)b / FACTOR), 255));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        if (this.lastP == null || this.lastP.x != p.x || this.lastP.y != p.y) {
            // empty if block
        }
        this.lastP = p;
    }

    private void markTarget(Point p) {
        Graphics g = this.panel.getGraphics();
        g.setColor(Color.RED);
        int lenx = 25;
        int leny = 25;
        g.drawLine(p.x - 25, p.y, p.x + 25, p.y);
        g.drawLine(p.x, p.y - 25, p.x, p.y + 25);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private int getDropPositionIndex(Point dropPoint) {
        Point p;
        Component[] cs = this.panel.getComponents();
        ArrayList<Point> list = new ArrayList<Point>();
        for (int j = 0; j < cs.length; ++j) {
            p = cs[j].getLocation();
            p.x += cs[j].getWidth();
            p.y += cs[j].getHeight();
            list.add(p);
        }
        int index = -1;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            p = (Point)list.get(i);
            if (dropPoint.x > p.x || dropPoint.y > p.y) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        try {
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!tr.isDataFlavorSupported(flavors[i])) continue;
                ColumnItem item = (ColumnItem)tr.getTransferData(flavors[i]);
                boolean b = false;
                if (this.panel instanceof KDList) {
                    JComponent widget = (JComponent)((KDList)this.panel).getUserObject();
                    Point location1 = widget.getLocation();
                    Point location2 = dtde.getLocation();
                    b = this.dropCallBack.drop(item, new Point((int)(location1.getX() + location2.getX()), (int)(location1.getY() + location2.getY())));
                } else {
                    b = this.dropCallBack.drop(item, dtde.getLocation());
                }
                this.panel.updateUI();
                dtde.dropComplete(b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    public static interface DropCallBack
    extends Serializable {
        public boolean drop(ColumnItem var1, Point var2);
    }
}

