/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import com.kingdee.bos.streamwork.pivot.excelui.CheckItemOption;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItem;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItemListener;
import com.kingdee.bos.streamwork.pivot.model.DataModel;
import com.kingdee.bos.streamwork.pivot.resource.Resources;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class CheckedItemPanel
extends JPanel {
    JCheckBox cbSelect = new JCheckBox();
    JLabel labName = new JLabel();
    JLabel labIconFilter = new JLabel();
    JLabel labIconMenu = new JLabel();
    DataModel dataModel;
    CheckedItem item;
    boolean focus;
    private Icon filterIcon;
    private Icon menuIcon;
    CheckItemOption option;
    JPanel panelIcon = new JPanel();
    private ArrayList<CheckedItemListener> listenerList = new ArrayList();

    public CheckedItemPanel(DataModel dataModel, CheckedItem item, CheckItemOption option) {
        this.dataModel = dataModel;
        this.item = item;
        this.option = option;
        this.filterIcon = Resources.getIcon("icon/tbtn_filter.gif");
        this.menuIcon = Resources.getIcon("icon/trenddown.gif");
        if (option.noHighlightBgColor == null) {
            option.noHighlightBgColor = this.getBackground();
        }
        this.labIconMenu.setOpaque(true);
        this.labIconFilter.setOpaque(true);
        this.cbSelect.setOpaque(true);
        this.initUI();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
    }

    public CheckedItem getItem() {
        return this.item;
    }

    private void initUI() {
        this.panelIcon.setLayout(new FlowLayout());
        if (this.option.showFilterIcon) {
            this.labIconFilter.setIcon(this.filterIcon);
            this.labIconFilter.setBorder(null);
            this.panelIcon.add(this.labIconFilter);
        }
        this.panelIcon.add(this.labIconMenu);
        this.panelIcon.setBorder(null);
        this.panelIcon.setOpaque(true);
        String labCaption = this.item.getCaption(this.dataModel);
        this.labName.setText(labCaption);
        this.setBorder(new LineBorder(this.option.noHighlightBorderColor));
        this.labName.setBorder(new EmptyBorder(0, 3, 0, 0));
        this.setLayout(new FlowLayout(3));
        if (this.option.showCheckBox) {
            this.cbSelect.setSelected(this.item.selected);
            this.add(this.cbSelect);
        }
        this.labIconMenu.setBorder(null);
        this.add(this.labName);
        this.add(this.panelIcon);
        this.labName.setCursor(Cursor.getPredefinedCursor(13));
        this.doLayout();
        this.validate();
        if (this.option.alwaysHighlight) {
            this.setFocus(true);
        } else {
            this.setFocus(false);
            MouseAdapter myMouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    CheckedItemPanel.this.setFocus(true);
                    super.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    CheckedItemPanel.this.setFocus(false);
                    super.mouseExited(e);
                }
            };
            this.addMouseListener(myMouseAdapter);
            this.cbSelect.addMouseListener(myMouseAdapter);
            this.labIconMenu.addMouseListener(myMouseAdapter);
            this.labIconFilter.addMouseListener(myMouseAdapter);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CheckedItemPanel.this.setFocus(false);
                }
            });
        }
        this.cbSelect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CheckedItemPanel.this.cbSelect.isSelected() != CheckedItemPanel.this.item.selected) {
                    CheckedItemPanel.this.selected(CheckedItemPanel.this.cbSelect.isSelected());
                }
            }
        });
        this.labIconMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckedItemPanel.this.menuClicked();
            }
        });
    }

    protected void menuClicked() {
        for (CheckedItemListener l : this.listenerList) {
            l.menuClicked(this.item);
        }
    }

    public void setSelected(boolean selected, boolean fireEvent) {
        if (!fireEvent) {
            this.item.selected = selected;
        }
        this.cbSelect.setSelected(selected);
    }

    private void selected(boolean selected) {
        this.item.selected = selected;
        for (CheckedItemListener l : this.listenerList) {
            l.selected(this.item, selected);
        }
    }

    public void addListener(CheckedItemListener l) {
        this.listenerList.add(l);
    }

    public void lostFocus() {
        if (!this.option.alwaysHighlight) {
            this.setFocus(false);
        }
    }

    protected void setFocus(boolean b) {
        this.focus = b;
        if (b) {
            this.setBackground(this.option.highlightBgColor);
            this.setBorder(new LineBorder(this.option.highlightBorderColor));
            this.labIconMenu.setBackground(this.option.highlightBgColor);
            this.cbSelect.setBackground(this.option.highlightBgColor);
            this.panelIcon.setBackground(this.option.highlightBgColor);
            this.labIconMenu.setIcon(this.menuIcon);
        } else {
            this.setBackground(this.option.noHighlightBgColor);
            this.setBorder(new LineBorder(this.option.noHighlightBorderColor));
            this.labIconMenu.setIcon(null);
            this.labIconMenu.setBackground(this.option.noHighlightBgColor);
            this.labIconFilter.setBackground(this.option.noHighlightBgColor);
            this.cbSelect.setBackground(this.option.noHighlightBgColor);
            this.panelIcon.setBackground(this.option.noHighlightBgColor);
        }
        this.refreshFilterIcon();
        this.doLayout();
    }

    public void refreshFilterIcon() {
        if (this.item.valueFiltered(this.dataModel)) {
            this.labIconFilter.setIcon(this.filterIcon);
        } else {
            this.labIconFilter.setIcon(null);
        }
    }

    protected void setIConPaneFocus(boolean b) {
        if (b) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

