/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class CheckedItemTable
extends JTable {
    private CheckedItemTableModel tableModel = new CheckedItemTableModel();
    private SelectListener selectListener;

    public CheckedItemTable() {
        this.setModel(this.tableModel);
        this.setShowGrid(false);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new MyTableCellSupport(this.tableModel.getCheckedItem(row));
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        return new MyTableCellSupport(this.tableModel.getCheckedItem(row));
    }

    public void addItem(String name) {
        this.tableModel.addItem(name);
    }

    public void addItems(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.tableModel.addItem(names[i]);
        }
    }

    public void setCheck(String name, boolean check) {
        this.tableModel.getCheckedItem((String)name).checked = check;
    }

    public void setSelectListener(SelectListener l) {
        this.selectListener = l;
    }

    private void selectChanged() {
        if (this.selectListener != null) {
            this.selectListener.selectedChanged(this.tableModel.getCheckedItems());
        }
    }

    class CheckedItemTableModel
    implements TableModel {
        ArrayList<CheckedItem> list = new ArrayList();
        protected EventListenerList listenerList = new EventListenerList();

        CheckedItemTableModel() {
        }

        public CheckedItem getCheckedItem(int index) {
            return this.list.get(index);
        }

        public CheckedItem getCheckedItem(String name) {
            for (CheckedItem item : this.list) {
                if (!item.name.equals(name)) continue;
                return item;
            }
            return null;
        }

        public String[] getCheckedItems() {
            ArrayList<String> ret = new ArrayList<String>();
            for (CheckedItem item : this.list) {
                if (!item.checked) continue;
                ret.add(item.name);
            }
            return ret.toArray(new String[0]);
        }

        public void addItem(String value) {
            this.list.add(new CheckedItem(value));
        }

        public void addItem(CheckedItem item) {
            this.list.add(item);
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return CheckedItem.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.list.get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.list.set(rowIndex, (CheckedItem)aValue);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listenerList.add(TableModelListener.class, l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listenerList.remove(TableModelListener.class, l);
        }
    }

    class CheckedItem {
        boolean checked;
        String name;

        CheckedItem(String name) {
            this.name = name;
        }
    }

    private class MyTableCellSupport
    implements TableCellEditor,
    TableCellRenderer {
        final CheckedItem item;
        final JCheckBox cb = new JCheckBox();
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;

        private MyTableCellSupport(final CheckedItem item) {
            this.item = item;
            this.cb.setSelected(item.checked);
            this.cb.setText(item.name);
            this.cb.setBorder(null);
            this.cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (item.checked != MyTableCellSupport.this.cb.isSelected()) {
                        MyTableCellSupport.this.checkChanged(MyTableCellSupport.this.cb.isSelected());
                    }
                }
            });
        }

        protected void checkChanged(boolean selected) {
            this.item.checked = selected;
            CheckedItemTable.this.selectChanged();
        }

        @Override
        public Object getCellEditorValue() {
            return this.item;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(CellEditorListener.class, l);
        }

        public CellEditorListener[] getCellEditorListeners() {
            return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.cb;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.cb;
        }
    }

    public static interface SelectListener {
        public void selectedChanged(String[] var1);
    }
}

