/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import com.kingdee.bos.streamwork.pivot.Location;
import com.kingdee.bos.streamwork.pivot.excelui.CheckItemOption;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItem;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItemListener;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItemPanel;
import com.kingdee.bos.streamwork.pivot.excelui.WidgetListener;
import com.kingdee.bos.streamwork.pivot.excelui.dnd.ComponentDragSource;
import com.kingdee.bos.streamwork.pivot.excelui.dnd.PanelDropTarget;
import com.kingdee.bos.streamwork.pivot.model.DataModel;
import com.kingdee.bos.streamwork.pivot.model.DataType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class CheckedItemWidget
extends JPanel
implements DragGestureListener {
    private List<CheckedItem> checkedItems = new ArrayList<CheckedItem>();
    private Map<String, CheckedItemPanel> checkedItemPanels = new HashMap<String, CheckedItemPanel>();
    private MyCheckedItemListener checkedItemListener = new MyCheckedItemListener();
    public CheckItemOption option;
    JPanel rootPanel;
    JScrollPane scrollPane;
    private DataModel dataModel;
    private JPanel scrollPaneContainer;
    boolean doDropTarget = false;
    private DropEndCallBack dropEndCallBack = new DropEndCallBack();
    private DropCallBack dropCallBack = new DropCallBack();
    private WidgetListener listener;

    public CheckedItemWidget(CheckItemOption option, DataModel dataModel) {
        this.option = option;
        this.dataModel = dataModel;
        this.rootPanel = new JPanel();
        this.scrollPane = new JScrollPane(this.rootPanel);
        this.setLayout(new BorderLayout());
        if (option.title != null) {
            this.add((Component)new JLabel(option.title), "North");
        }
        LineBorder border = new LineBorder(Color.GRAY);
        this.scrollPaneContainer = new JPanel();
        this.scrollPaneContainer.setLayout(new BorderLayout());
        this.scrollPaneContainer.add((Component)this.scrollPane, "Center");
        this.scrollPaneContainer.setBorder(border);
        this.add((Component)this.scrollPaneContainer, "Center");
        this.scrollPaneContainer.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
    }

    public void setCheckedItems(String[] checkedItemNames) {
        ArrayList<CheckedItem> list = new ArrayList<CheckedItem>();
        for (int i = 0; i < checkedItemNames.length; ++i) {
            list.add(this.createCheckedItem(checkedItemNames[i]));
        }
        this.setCheckedItems(list);
    }

    private CheckedItem createCheckedItem(String name) {
        CheckedItem item = new CheckedItem(name);
        item.location = this.option.location;
        if (Location.METRIC.equals(this.option.location)) {
            item.aggType = DataType.isNumber(this.dataModel.getColumnValues(name).getDataType()) ? 0 : 4;
        }
        return item;
    }

    private void setCheckedItems(List<CheckedItem> checkedItems) {
        this.checkedItems.clear();
        this.checkedItems.addAll(checkedItems);
        this.checkedItemPanels.clear();
        for (int i = 0; i < checkedItems.size(); ++i) {
            CheckedItem item = checkedItems.get(i);
            CheckedItemPanel panel = this.createCheckedItemPanel(item);
            panel.addListener(this.checkedItemListener);
            this.checkedItemPanels.put(item.name, panel);
        }
        this.layoutUI();
        this.updateUI();
    }

    private CheckedItemPanel createCheckedItemPanel(CheckedItem item) {
        CheckedItemPanel panel = new CheckedItemPanel(this.dataModel, item, this.option);
        new ComponentDragSource(panel, 2, this.dropEndCallBack);
        return panel;
    }

    public String[] getAllCheckedItemNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (CheckedItem item : this.checkedItems) {
            ret.add(item.name);
        }
        return ret.toArray(new String[0]);
    }

    public CheckedItem[] getAllCheckedItems() {
        ArrayList<CheckedItem> ret = new ArrayList<CheckedItem>();
        for (CheckedItem item : this.checkedItems) {
            ret.add(item);
        }
        return ret.toArray(new CheckedItem[0]);
    }

    public void addCheckedItem(String name) {
        ArrayList<CheckedItem> checkedItems = new ArrayList<CheckedItem>();
        checkedItems.addAll(this.checkedItems);
        checkedItems.add(this.createCheckedItem(name));
        this.setCheckedItems(checkedItems);
    }

    public void removeCheckedItem(String name) {
        ArrayList<CheckedItem> ret = new ArrayList<CheckedItem>();
        for (int i = 0; i < this.checkedItems.size(); ++i) {
            CheckedItem item = this.checkedItems.get(i);
            if (this.checkedItems.get((int)i).name.equals(name)) continue;
            ret.add(item);
        }
        if (ret.size() != this.checkedItems.size()) {
            this.setCheckedItems(ret);
        }
    }

    public boolean dndAddCheckedItemPanel(CheckedItem item, Point location) {
        ArrayList<CheckedItem> orderedCheckedItem = new ArrayList<CheckedItem>();
        TreeMap<Integer, CheckedItem> map = new TreeMap<Integer, CheckedItem>();
        boolean inSamePane = false;
        int n = this.checkedItems.size();
        for (int i = 0; i < n; ++i) {
            CheckedItemPanel p = this.checkedItemPanels.get(this.checkedItems.get((int)i).name);
            Rectangle r = p.getBounds();
            if (!item.name.equals(p.item.name)) {
                map.put((int)r.getCenterY(), p.item);
                continue;
            }
            map.put(location.y, p.item);
            inSamePane = true;
        }
        if (!inSamePane) {
            map.put(location.y, this.createCheckedItem(item.name));
        }
        orderedCheckedItem.addAll(map.values());
        if (inSamePane) {
            boolean sameOrder = false;
            for (int i = 0; i < orderedCheckedItem.size(); ++i) {
                if (orderedCheckedItem.get((int)i).name.equals(this.checkedItems.get((int)i).name)) continue;
                sameOrder = false;
                break;
            }
            if (!sameOrder) {
                this.setCheckedItems(orderedCheckedItem);
                if (this.listener != null) {
                    this.listener.itemMoved(item);
                }
            }
        } else {
            this.setCheckedItems(orderedCheckedItem);
            if (this.listener != null) {
                this.listener.itemAdded(item);
            }
        }
        return !inSamePane;
    }

    public void dndRemoveCheckedItemPanel(CheckedItemPanel panel) {
        ArrayList<CheckedItem> orderedCheckedItem = new ArrayList<CheckedItem>();
        boolean found = false;
        int n = this.checkedItems.size();
        for (int i = 0; i < n; ++i) {
            if (this.checkedItems.get(i) != panel.item) {
                orderedCheckedItem.add(this.checkedItems.get(i));
                continue;
            }
            found = true;
        }
        if (found) {
            this.setCheckedItems(orderedCheckedItem);
        }
        if (this.listener != null) {
            this.listener.itemRemoved(panel.item);
        }
    }

    private void layoutUI() {
        JPanel panel;
        this.rootPanel.setLayout(new GridBagLayout());
        this.rootPanel.removeAll();
        this.rootPanel.setBackground(Color.WHITE);
        this.rootPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        int i = 0;
        while (i < this.checkedItems.size()) {
            panel = this.checkedItemPanels.get(this.checkedItems.get((int)i).name);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = i++;
            gc.gridx = 0;
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            gc.insets = new Insets(1, 0, 0, 0);
            gc.fill = 2;
            gc.anchor = 18;
            this.rootPanel.add((Component)panel, gc);
        }
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = this.checkedItems.size();
        gc.gridx = 0;
        gc.gridwidth = 0;
        gc.gridheight = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 10;
        gc.anchor = 16;
        panel = new JPanel();
        panel.setOpaque(true);
        panel.setBackground(Color.WHITE);
        this.rootPanel.add((Component)panel, gc);
        if (!this.doDropTarget) {
            new PanelDropTarget(this.rootPanel, this.dropCallBack);
            this.doDropTarget = true;
        }
    }

    public void setWidgetListener(WidgetListener l) {
        this.listener = l;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    public boolean containsCheckedItem(String name) {
        return this.checkedItemPanels.get(name) != null;
    }

    public CheckedItemPanel getCheckedItemPanel(String name) {
        return this.checkedItemPanels.get(name);
    }

    public CheckedItem getCheckedItemByName(String name) {
        return this.checkedItemPanels.get((Object)name).item;
    }

    public void setSelected(String itemName, boolean selected, boolean fireEvent) {
        this.checkedItemPanels.get(itemName).setSelected(selected, fireEvent);
    }

    public void refreshFilterIcon() {
        Iterator<CheckedItemPanel> iter = this.checkedItemPanels.values().iterator();
        while (iter.hasNext()) {
            iter.next().refreshFilterIcon();
        }
    }

    private class DropCallBack
    implements PanelDropTarget.DropCallBack {
        private DropCallBack() {
        }

        @Override
        public boolean drop(CheckedItem item, Point location) {
            if (CheckedItemWidget.this.option.canBeTarget) {
                boolean b = CheckedItemWidget.this.dndAddCheckedItemPanel(item, location);
                CheckedItemWidget.this.validate();
                return b;
            }
            return true;
        }
    }

    private class DropEndCallBack
    implements ComponentDragSource.DropCallBack {
        private DropEndCallBack() {
        }

        @Override
        public void dropEnd(Component c) {
            if (CheckedItemWidget.this.option.canDropOut) {
                CheckedItemPanel p = (CheckedItemPanel)c;
                Container parent = p.getParent();
                CheckedItemWidget.this.dndRemoveCheckedItemPanel(p);
                if (parent != null) {
                    parent.validate();
                }
                CheckedItemWidget.this.validate();
                CheckedItemWidget.this.getParent().doLayout();
            }
        }
    }

    private class MyCheckedItemListener
    implements CheckedItemListener {
        private MyCheckedItemListener() {
        }

        @Override
        public void menuClicked(CheckedItem item) {
            if (CheckedItemWidget.this.listener != null) {
                CheckedItemWidget.this.listener.menuClicked(item);
            }
        }

        @Override
        public void selected(CheckedItem item, boolean selected) {
            if (CheckedItemWidget.this.listener != null) {
                CheckedItemWidget.this.listener.selectedChanged(item, selected);
            }
        }
    }
}

