/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import com.kingdee.bos.streamwork.pivot.excelui.CheckedItem;
import com.kingdee.bos.streamwork.pivot.excelui.CheckedItemListener;
import com.kingdee.bos.streamwork.pivot.model.DataModel;
import com.kingdee.bos.streamwork.pivot.resource.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FilterItemPanel
extends JPanel {
    JLabel labName = new JLabel();
    JLabel labIconMenu = new JLabel();
    DataModel dataModel;
    CheckedItem item;
    private Icon menuIcon;
    private Icon filterIcon;
    private ArrayList<CheckedItemListener> listenerList = new ArrayList();

    public FilterItemPanel(DataModel dataModel, CheckedItem item) {
        this.dataModel = dataModel;
        this.item = item;
        this.menuIcon = Resources.getIcon("icon/trenddown.gif");
        this.filterIcon = Resources.getIcon("icon/tbtn_filter.gif");
        this.labIconMenu.setOpaque(true);
        this.initUI();
    }

    private void initUI() {
        String labCaption = this.item.getCaption(this.dataModel);
        this.labName.setText(labCaption);
        this.setLayout(new BorderLayout());
        this.labIconMenu.setBorder(null);
        this.add((Component)this.labName, "Center");
        this.add((Component)this.labIconMenu, "East");
        if (this.item.valueFiltered(this.dataModel)) {
            this.labIconMenu.setIcon(this.filterIcon);
        } else {
            this.labIconMenu.setIcon(this.menuIcon);
        }
        this.labIconMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FilterItemPanel.this.menuClicked();
            }
        });
    }

    public void addListener(CheckedItemListener l) {
        this.listenerList.add(l);
    }

    protected void menuClicked() {
        for (CheckedItemListener l : this.listenerList) {
            l.menuClicked(this.item);
        }
        this.refreshFilterIcon();
    }

    public CheckedItem getItem() {
        return this.item;
    }

    public void refreshFilterIcon() {
        this.setFilterIcon(this.item.valueFiltered(this.dataModel));
        String labCaption = this.item.getCaption(this.dataModel);
        this.labName.setText(labCaption);
    }

    private void setFilterIcon(boolean b) {
        if (b) {
            this.labIconMenu.setIcon(this.filterIcon);
        } else {
            this.labIconMenu.setIcon(this.menuIcon);
        }
    }
}

