/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.excelui.MeasureProperty;
import com.kingdee.bos.streamwork.pivot.model.DataModelSupport;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.resource.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class MeasureWidget
extends KDPanel {
    private DataModelSupport dataModelSupport;
    private KDLabel labName;
    private KDList list;
    private KDScrollPane scrollPane;
    private KDLabel labResizeTag;
    private KDPanel panFoot;
    private static final Cursor CURSOR_DEFAULT = Cursor.getDefaultCursor();
    private static final Cursor CURSOR_RESIZE = Cursor.getPredefinedCursor(5);
    private static final Cursor CURSOR_MOVE = Cursor.getPredefinedCursor(13);
    private static final Cursor CURSOR_DRAG = Toolkit.getDefaultToolkit().createCustomCursor(Icons.createImage("icon/cursors/mos_movedrop.gif"), new Point(0, 0), "CanDrop");
    private static final Cursor CURSOR_FORBID = Toolkit.getDefaultToolkit().createCustomCursor(Icons.createImage("icon/cursors/cursor_lock.gif"), new Point(0, 0), "Forbid");
    MeasureProperty measureProperty;

    public MeasureWidget(DataModelSupport dataModelSupport) {
        this.dataModelSupport = dataModelSupport;
        this.initUI();
    }

    public void initUI() {
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.labName = new KDLabel("\u6307\u6807");
        this.labName.setPreferredSize(new Dimension(1, 20));
        this.labName.setOpaque(true);
        this.setMouseIcon((JComponent)this.labName, CURSOR_MOVE);
        this.labResizeTag = new KDLabel();
        this.labResizeTag.setIcon((Icon)Icons.createIcon("icon/resize.gif"));
        this.labResizeTag.setPreferredSize(new Dimension(15, 14));
        this.labResizeTag.setHorizontalAlignment(2);
        this.labResizeTag.setVerticalAlignment(1);
        this.setMouseIcon((JComponent)this.labResizeTag, CURSOR_RESIZE);
        this.list = new KDList();
        this.list.setCellRenderer((ListCellRenderer)new CustomListCellRender());
        this.refreshField();
        this.scrollPane = new KDScrollPane((Component)this.list);
        this.panFoot = new KDPanel((LayoutManager)new BorderLayout());
        this.panFoot.add((Component)new KDSeparator(), (Object)"North");
        this.panFoot.add((Component)this.labResizeTag, (Object)"East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.labName, "North");
        this.add((Component)this.scrollPane, "Center");
        this.measureProperty = new MeasureProperty(PivotUtils.getMainFrame());
        this.initDefaultCondition();
        this.installListener();
    }

    private void initDefaultCondition() {
        int size = this.list.getModel().getSize();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            String column = ((Measure)this.list.getModel().getElementAt((int)i)).name;
            if (!this.dataModelSupport.isMeasureSelected(column)) continue;
            indices.add(i);
        }
        int[] ii = new int[indices.size()];
        for (int i = 0; i < ii.length; ++i) {
            ii[i] = (Integer)indices.get(i);
        }
        this.list.setSelectedIndices(ii);
    }

    public void refreshField() {
        DefaultListModel<Measure> lm = new DefaultListModel<Measure>();
        Measure[] measures = this.dataModelSupport.getMeasures();
        for (int i = 0; i < measures.length; ++i) {
            lm.addElement(measures[i]);
        }
        this.list.setModel(lm);
    }

    private void installListener() {
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx = MeasureWidget.this.list.locationToIndex(e.getPoint());
                if (idx >= 0) {
                    MeasureWidget.this.measureSelected();
                }
            }
        });
    }

    protected void showMeasureProperty(int index) {
        Measure measure = (Measure)this.list.getModel().getElementAt(index);
        this.measureProperty.setMeasure(measure);
        this.measureProperty.showDialog();
    }

    private void measureSelected() {
        Object[] values = this.list.getSelectedValues();
        if (values == null || values.length == 0) {
            this.dataModelSupport.setSelectedMeasures(null);
        } else {
            String[] columns = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                columns[i] = ((Measure)values[i]).name;
            }
            this.dataModelSupport.setSelectedMeasures(columns);
        }
    }

    private void setMouseIcon(JComponent source, Cursor cs) {
        if (source.getCursor() != cs) {
            source.setCursor(cs);
        }
    }

    private void selectTable() {
    }

    public static Dimension caculateDefaultSize(DataModelSupport dataModelSupport, String column) {
        int fieldCount = dataModelSupport.getColumnValues(column).getValues().size();
        if (fieldCount < 2) {
            fieldCount = 2;
        }
        if (fieldCount > 10) {
            fieldCount = 10;
        }
        int w = 80 + fieldCount * 5;
        int h = fieldCount * 20 + 46;
        return new Dimension(w, h);
    }

    public void setIcon(Icon icon) {
        this.labName.setIcon(icon);
    }

    public void setTableBackground(Color color) {
        this.labName.setBackground(color);
        this.labResizeTag.setBackground(color);
        this.panFoot.setBackground(color);
    }

    class CustomListCellRender
    implements ListCellRenderer {
        ListCellRenderer render = new DefaultListCellRenderer();

        CustomListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent c = (JComponent)this.render.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            c.setBorder(null);
            KDCheckBox lab = new KDCheckBox();
            lab.setText("\u6539");
            lab.setSize(5, 5);
            final JList list2 = list;
            lab.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int idx = list2.locationToIndex(e.getPoint());
                    MeasureWidget.this.showMeasureProperty(idx);
                }
            });
            TableLayout tl = TableLayout.splitCol((int)2);
            tl.colStyle(0).setWidth(5);
            tl.colStyle(1).setPriX(1);
            KDPanel pan = new KDPanel((LayoutManager)tl);
            pan.add((Component)lab, (Object)tl.cell(0));
            pan.add((Component)c, (Object)tl.cell(1));
            return pan;
        }
    }
}

