/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.excelui;

import com.kingdee.bos.streamwork.pivot.model.AggType;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class MeasuresTable
extends JTable {
    private List<Measure> measures = new ArrayList<Measure>();
    private List<Measure> selectedMeasures = new ArrayList<Measure>();
    SelectListener selectListener;

    public MeasuresTable() {
        this.setSelectionMode(2);
    }

    public void setMeasures(List<Measure> measures) {
        this.measures = measures;
        for (Measure m : measures) {
            if (this.selectedMeasures.contains(m)) continue;
            this.selectedMeasures.remove(m);
        }
        this.setModel(new MyModel());
        this.getColumnModel().getColumn(0).setResizable(false);
        this.getColumnModel().getColumn(2).setResizable(false);
        this.getColumnModel().getColumn(0).setWidth(10);
        this.getColumnModel().getColumn(2).setWidth(20);
    }

    public void addSelected(Measure measure) {
        if (!this.selectedMeasures.contains(measure)) {
            this.selectedMeasures.add(measure);
        }
        this.selectChanged();
    }

    public void setSelectedMeasures(List<Measure> measures) {
        this.selectedMeasures.clear();
        this.selectedMeasures.addAll(measures);
    }

    public void removeSelected(Measure measure) {
        while (this.selectedMeasures.remove(measure)) {
        }
        this.selectChanged();
    }

    public void setSelectListener(SelectListener l) {
        this.selectListener = l;
    }

    private void selectChanged() {
        if (this.selectListener != null) {
            Measure[] ms = this.selectedMeasures.toArray(new Measure[0]);
            this.selectListener.selectedChanged(ms);
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column < 2) {
            return super.getCellRenderer(row, column);
        }
        return new MyTableCellSupport(this.measures.get(row));
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column < 2) {
            return super.getCellEditor(row, column);
        }
        return new MyTableCellSupport(this.measures.get(row));
    }

    protected void argTypeChanged(Measure measure, AggType aggType) {
        if (measure.aggType != aggType.getType()) {
            measure.aggType = aggType.getType();
            this.selectListener.measureAggTypeChanged(measure);
        }
    }

    private class MyModel
    extends AbstractTableModel {
        private MyModel() {
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public int getRowCount() {
            return MeasuresTable.this.measures.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int index) {
            if (index == 0) {
                return "\u9009\u62e9";
            }
            return index == 1 ? "\u6307\u6807" : "\u516c\u5f0f";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Measure measure = (Measure)MeasuresTable.this.measures.get(rowIndex);
            if (columnIndex == 0) {
                return MeasuresTable.this.selectedMeasures.contains(measure);
            }
            return columnIndex == 1 ? measure.name : new AggType(measure.aggType);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null) {
                return;
            }
            Measure measure = (Measure)MeasuresTable.this.measures.get(rowIndex);
            if (columnIndex == 0) {
                if (((Boolean)aValue).booleanValue()) {
                    MeasuresTable.this.addSelected(measure);
                } else {
                    MeasuresTable.this.removeSelected(measure);
                }
            } else if (columnIndex == 2) {
                ((Measure)((MeasuresTable)MeasuresTable.this).measures.get((int)rowIndex)).aggType = ((AggType)aValue).getType();
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }
    }

    private class MyTableCellSupport
    implements TableCellEditor,
    TableCellRenderer {
        final Measure measure;
        JComboBox cb = new JComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;

        private MyTableCellSupport(Measure measure) {
            this.measure = measure;
            this.initAggTypes();
            this.cb.setModel(this.model);
            this.cb.setBorder(null);
            this.cb.setSelectedItem(new AggType(measure.aggType));
            this.cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AggType aggType = (AggType)e.getItem();
                    MeasuresTable.this.argTypeChanged(MyTableCellSupport.this.measure, aggType);
                }
            });
        }

        private void initAggTypes() {
            this.model.addElement(AggType.TYPE_SUM);
            this.model.addElement(AggType.TYPE_COUNT);
            this.model.addElement(AggType.TYPE_AVG);
            this.model.addElement(AggType.TYPE_MAX);
            this.model.addElement(AggType.TYPE_MIN);
        }

        @Override
        public Object getCellEditorValue() {
            return this.cb.getSelectedItem();
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(CellEditorListener.class, l);
        }

        public CellEditorListener[] getCellEditorListeners() {
            return (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.cb;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.cb;
        }
    }

    public static interface SelectListener {
        public void selectedChanged(Measure[] var1);

        public void measureAggTypeChanged(Measure var1);
    }
}

