/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.execute;

import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBADatabase;
import com.kingdee.bos.streamwork.cuba.CUBAEngine;
import com.kingdee.bos.streamwork.cuba.CUBAException;
import com.kingdee.bos.streamwork.cuba.MdxResult;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.ResultOverflowInfo;
import com.kingdee.bos.streamwork.cuba.RollupPolicy;
import com.kingdee.bos.streamwork.cuba.dbsource.ArrayTable;
import com.kingdee.bos.streamwork.cuba.dbsource.Table;
import com.kingdee.bos.streamwork.cuba.def.CubeDef;
import com.kingdee.bos.streamwork.cuba.def.DimensionUsageDef;
import com.kingdee.bos.streamwork.cuba.def.ParameterDef;
import com.kingdee.bos.streamwork.cuba.def.SchemaDef;
import com.kingdee.bos.streamwork.cuba.def.SharedDimensionDef;
import com.kingdee.bos.streamwork.cuba.impl.ConnectionImpl;
import com.kingdee.bos.streamwork.cuba.mdx.Exp;
import com.kingdee.bos.streamwork.cuba.mdx.FunCall;
import com.kingdee.bos.streamwork.cuba.mdx.MdxQuery;
import com.kingdee.bos.streamwork.cuba.mdx.QueryAxis;
import com.kingdee.bos.streamwork.cuba.mdx.SchemaReader;
import com.kingdee.bos.streamwork.cuba.mdx.Syntax;
import com.kingdee.bos.streamwork.cuba.mdx.elementexp.MemberExpr;
import com.kingdee.bos.streamwork.cuba.util.UniqueNameUtil;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.pivot.execute.CubaBuilderBase;
import com.kingdee.bos.streamwork.pivot.execute.CubeBuilder;
import com.kingdee.bos.streamwork.pivot.model.Dimension;
import com.kingdee.bos.streamwork.pivot.model.MemberSelection;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CubaBuilderForExcelPivot
extends CubaBuilderBase
implements CubeBuilder {
    private static final Logger logger = Logger.getLogger(CubaBuilderForExcelPivot.class);
    private HashMap tableParams;
    TreeMap<Integer, String> dimSize = new TreeMap();

    public CubaBuilderForExcelPivot(DataSource dataSource, QueryModel queryModel) {
        super(dataSource, queryModel);
    }

    @Override
    public MdxResult buildMdxResult() throws CUBAException, SQLException {
        long start = System.currentTimeMillis();
        this.buildCuba();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildCuba cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        return this.innerBuildResult();
    }

    @Override
    public MdxResult buildMdxResultWhenConditionChanged(QueryModel queryModel) throws CUBAException, SQLException {
        this.queryModel = queryModel;
        return this.innerBuildResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MdxResult innerBuildResult() throws CUBAException, SQLException {
        long start = System.currentTimeMillis();
        String mdx = this.buildMdx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildMdx cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        start = System.currentTimeMillis();
        MdxQuery mdxQuery = this.con.parseQuery(mdx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseQuery cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        ResultOverflowInfo overflowInfo = null;
        if (mdxQuery.getAxes().length == 2) {
            start = System.currentTimeMillis();
            List<Exp> tuplesOnRow = this.processMdxQuery(mdxQuery, false, this.queryModel.dimensionsOnRow);
            List<Exp> tuplesOnColumn = null;
            int sizeOnRow = tuplesOnRow.size();
            if (this.queryModel.dimensionsOnColumn.length > 0) {
                tuplesOnColumn = this.processMdxQuery(mdxQuery, true, this.queryModel.dimensionsOnColumn);
                int sizeOnColumn = tuplesOnColumn.size();
                int cutSizeOnRow = 0;
                int cutSizeOnColumn = 0;
                int maxCell = 50000;
                int maxColumn = 32;
                if (sizeOnRow * sizeOnColumn * this.queryModel.measures.length > maxCell) {
                    if (sizeOnColumn * this.queryModel.measures.length > maxColumn) {
                        cutSizeOnColumn = maxColumn / this.queryModel.measures.length;
                        if (cutSizeOnColumn * this.queryModel.measures.length * sizeOnRow > maxCell) {
                            cutSizeOnRow = maxCell / (cutSizeOnColumn * this.queryModel.measures.length);
                        }
                    } else {
                        cutSizeOnRow = maxCell / (sizeOnColumn * this.queryModel.measures.length);
                    }
                    if (cutSizeOnRow != 0) {
                        tuplesOnRow = tuplesOnRow.subList(0, cutSizeOnRow);
                    }
                    if (cutSizeOnColumn != 0) {
                        tuplesOnColumn = tuplesOnColumn.subList(0, cutSizeOnColumn);
                    }
                    overflowInfo = new ResultOverflowInfo();
                    overflowInfo.originRowCount = sizeOnRow;
                    overflowInfo.originColumnCount = sizeOnColumn * this.queryModel.measures.length;
                    overflowInfo.cutRowCount = cutSizeOnRow;
                    overflowInfo.cutColumnCount = cutSizeOnColumn * this.queryModel.measures.length;
                }
                this.setAxisTuples(mdxQuery, false, tuplesOnRow, mdxQuery.getSchemaReader());
                this.setAxisTuples(mdxQuery, true, tuplesOnColumn, mdxQuery.getSchemaReader());
            } else {
                int maxRow = 20000;
                int cutSizeOnRow = 0;
                if (sizeOnRow > maxRow) {
                    cutSizeOnRow = maxRow;
                    tuplesOnRow = tuplesOnRow.subList(0, cutSizeOnRow);
                    overflowInfo = new ResultOverflowInfo();
                    overflowInfo.originRowCount = sizeOnRow;
                    overflowInfo.cutRowCount = cutSizeOnRow;
                }
                this.setAxisTuples(mdxQuery, false, tuplesOnRow, mdxQuery.getSchemaReader());
            }
            mdxQuery.resolve();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processMdxQuery cost " + (System.currentTimeMillis() - start) + "ms."));
            }
        }
        start = System.currentTimeMillis();
        try {
            MdxResult result = this.con.executeMdxQuery(mdxQuery);
            result.setOverflowInfo(overflowInfo);
            MdxResult mdxResult = result;
            return mdxResult;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("executeMdxQuery cost " + (System.currentTimeMillis() - start) + "ms."));
            }
        }
    }

    private void setAxisTuples(MdxQuery mdxQuery, boolean columnAxis, List<Exp> tuples, SchemaReader schemaReader) throws CUBAException {
        FunCall funCall = new FunCall("{}", tuples.toArray(new Exp[0]), Syntax.Braces);
        int rowCount = tuples.size();
        if (columnAxis) {
            QueryAxis axis = mdxQuery.getAxes()[1];
            if (this.queryModel.measures.length > 1) {
                FunCall exp = new FunCall("crossjoin", new Exp[]{funCall, this.createMeasuresExp(schemaReader)}, Syntax.Function);
                axis.setExp(exp);
                rowCount *= this.queryModel.measures.length;
            } else {
                axis.setExp(funCall);
            }
        } else {
            QueryAxis axis = mdxQuery.getAxes()[0];
            axis.setExp(funCall);
        }
    }

    private List<Exp> processMdxQuery(MdxQuery mdxQuery, boolean columnAxis, Dimension[] dimensions) throws CUBAException {
        SchemaReader schemaReader = mdxQuery.getSchemaReader();
        Table factTable = (Table)this.tableParams.get("fact");
        factTable.close();
        String[] columnNames = new String[dimensions.length];
        int[] columnIndexes = new int[dimensions.length];
        ArrayList[] values = new ArrayList[columnIndexes.length];
        final HashMap[] valuePosMap = new HashMap[columnIndexes.length];
        HashMap[] nameToExps = new HashMap[columnIndexes.length];
        for (int i = 0; i < dimensions.length; ++i) {
            String column = dimensions[i].name;
            int index = factTable.getColumnIndex(column);
            columnNames[i] = column;
            columnIndexes[i] = index;
            values[i] = new ArrayList();
            valuePosMap[i] = new HashMap();
            nameToExps[i] = new HashMap();
        }
        Object[] currentRow = null;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        HashSet<TupleKey> rowSet = new HashSet<TupleKey>();
        long start = System.currentTimeMillis();
        while (factTable.next()) {
            currentRow = new Object[columnIndexes.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                currentRow[i] = factTable.getValue(columnIndexes[i]);
                if (currentRow[i] == null) continue;
                Integer idx = (Integer)valuePosMap[i].get(currentRow[i]);
                if (idx != null) {
                    currentRow[i] = values[i].get(idx);
                    continue;
                }
                values[i].add(currentRow[i]);
                valuePosMap[i].put(currentRow[i], values[i].size() - 1);
            }
            TupleKey key = new TupleKey(currentRow);
            if (rowSet.contains(key)) continue;
            rows.add(currentRow);
            rowSet.add(new TupleKey(currentRow));
        }
        factTable.close();
        ArrayList<Exp> tuples = new ArrayList<Exp>();
        int[] timeCount = new int[]{0};
        if (rows.isEmpty()) {
            Exp[] tuple3 = new Exp[columnIndexes.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                tuple3[i] = this.createMember(schemaReader, nameToExps[i], columnNames[i], "(\u5408\u8ba1)", timeCount);
            }
            tuples.add(this.createTupleFunCall(tuple3));
        } else {
            int i;
            for (int i2 = 0; i2 < columnIndexes.length; ++i2) {
                ArrayList valueList = values[i2];
                TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof Number && o2 instanceof Number) {
                            double d = ((Number)o1).doubleValue() - ((Number)o2).doubleValue();
                            return d == 0.0 ? 0 : (d > 0.0 ? 1 : -1);
                        }
                        try {
                            return ((Comparable)o1).compareTo(o2);
                        }
                        catch (Throwable t) {
                            return -1;
                        }
                    }
                });
                for (int j = 0; j < valueList.size(); ++j) {
                    treeMap.put(valueList.get(j), j);
                }
                int index = 0;
                Iterator iter = treeMap.keySet().iterator();
                while (iter.hasNext()) {
                    treeMap.put(iter.next(), index++);
                }
                for (Object key : valuePosMap[i2].keySet()) {
                    valuePosMap[i2].put(key, treeMap.get(key));
                }
            }
            Object[] rowArray = rows.toArray();
            rowSet = null;
            rows = null;
            if (columnIndexes.length > 0) {
                Arrays.sort(rowArray, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Object[] v1 = (Object[])o1;
                        Object[] v2 = (Object[])o2;
                        for (int i = 0; i < v1.length; ++i) {
                            int idx2;
                            if (v1[i] == v2[i]) continue;
                            if (v1[i] == null && v2[i] != null) {
                                return 1;
                            }
                            if (v1[i] != null && v2[i] == null) {
                                return -1;
                            }
                            if (v1[i] == null || v2[i] == null) continue;
                            int idx1 = (Integer)valuePosMap[i].get(v1[i]);
                            if (idx1 > (idx2 = ((Integer)valuePosMap[i].get(v2[i])).intValue())) {
                                return 1;
                            }
                            if (idx1 >= idx2) continue;
                            return -1;
                        }
                        return 0;
                    }
                });
            }
            long end = System.currentTimeMillis();
            start = System.currentTimeMillis();
            Exp[] lastTuple = null;
            Exp[] tuple = null;
            boolean showSubTotal = columnAxis ? this.queryModel.showSubTotalOnColumn : this.queryModel.showSubTotalOnRow;
            boolean showTotal = columnAxis ? this.queryModel.showTotalOnColumn : this.queryModel.showTotalOnRow;
            for (int pos = 0; pos < rowArray.length; ++pos) {
                currentRow = (Object[])rowArray[pos];
                tuple = new Exp[columnIndexes.length];
                for (i = 0; i < currentRow.length; ++i) {
                    tuple[i] = this.createMember(schemaReader, nameToExps[i], columnNames[i], currentRow[i], timeCount);
                }
                if (lastTuple == null) {
                    tuples.add(this.createTupleFunCall(tuple));
                } else {
                    if (showSubTotal) {
                        Exp[] tuple2 = new Exp[columnIndexes.length];
                        System.arraycopy(lastTuple, 0, tuple2, 0, tuple.length);
                        for (int i3 = 0; i3 < currentRow.length - 1; ++i3) {
                            if (tuple[i3] == lastTuple[i3]) continue;
                            for (int j = currentRow.length - 1; j > i3; --j) {
                                Exp[] tuple3 = new Exp[columnIndexes.length];
                                System.arraycopy(tuple2, 0, tuple3, 0, tuple.length);
                                for (int k = j; k < currentRow.length; ++k) {
                                    tuple3[k] = this.createMember(schemaReader, nameToExps[k], columnNames[k], "(\u5c0f\u8ba1)", timeCount);
                                }
                                tuples.add(this.createTupleFunCall(tuple3));
                            }
                            break;
                        }
                    }
                    tuples.add(this.createTupleFunCall(tuple));
                }
                lastTuple = tuple;
            }
            if (columnIndexes.length > 1 && lastTuple != null && showSubTotal) {
                Exp[] tuple2 = new Exp[columnIndexes.length];
                System.arraycopy(lastTuple, 0, tuple2, 0, tuple.length);
                for (int j = currentRow.length - 1; j > 0; --j) {
                    Exp[] tuple3 = new Exp[columnIndexes.length];
                    System.arraycopy(tuple2, 0, tuple3, 0, tuple.length);
                    for (int k = j; k < currentRow.length; ++k) {
                        tuple3[k] = this.createMember(schemaReader, nameToExps[k], columnNames[k], "(\u5c0f\u8ba1)", timeCount);
                    }
                    tuples.add(this.createTupleFunCall(tuple3));
                }
            }
            if (lastTuple != null && showTotal) {
                Exp[] tuple3 = new Exp[columnIndexes.length];
                for (i = 0; i < columnIndexes.length; ++i) {
                    tuple3[i] = this.createMember(schemaReader, nameToExps[i], columnNames[i], "(\u5408\u8ba1)", timeCount);
                }
                tuples.add(this.createTupleFunCall(tuple3));
            }
        }
        return tuples;
    }

    private Exp createTupleFunCall(Exp[] tuple) {
        return new FunCall("()", tuple, Syntax.Parentheses);
    }

    private Exp createMember(SchemaReader schemaReader, HashMap map, String dim, Object object, int[] timeCount) throws CUBAException {
        long start = System.currentTimeMillis();
        String name = null;
        name = object == null ? "V$NULL" : object.toString();
        Exp exp = (Exp)map.get(name);
        if (exp != null) {
            return exp;
        }
        String uniqueName = UniqueNameUtil.createUniqueName(new String[]{dim, name});
        Member member = schemaReader.getMemberByUniqueName(schemaReader.getCubes()[0], uniqueName);
        exp = new MemberExpr(member);
        map.put(name, exp);
        timeCount[0] = (int)((long)timeCount[0] + (System.currentTimeMillis() - start));
        return exp;
    }

    private void buildCuba() throws CUBAException, SQLException {
        int i;
        long start = System.currentTimeMillis();
        this.tableParams = this.buildTables();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildTables cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        start = System.currentTimeMillis();
        SchemaDef schemaDef = this.buildSchema(this.tableParams);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildSchema cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        CUBAEngine.setResource(Locale.CHINA, "measureDimensionCaption", "\u6570\u503c");
        CUBAEngine.setResource(Locale.CHINESE, "measureDimensionCaption", "\u6570\u503c");
        CUBAEngine.setResource(Locale.TRADITIONAL_CHINESE, "measureDimensionCaption", "\u6570\u503c");
        CUBAEngine.setResource(Locale.TAIWAN, "measureDimensionCaption", "\u6570\u503c");
        CUBAEngine.setResource(Locale.SIMPLIFIED_CHINESE, "measureDimensionCaption", "\u6570\u503c");
        start = System.currentTimeMillis();
        CUBAConfig config = new CUBAConfig();
        config.BUILD_AUTOJOINFACTSQL = false;
        config.BUILD_FACT_IGNORENULLOTHER = false;
        RollupPolicy rollupPolicy = new RollupPolicy();
        rollupPolicy.rowFirst = true;
        rollupPolicy.rowLength = this.queryModel.dimensionsOnRow.length;
        rollupPolicy.columnLength = this.queryModel.dimensionsOnColumn.length;
        if (rollupPolicy.rowLength > 1) {
            rollupPolicy.showSubTotalOnRow = this.queryModel.showSubTotalOnRow;
        }
        rollupPolicy.showTotalOnRow = this.queryModel.showTotalOnRow;
        if (rollupPolicy.columnLength > 1) {
            rollupPolicy.showSubTotalOnColumn = this.queryModel.showSubTotalOnColumn;
        }
        rollupPolicy.showTotalOnColumn = this.queryModel.showTotalOnColumn;
        if (rollupPolicy.rowLength > 0) {
            int[] rowIndex = new int[rollupPolicy.rowLength];
            for (i = 0; i < rowIndex.length; ++i) {
                rowIndex[i] = i;
            }
            rollupPolicy.rows = rowIndex;
        }
        if (rollupPolicy.columnLength > 0) {
            int[] columnIndex = new int[rollupPolicy.columnLength];
            for (i = 0; i < columnIndex.length; ++i) {
                columnIndex[i] = i + rollupPolicy.rowLength;
            }
            rollupPolicy.columns = columnIndex;
        }
        config.rollupPolicy = rollupPolicy;
        CUBADatabase database = CUBAEngine.buildWithoutCheck(schemaDef, this.tableParams, config);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildDatabase cost " + (System.currentTimeMillis() - start) + "ms."));
        }
        this.con = new ConnectionImpl(database);
    }

    private String buildMdx() {
        String formula;
        int i;
        int i2;
        StringBuilder sb = new StringBuilder();
        HashMap<String, List<com.kingdee.bos.streamwork.pivot.model.Member>> mapMemSelection = new HashMap<String, List<com.kingdee.bos.streamwork.pivot.model.Member>>();
        MemberSelection[] mss = this.queryModel.memberSelections;
        if (mss != null) {
            for (int i3 = 0; i3 < mss.length; ++i3) {
                List<com.kingdee.bos.streamwork.pivot.model.Member> memberList = mss[i3].getMemberList();
                mapMemSelection.put(mss[i3].dimension.name, memberList);
            }
        }
        HashMap<String, String> withMembers = new HashMap<String, String>();
        String caption1 = "(\u5c0f\u8ba1)";
        String caption2 = "(\u5408\u8ba1)";
        StringBuilder selectOnRows = null;
        Dimension[] dims = null;
        boolean showSubTotal = this.queryModel.showSubTotalOnRow;
        boolean showTotal = this.queryModel.showTotalOnRow;
        dims = this.queryModel.dimensionsOnRow;
        selectOnRows = new StringBuilder();
        for (i2 = dims.length - 1; i2 >= 0; --i2) {
            String allUniqueName = this.getMemberUniqueName(dims[i2].name, "V$ALL");
            String calmember = this.getMemberUniqueName(dims[i2].name, caption1);
            String formula2 = allUniqueName;
            formula2 = "'" + formula2 + "'";
            withMembers.put(calmember, formula2);
            String calmember2 = this.getMemberUniqueName(dims[i2].name, caption2);
            String formula22 = allUniqueName;
            formula22 = "'" + formula22 + "'";
            withMembers.put(calmember2, formula22);
            String last = selectOnRows.toString();
            selectOnRows = new StringBuilder();
            selectOnRows.append("{");
            selectOnRows.append(this.getDimUniqueName(dims[i2].name)).append(".members");
            if (dims.length == 1 && this.queryModel.measures.length > 0 && showTotal) {
                selectOnRows.append(", (").append(this.getMemberUniqueName(dims[i2].name, caption2)).append(")");
            } else if (i2 < dims.length - 1) {
                selectOnRows.append("*{").append(last);
                if (showSubTotal) {
                    selectOnRows.append(",(");
                    for (int j = i2 + 1; j < dims.length; ++j) {
                        selectOnRows.append(this.getMemberUniqueName(dims[j].name, caption1));
                        if (j >= dims.length - 1) continue;
                        selectOnRows.append(",");
                    }
                    selectOnRows.append(")");
                }
                selectOnRows.append("}");
            }
            selectOnRows.append("}");
        }
        if (dims.length > 1 && showTotal) {
            selectOnRows.append(", (");
            for (i2 = 0; i2 < dims.length; ++i2) {
                selectOnRows.append(this.getMemberUniqueName(dims[i2].name, caption2));
                if (i2 >= dims.length - 1) continue;
                selectOnRows.append(",");
            }
            selectOnRows.append(")");
        }
        showSubTotal = this.queryModel.showSubTotalOnColumn;
        showTotal = this.queryModel.showTotalOnColumn;
        dims = this.queryModel.dimensionsOnColumn;
        StringBuilder selectOnColumns = new StringBuilder();
        for (i = dims.length - 1; i >= 0; --i) {
            String allUniqueName = this.getMemberUniqueName(dims[i].name, "V$ALL");
            String calmember = this.getMemberUniqueName(dims[i].name, caption1);
            formula = allUniqueName;
            formula = "'" + formula + "',caption='" + dims[i].name + caption1 + "'";
            withMembers.put(calmember, formula);
            String calmember2 = this.getMemberUniqueName(dims[i].name, caption2);
            String formula2 = this.getMemberUniqueName(dims[i].name, caption1);
            formula2 = "'" + formula2 + "',caption='" + dims[i].name + caption2 + "'";
            withMembers.put(calmember2, formula2);
            String last = selectOnColumns.toString();
            selectOnColumns = new StringBuilder();
            selectOnColumns.append("{");
            selectOnColumns.append(this.getDimUniqueName(dims[i].name)).append(".members");
            if (dims.length == 1 && this.queryModel.measures.length > 0 && showTotal) {
                selectOnColumns.append(", (").append(this.getMemberUniqueName(dims[i].name, caption2)).append(")");
            } else if (i < dims.length - 1) {
                selectOnColumns.append("*{").append(last);
                if (showSubTotal) {
                    selectOnColumns.append(",(");
                    for (int j = i + 1; j < dims.length; ++j) {
                        selectOnColumns.append(this.getMemberUniqueName(dims[j].name, caption1));
                        if (j >= dims.length - 1) continue;
                        selectOnColumns.append(",");
                    }
                    selectOnColumns.append(")");
                }
                selectOnColumns.append("}");
            }
            selectOnColumns.append("}");
        }
        if (dims.length > 1 && showTotal) {
            selectOnColumns.append(", (");
            for (i = 0; i < dims.length; ++i) {
                selectOnColumns.append(this.getMemberUniqueName(dims[i].name, caption2));
                if (i >= dims.length - 1) continue;
                selectOnColumns.append(",");
            }
            selectOnColumns.append(")");
        }
        if (!withMembers.isEmpty()) {
            sb.append("with ");
            for (Map.Entry entry : withMembers.entrySet()) {
                String name = (String)entry.getKey();
                formula = (String)entry.getValue();
                sb.append(" member ").append(name).append(" as ").append(formula);
            }
        }
        sb.append(" select ");
        if (this.queryModel.dimensionsOnRow.length > 0) {
            sb.append("{").append(selectOnRows.toString()).append("} on rows");
            if (this.queryModel.dimensionsOnColumn.length > 0 || this.queryModel.measures.length > 0) {
                sb.append(",");
            }
        }
        String measuresMdx = this.getMeasuresMembersMdx();
        if (this.queryModel.dimensionsOnColumn.length > 0 && this.queryModel.measures.length > 0) {
            sb.append("{").append(selectOnColumns.toString()).append("} * " + measuresMdx + " on columns");
        } else if (this.queryModel.measures.length > 0) {
            sb.append(" " + measuresMdx + " on columns");
        } else if (this.queryModel.dimensionsOnColumn.length > 0) {
            sb.append("{").append(selectOnColumns.toString()).append("} on columns");
        }
        sb.append(" from cuba");
        System.out.println(sb.toString());
        return sb.toString();
    }

    private String getDimUniqueName(String dim) {
        return UniqueNameUtil.makeUniqueName(dim);
    }

    private String getMemberUniqueName(String dim, String member) {
        if ("V$NULL".equals(member) || com.kingdee.bos.streamwork.pivot.model.Member.NULL_CAPTION.equals(member)) {
            member = "V$NULL";
        }
        return UniqueNameUtil.createUniqueName(new String[]{dim, member});
    }

    private HashMap buildTables() {
        int i;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fact", this.buildFactTable());
        HashMap<String, List<com.kingdee.bos.streamwork.pivot.model.Member>> msDims = new HashMap<String, List<com.kingdee.bos.streamwork.pivot.model.Member>>();
        if (this.queryModel.memberSelections != null) {
            for (i = 0; i < this.queryModel.memberSelections.length; ++i) {
                List<com.kingdee.bos.streamwork.pivot.model.Member> memberList = this.queryModel.memberSelections[i].getNonNullMemberList();
                if (memberList.isEmpty()) continue;
                msDims.put(this.queryModel.memberSelections[i].dimension.name, memberList);
            }
        }
        for (i = 0; i < this.queryModel.dimensions.length; ++i) {
            ArrayTable table = null;
            table = msDims.containsKey(this.queryModel.dimensions[i].name) ? this.buildDimTable(this.queryModel.dimensions[i].name, (List)msDims.get(this.queryModel.dimensions[i].name)) : this.buildDimTable(this.queryModel.dimensions[i].name);
            map.put(this.queryModel.dimensions[i].name, table);
            this.dimSize.put(-table.getRowCount(), this.queryModel.dimensions[i].name);
        }
        return map;
    }

    private ArrayTable buildDimTable(String name, List<com.kingdee.bos.streamwork.pivot.model.Member> memberList) {
        String[] header = new String[]{name};
        int[] dataTypes = new int[]{12};
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        boolean rowIndex = false;
        for (com.kingdee.bos.streamwork.pivot.model.Member member : memberList) {
            if (member.value == null) continue;
            values.add(new Object[]{member.value});
        }
        Object[][] values2 = new Object[values.size()][];
        values.toArray((T[])values2);
        return new ArrayTable(values2, header, dataTypes);
    }

    private ArrayTable buildDimTable(String name) {
        String[] header = new String[]{name};
        int[] dataTypes = new int[]{12};
        int columnIndex = Arrays.asList(this.dataSource.getColumnNames()).indexOf(name);
        int rowCount = this.dataSource.getRowCount();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < rowCount; ++i) {
            Object v = this.dataSource.getCell(columnIndex, i);
            if (v == null || set.contains(v)) continue;
            list.add(new Object[]{v});
            set.add(v);
        }
        set.clear();
        Object[][] values = (Object[][])list.toArray((T[])new Object[0][1]);
        return new ArrayTable(values, header, dataTypes);
    }

    private Object buildFactTable() {
        FactTable factTable = new FactTable();
        String billHeaderFields = (String)this.dataSource.getProperty("billHeaderFields");
        String billNumberField = (String)this.dataSource.getProperty("billNumberField");
        if (billNumberField != null && billHeaderFields != null) {
            String[] parts = billHeaderFields.split(",");
            HashSet<String> set = new HashSet<String>(parts.length);
            for (int i = 0; i < parts.length; ++i) {
                set.add(parts[i]);
            }
            ArrayList<String> headerMeasureFields = new ArrayList<String>();
            for (int i = 0; i < this.queryModel.measures.length; ++i) {
                String field;
                if (this.queryModel.measures[i].isCountMeasure || !set.contains(field = this.queryModel.measures[i].name) || billNumberField.equals(field)) continue;
                headerMeasureFields.add(field);
            }
            if (headerMeasureFields.size() > 0) {
                return new FactTableX(factTable, billNumberField, headerMeasureFields);
            }
        }
        return factTable;
    }

    private SchemaDef buildSchema(HashMap tableParams) {
        SchemaDef schemaDef = new SchemaDef();
        schemaDef.caption = "cuba";
        schemaDef.name = "cuba";
        CubeDef cubeDef = new CubeDef();
        schemaDef.cubes = new CubeDef[]{cubeDef};
        cubeDef.name = "cuba";
        cubeDef.table = "fact";
        schemaDef.dimensions = new SharedDimensionDef[this.queryModel.dimensions.length];
        cubeDef.dimensions = new DimensionUsageDef[this.queryModel.dimensions.length];
        ArrayList<ParameterDef> paramList = new ArrayList<ParameterDef>();
        for (int i = 0; i < schemaDef.dimensions.length; ++i) {
            schemaDef.dimensions[i] = new SharedDimensionDef();
            this.buildDim(schemaDef.dimensions[i], this.queryModel.dimensions[i].name);
            DimensionUsageDef usageDef = new DimensionUsageDef();
            cubeDef.dimensions[i] = usageDef;
            this.buildDimUsage(usageDef, this.queryModel.dimensions[i].name);
            ParameterDef paramDef = new ParameterDef();
            this.buildDimParam(paramDef, this.queryModel.dimensions[i].name);
            paramList.add(paramDef);
        }
        ParameterDef factTableDef = new ParameterDef();
        factTableDef.name = "fact";
        factTableDef.type = "Table";
        paramList.add(factTableDef);
        schemaDef.parameters = paramList.toArray(new ParameterDef[0]);
        this.buildCubeMeasureDefs(cubeDef);
        return schemaDef;
    }

    class FactTableX
    implements Table {
        FactTable factTable;
        private int headerFieldIndex;
        private boolean[] isHeaderMeasureFields;
        private HashSet[] headerValueSets;

        public FactTableX(FactTable factTable, String headerField, List headerMeasureFields) {
            this.factTable = factTable;
            try {
                this.headerFieldIndex = factTable.getColumnIndex(headerField);
                this.isHeaderMeasureFields = new boolean[factTable.getColumnCount()];
                this.headerValueSets = new HashSet[factTable.getColumnCount()];
                Iterator iter = headerMeasureFields.iterator();
                while (iter.hasNext()) {
                    int index = factTable.getColumnIndex((String)iter.next());
                    this.isHeaderMeasureFields[index] = true;
                    this.headerValueSets[index] = new HashSet();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }

        @Override
        public int getColumnCount() throws CUBAException {
            return this.factTable.getColumnCount();
        }

        @Override
        public int getColumnType(int index) throws CUBAException {
            return this.factTable.getColumnType(index);
        }

        @Override
        public int getColumnIndex(String name) throws CUBAException {
            return this.factTable.getColumnIndex(name);
        }

        @Override
        public String[] getColumnNames() throws CUBAException {
            return this.factTable.getColumnNames();
        }

        @Override
        public boolean next() throws CUBAException {
            return this.factTable.next();
        }

        @Override
        public Object getValue(int index) throws CUBAException {
            if (!this.isHeaderMeasureFields[index]) {
                return this.factTable.getValue(index);
            }
            Object h = this.factTable.getValue(this.headerFieldIndex);
            if (this.headerValueSets[index].contains(h)) {
                return null;
            }
            this.headerValueSets[index].add(h);
            return this.factTable.getValue(index);
        }

        @Override
        public Object[] getValues() throws CUBAException {
            throw new RuntimeException("Undo");
        }

        @Override
        public void close() {
            this.headerValueSets = null;
            this.factTable.close();
        }
    }

    class FactTable
    implements Table {
        String[] header;
        HashMap<String, Integer> indexMap = new HashMap();
        int[] dataTypes;
        int dataSourceRowCount;
        HashSet[] valuesSelectedList;
        private int cursor = -1;
        private Object[] row = null;

        public FactTable() {
            int i;
            this.header = CubaBuilderForExcelPivot.this.dataSource.getColumnNames();
            ArrayList<String> measureNames = new ArrayList<String>();
            for (i = 0; i < CubaBuilderForExcelPivot.this.queryModel.measures.length; ++i) {
                measureNames.add(CubaBuilderForExcelPivot.this.queryModel.measures[i].name);
            }
            this.dataTypes = new int[this.header.length];
            for (i = 0; i < this.header.length; ++i) {
                String name = this.header[i];
                if (!this.indexMap.containsKey(name)) {
                    this.indexMap.put(name, i);
                }
                this.dataTypes[i] = measureNames.contains(name) ? 2 : 12;
            }
            if (CubaBuilderForExcelPivot.this.queryModel.memberSelections != null) {
                this.valuesSelectedList = new HashSet[this.header.length];
                for (i = 0; i < CubaBuilderForExcelPivot.this.queryModel.memberSelections.length; ++i) {
                    MemberSelection memberSelection = CubaBuilderForExcelPivot.this.queryModel.memberSelections[i];
                    List<com.kingdee.bos.streamwork.pivot.model.Member> memberList = memberSelection.getMemberList();
                    int index = this.indexMap.get(memberSelection.dimension.name);
                    this.valuesSelectedList[index] = this.createSelectedList(memberList);
                }
            }
            this.dataSourceRowCount = CubaBuilderForExcelPivot.this.dataSource.getRowCount();
        }

        public HashSet createSelectedList(List<com.kingdee.bos.streamwork.pivot.model.Member> memberList) {
            HashSet<Object> result = new HashSet<Object>();
            Iterator<com.kingdee.bos.streamwork.pivot.model.Member> iter = memberList.iterator();
            while (iter.hasNext()) {
                result.add(iter.next().value);
            }
            return result;
        }

        @Override
        public int getColumnCount() throws CUBAException {
            return this.header.length;
        }

        @Override
        public int getColumnType(int index) throws CUBAException {
            return this.dataTypes[index];
        }

        @Override
        public int getColumnIndex(String name) throws CUBAException {
            return this.indexMap.get(name);
        }

        @Override
        public String[] getColumnNames() throws CUBAException {
            return this.header;
        }

        @Override
        public boolean next() throws CUBAException {
            do {
                ++this.cursor;
                if (this.cursor >= this.dataSourceRowCount) {
                    return false;
                }
                this.row = this.getRow(this.cursor);
            } while (!this.isGoodRow());
            return true;
        }

        private Object[] getRow(int cursor) {
            int columnCount = CubaBuilderForExcelPivot.this.dataSource.getColumnNames().length;
            Object[] array = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                array[i] = CubaBuilderForExcelPivot.this.dataSource.getCell(i, cursor);
            }
            return array;
        }

        @Override
        public Object getValue(int index) throws CUBAException {
            return this.row[index];
        }

        @Override
        public Object[] getValues() throws CUBAException {
            return this.row;
        }

        @Override
        public void close() {
            this.cursor = -1;
        }

        public boolean isGoodRow() {
            if (this.valuesSelectedList == null) {
                return true;
            }
            for (int i = 0; i < this.valuesSelectedList.length; ++i) {
                if (this.valuesSelectedList[i] == null || this.valuesSelectedList[i].contains(this.row[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class TupleKey {
        Object[] values;

        public TupleKey(Object[] values) {
            this.values = values;
        }

        public int hashCode() {
            int code = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                code += this.values[i].hashCode() * (17 + i);
            }
            return code;
        }

        public boolean equals(Object x) {
            TupleKey key2 = (TupleKey)x;
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == key2.values[i]) continue;
                return false;
            }
            return true;
        }
    }
}

