/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.execute;

import com.kingdee.bos.streamwork.cuba.Axis;
import com.kingdee.bos.streamwork.cuba.Cell;
import com.kingdee.bos.streamwork.cuba.MdxResult;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.Position;
import com.kingdee.bos.streamwork.cuba.ResultOverflowInfo;
import com.kingdee.bos.streamwork.cuba.impl.AxisImpl;
import com.kingdee.bos.streamwork.cuba.impl.PositionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class OrderedMdxResult
implements MdxResult {
    MdxResult inner;
    Member orderMeasure;
    boolean desc;
    Axis innerLeftAxis;
    Axis innerTopAxis;
    int orderMeasureIndex;
    int leftDimCount;
    Axis orderedLeftAxis;
    HashMap<Integer, Integer> leftPosMap = new HashMap();
    Axis[] axes;
    Comparator<TreeNode> treeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1.member.isCalculated()) {
                return 1;
            }
            if (o2.member.isCalculated()) {
                return -1;
            }
            if (o1.value == o2.value) {
                return 0;
            }
            if (o1.value == null) {
                return -1;
            }
            if (o2.value == null) {
                return 1;
            }
            if (o1.value instanceof Comparable) {
                return ((Comparable)o1.value).compareTo((Comparable)o2.value);
            }
            return 0;
        }
    };
    Comparator<TreeNode> reverseComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1.member.isCalculated()) {
                return 1;
            }
            if (o2.member.isCalculated()) {
                return -1;
            }
            if (o1.value == o2.value) {
                return 0;
            }
            if (o1.value == null) {
                return 1;
            }
            if (o2.value == null) {
                return -1;
            }
            if (o1.value instanceof Comparable) {
                return -((Comparable)o1.value).compareTo((Comparable)o2.value);
            }
            return 0;
        }
    };
    TreeNode rootNode = new TreeNode();

    public OrderedMdxResult(MdxResult inner, Member orderMeasure, boolean desc) {
        this.inner = inner;
        this.orderMeasure = orderMeasure;
        this.desc = desc;
        this.build();
    }

    public MdxResult getInner() {
        return this.inner;
    }

    private void build() {
        this.innerTopAxis = this.inner.getAxes()[1];
        Member[] measures = new Member[this.innerTopAxis.getPositionCount()];
        Iterator<Position> iterator = this.innerTopAxis.getPositionIterator();
        for (int i = 0; i < measures.length; ++i) {
            measures[i] = iterator.next().getMembers()[0];
            if (!measures[i].equals(this.orderMeasure)) continue;
            this.orderMeasureIndex = i;
            break;
        }
        this.innerLeftAxis = this.inner.getAxes()[0];
        this.leftDimCount = this.innerLeftAxis.getHierarchies().length;
        Iterator<Position> positionIterator = this.innerLeftAxis.getPositionIterator();
        int i = 0;
        while (positionIterator.hasNext()) {
            Position position = positionIterator.next();
            Member[] tuple = position.getMembers();
            Object value = this.inner.getCell(new int[]{i, this.orderMeasureIndex}).getValue();
            this.buildTuple(tuple, value, i);
            ++i;
        }
        this.rootNode.sortChildren(this.desc ? this.reverseComparator : this.treeComparator);
        ArrayList<Position> orderedPositionList = new ArrayList<Position>();
        this.makeOrderList(this.rootNode.children, orderedPositionList);
        PositionImpl[] poses = new PositionImpl[orderedPositionList.size()];
        orderedPositionList.toArray(poses);
        this.orderedLeftAxis = new AxisImpl(this.innerLeftAxis.getName(), this.innerLeftAxis.getHierarchies(), poses);
        this.axes = new Axis[]{this.orderedLeftAxis, this.inner.getAxes()[1]};
    }

    private void makeOrderList(ArrayList<TreeNode> children, ArrayList<Position> orderedPositionList) {
        for (TreeNode node : children) {
            if (node.hasChildren()) {
                this.makeOrderList(node.children, orderedPositionList);
                continue;
            }
            int innerPos = node.innerPos;
            Member[] ms = new Member[this.leftDimCount];
            PositionImpl pos = new PositionImpl(ms);
            for (int index = 0; index < this.leftDimCount; ++index) {
                ms[this.leftDimCount - 1 - index] = node.member;
                node = node.parent;
            }
            this.leftPosMap.put(orderedPositionList.size(), innerPos);
            orderedPositionList.add(pos);
        }
    }

    private void buildTuple(Member[] tuple, Object value, int innerPos) {
        TreeNode node = this.rootNode.addChild(tuple[0], value, innerPos);
        for (int i = 1; i < tuple.length; ++i) {
            node = node.addChild(tuple[i], value, innerPos);
        }
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public Axis getSlicerAxis() {
        return this.inner.getSlicerAxis();
    }

    @Override
    public Cell getCell(int[] pos) {
        pos[0] = this.leftPosMap.get(pos[0]);
        return this.inner.getCell(pos);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public ResultOverflowInfo getOverflowInfo() {
        return null;
    }

    @Override
    public void setOverflowInfo(ResultOverflowInfo overflowInfo) {
    }

    class TreeNode {
        public Member member;
        public TreeNode parent;
        public ArrayList<TreeNode> children = new ArrayList();
        public HashMap<Member, TreeNode> childrenMap = new HashMap();
        public int innerPos;
        public Object value;

        TreeNode() {
        }

        public TreeNode addChild(Member member, Object value, int innerPos) {
            TreeNode node = this.childrenMap.get(member);
            if (node == null) {
                node = new TreeNode();
                node.member = member;
                node.parent = this;
                node.value = value;
                node.innerPos = innerPos;
                this.children.add(node);
                this.childrenMap.put(member, node);
            }
            if (member.isCalculated() || member.isInner()) {
                this.value = value;
            }
            return node;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public void sortChildren(Comparator<TreeNode> comparator) {
            Collections.sort(this.children, comparator);
            for (TreeNode node : this.children) {
                node.sortChildren(comparator);
            }
        }
    }
}

