/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.model;

import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.pivot.model.ColumnValues;
import com.kingdee.bos.streamwork.pivot.model.DataModelListener;
import com.kingdee.bos.streamwork.pivot.model.DataModelSupport;
import com.kingdee.bos.streamwork.pivot.model.DataType;
import com.kingdee.bos.streamwork.pivot.model.Dimension;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.model.MemberSelection;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataModel
implements DataModelSupport {
    private DataSource dataSource;
    private List<String> allColumns = new ArrayList<String>();
    private HashMap<String, ColumnValues> columnValuesMap = new HashMap();
    private List<String> columnsInDimension = new ArrayList<String>();
    private List<String> columnsInMeasure = new ArrayList<String>();
    private ArrayList<String> selectedDimensionsOnRows = new ArrayList();
    private ArrayList<String> selectedDimensionsOnColumn = new ArrayList();
    private HashMap<String, List> columnSelectedValues = new HashMap();
    private HashMap<String, Measure> measuresMap = new HashMap();
    private ArrayList<String> selectedMeasures = new ArrayList();
    private LinkedList<DataModelListener> listeners = new LinkedList();

    public DataModel(DataSource dataSource) {
        this.dataSource = dataSource;
        this.build();
    }

    private void build() {
        int rowCount = this.dataSource.getRowCount();
        String[] header = this.dataSource.getColumnNames();
        for (int i = 0; i < header.length; ++i) {
            String dim = header[i];
            ColumnValues cv = this.buildColumnValues(dim, i);
            if (cv.isEmpty() || this.exceedCard(cv, rowCount)) continue;
            this.columnValuesMap.put(dim, cv);
            this.allColumns.add(dim);
            if (DataType.isNumber(cv.getDataType())) {
                this.columnsInMeasure.add(dim);
                this.measuresMap.put(dim, this.createMeasure(dim, cv));
                continue;
            }
            this.columnsInDimension.add(dim);
        }
        this.initDefaultSelect();
    }

    private boolean exceedCard(ColumnValues cv, int rowCount) {
        return false;
    }

    private void initDefaultSelect() {
        if (this.columnsInMeasure.size() > 0) {
            this.selectedMeasures.add(this.columnsInMeasure.get(0));
        }
        if (this.columnsInDimension.size() > 0) {
            this.selectedDimensionsOnRows.add(this.columnsInDimension.get(0));
        }
    }

    @Override
    public String[] getColumns() {
        return this.allColumns.toArray(new String[0]);
    }

    public Measure createMeasure(String dim) {
        return this.createMeasure(dim, this.columnValuesMap.get(dim));
    }

    private Measure createMeasure(String dim, ColumnValues cv) {
        return new Measure(dim, 0, cv.getDataType());
    }

    private ColumnValues buildColumnValues(String dim, int columnIndex) {
        ColumnValues cv = new ColumnValues(dim);
        int rowCount = this.dataSource.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object value = this.dataSource.getCell(columnIndex, i);
            cv.addValue(value);
        }
        return cv;
    }

    @Override
    public QueryModel getQueryModel() {
        int i;
        QueryModel queryModel = new QueryModel();
        if (this.selectedMeasures.isEmpty() && this.selectedDimensionsOnRows.isEmpty() && this.selectedDimensionsOnColumn.isEmpty()) {
            return null;
        }
        ArrayList<String> allUsedDimColumns = new ArrayList<String>();
        allUsedDimColumns.addAll(this.selectedDimensionsOnRows);
        allUsedDimColumns.addAll(this.selectedDimensionsOnColumn);
        for (Map.Entry<String, List> entry : this.columnSelectedValues.entrySet()) {
            String column = entry.getKey();
            if (entry.getValue().isEmpty() || allUsedDimColumns.contains(column)) continue;
            allUsedDimColumns.add(column);
        }
        int size = allUsedDimColumns.size();
        queryModel.dimensions = new Dimension[size];
        HashMap<String, Dimension> allDims = new HashMap<String, Dimension>();
        ArrayList<Dimension> onRows = new ArrayList<Dimension>();
        ArrayList<Dimension> onColumns = new ArrayList<Dimension>();
        for (i = 0; i < size; ++i) {
            Dimension dimension;
            String dim = (String)allUsedDimColumns.get(i);
            queryModel.dimensions[i] = dimension = this.createDimension(this.columnValuesMap.get(dim));
            allDims.put(dim, dimension);
            if (this.selectedDimensionsOnRows.contains(dim)) {
                onRows.add(dimension);
                continue;
            }
            if (!this.selectedDimensionsOnColumn.contains(dim)) continue;
            onColumns.add(dimension);
        }
        queryModel.dimensionsOnRow = new Dimension[onRows.size()];
        onRows.toArray(queryModel.dimensionsOnRow);
        queryModel.dimensionsOnColumn = new Dimension[onColumns.size()];
        onColumns.toArray(queryModel.dimensionsOnColumn);
        size = this.selectedMeasures.size();
        queryModel.measures = new Measure[size];
        for (i = 0; i < size; ++i) {
            String measureName = this.selectedMeasures.get(i);
            queryModel.measures[i] = this.createMeasure(this.measuresMap.get(measureName));
        }
        size = this.columnSelectedValues.size();
        if (size > 0) {
            ArrayList<MemberSelection> listMemberSelections = new ArrayList<MemberSelection>();
            for (Map.Entry<String, List> entry : this.columnSelectedValues.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                listMemberSelections.add(this.createMemberSelection(allDims, entry.getKey(), entry.getValue()));
            }
            if (listMemberSelections.size() > 0) {
                queryModel.memberSelections = new MemberSelection[listMemberSelections.size()];
                listMemberSelections.toArray(queryModel.memberSelections);
            }
        }
        return queryModel;
    }

    private MemberSelection createMemberSelection(HashMap<String, Dimension> allDims, String dim, List values) {
        Dimension dimension = allDims.get(dim);
        MemberSelection memberSelection = new MemberSelection(dimension);
        ArrayList orderedValues = new ArrayList();
        for (Object value : this.columnValuesMap.get(dim).getValues()) {
            if (!values.contains(value)) continue;
            orderedValues.add(value);
        }
        ArrayList values2 = new ArrayList();
        values2.addAll(values);
        values2.removeAll(orderedValues);
        orderedValues.addAll(values2);
        Iterator iter = orderedValues.iterator();
        while (iter.hasNext()) {
            memberSelection.addMember(iter.next());
        }
        return memberSelection;
    }

    private Measure createMeasure(Measure measure) {
        return measure.copy();
    }

    private Dimension createDimension(ColumnValues cv) {
        Dimension dim = new Dimension(cv.getColumnName());
        Iterator iter = cv.getValues().iterator();
        while (iter.hasNext()) {
            dim.createMember(iter.next());
        }
        return dim;
    }

    @Override
    public void dimensionSelected(String column, boolean selected) {
        while (this.selectedDimensionsOnRows.contains(column)) {
            this.selectedDimensionsOnRows.remove(column);
        }
        if (selected) {
            this.selectedDimensionsOnRows.add(column);
        }
        this.modelChanged(true);
    }

    public void measureSelected(String column, boolean selected) {
        if (selected) {
            this.selectedMeasures.add(column);
        } else {
            this.selectedMeasures.remove(column);
        }
        this.modelChanged(true);
    }

    @Override
    public void setSelectedMeasures(String[] columns) {
        this.selectedMeasures.clear();
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                this.selectedMeasures.add(columns[i]);
            }
        }
        this.modelChanged(true);
    }

    @Override
    public void setAsMeasure(String column) {
        this.columnsInDimension.remove(column);
        this.columnSelectedValues.remove(column);
        int beforeIndex = -1;
        int index = this.allColumns.indexOf(column);
        for (int i = 0; i < index; ++i) {
            String s = this.allColumns.get(i);
            if (!this.columnsInMeasure.contains(s)) continue;
            beforeIndex = i;
        }
        if (beforeIndex != -1) {
            this.columnsInMeasure.add(beforeIndex, column);
        } else {
            this.columnsInMeasure.add(0, column);
        }
        if (!this.measuresMap.containsKey(column)) {
            this.measuresMap.put(column, this.createMeasure(column));
        }
        this.modelChanged(true);
    }

    public void setAsDimension(String column) {
        this.columnsInMeasure.remove(column);
        int beforeIndex = -1;
        int index = this.allColumns.indexOf(column);
        for (int i = 0; i < index; ++i) {
            String s = this.allColumns.get(i);
            if (!this.columnsInDimension.contains(s)) continue;
            beforeIndex = i;
        }
        if (beforeIndex != -1) {
            this.columnsInDimension.add(beforeIndex, column);
        } else {
            this.columnsInDimension.add(0, column);
        }
        this.modelChanged(true);
    }

    @Override
    public void setSelectedMembers(String column, Object[] values) {
        ArrayList<Object> list = this.columnSelectedValues.get(column);
        if (list == null) {
            list = new ArrayList<Object>();
            this.columnSelectedValues.put(column, list);
        } else {
            list.clear();
        }
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                list.add(values[i]);
            }
        }
        this.modelChanged(true);
    }

    @Override
    public void measureArgTypeChanged(String column, int argType) {
        this.measuresMap.get((Object)column).aggType = argType;
        if (this.selectedMeasures.contains(column)) {
            this.modelChanged(true);
        }
    }

    @Override
    public void dimensionMoveBefore(String src, String dest) {
        this.moveBefore(this.allColumns, src, dest);
        this.moveBefore(this.columnsInDimension, src, dest);
        this.modelChanged(true);
    }

    @Override
    public void dimensionMoveAfter(String src, String dest) {
        this.moveAfter(this.allColumns, src, dest);
        this.moveAfter(this.columnsInDimension, src, dest);
        this.modelChanged(true);
    }

    @Override
    public void measureMoveBefore(String src, String dest) {
        this.moveBefore(this.allColumns, src, dest);
        this.moveBefore(this.columnsInMeasure, src, dest);
        this.modelChanged(true);
    }

    @Override
    public void measureMoveAfter(String src, String dest) {
        this.moveAfter(this.allColumns, src, dest);
        this.moveAfter(this.columnsInMeasure, src, dest);
        this.modelChanged(true);
    }

    private void moveBefore(List<String> list, String src, String dest) {
        if (list.contains(src) && list.contains(dest)) {
            list.remove(src);
            list.add(list.indexOf(dest), src);
        }
    }

    private void moveAfter(List<String> list, String src, String dest) {
        list.remove(src);
        list.add(list.indexOf(dest) + 1, src);
    }

    @Override
    public DataModel getDataModel() {
        return this;
    }

    @Override
    public ColumnValues getColumnValues(String column) {
        return this.columnValuesMap.get(column);
    }

    @Override
    public String[] getColumnsInDimension() {
        return this.columnsInDimension.toArray(new String[0]);
    }

    @Override
    public Measure[] getMeasures() {
        Measure[] ms = new Measure[this.columnsInMeasure.size()];
        for (int i = 0; i < ms.length; ++i) {
            String column = this.columnsInMeasure.get(i);
            ms[i] = this.measuresMap.get(column);
        }
        return ms;
    }

    @Override
    public boolean isDimensionSelected(String column) {
        return this.selectedDimensionsOnRows.contains(column);
    }

    @Override
    public boolean isMeasureSelected(String column) {
        return this.selectedMeasures.contains(column);
    }

    public void modelChanged(boolean needBuildData) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((DataModelListener)iter.next()).changed(needBuildData);
        }
    }

    @Override
    public void addListener(DataModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DataModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setSelectedDimensionOnRows(String[] columns) {
        this.selectedDimensionsOnRows.clear();
        this.selectedDimensionsOnRows.addAll(Arrays.asList(columns));
        this.modelChanged(true);
    }

    public void setSelectedDimensionOnColumns(String[] columns) {
        this.selectedDimensionsOnColumn.clear();
        this.selectedDimensionsOnColumn.addAll(Arrays.asList(columns));
    }

    public void setMeasures(Measure[] measures) {
        this.measuresMap.clear();
        for (int i = 0; i < measures.length; ++i) {
            this.measuresMap.put(measures[i].name, measures[i]);
        }
    }

    public List getSelectedValues(String column) {
        return this.columnSelectedValues.get(column);
    }
}

