/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.model;

import com.kingdee.bos.streamwork.calculator.CalculatedField;
import com.kingdee.bos.streamwork.datasource.DataSource;
import com.kingdee.bos.streamwork.datasource.DataSourceWithCalculate;
import com.kingdee.bos.streamwork.metric.Metric;
import com.kingdee.bos.streamwork.pivot.model.ColumnValues;
import com.kingdee.bos.streamwork.pivot.model.DataModelListener;
import com.kingdee.bos.streamwork.pivot.model.DataModelSupport2;
import com.kingdee.bos.streamwork.pivot.model.DataType;
import com.kingdee.bos.streamwork.pivot.model.Dimension;
import com.kingdee.bos.streamwork.pivot.model.Measure;
import com.kingdee.bos.streamwork.pivot.model.MemberSelection;
import com.kingdee.bos.streamwork.pivot.model.QueryModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataModel2
implements DataModelSupport2 {
    private static final Logger logger = Logger.getLogger(DataModel2.class);
    private DataSource dataSource;
    private List<String> allColumns = new ArrayList<String>();
    private HashMap<String, ColumnValues> columnValuesMap = new HashMap();
    private ArrayList<String> columnsOnRows = new ArrayList();
    private ArrayList<String> columnsOnColumns = new ArrayList();
    private ArrayList<String> columnsOnMeasure = new ArrayList();
    private HashMap<String, List> columnSelectedValues = new HashMap();
    private ArrayList<Measure> measuresList = new ArrayList();
    private List<String> columnsCanbeDimension = new ArrayList<String>();
    private List<String> columnsCanbeMeasure = new ArrayList<String>();
    private List<Metric> metricList = new ArrayList<Metric>();
    public boolean showSubTotalOnRow;
    public boolean showTotalOnRow;
    public boolean showSubTotalOnColumn;
    public boolean showTotalOnColumn;
    public int columnModel;
    public int scale = 2;
    private long lastStateTime = System.currentTimeMillis();
    private LinkedList<DataModelListener> listeners = new LinkedList();
    public boolean disableListeners = false;

    public DataModel2(DataSource dataSource) {
        this.dataSource = dataSource;
        long start = System.currentTimeMillis();
        this.build();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataModel2.build cost " + (System.currentTimeMillis() - start) + "ms."));
        }
    }

    private void build() {
        ColumnValues cv;
        int i;
        int rowCount = this.dataSource.getRowCount();
        String[] header = this.dataSource.getColumnNames();
        ColumnValues[] cvs = new ColumnValues[header.length];
        for (i = 0; i < header.length; ++i) {
            String dim = header[i];
            cvs[i] = new ColumnValues(dim);
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int i2 = 0; i2 < header.length; ++i2) {
                cv = cvs[i2];
                cv.addValue(this.dataSource.getCell(i2, rowIndex));
            }
        }
        for (i = 0; i < header.length; ++i) {
            String dim = header[i];
            cv = cvs[i];
            cv.finishAdd();
            if ("id".equals(dim) || cv.isEmpty() || this.exceedCard(cv, rowCount)) continue;
            this.columnValuesMap.put(dim, cv);
            this.allColumns.add(dim);
            if (DataType.isNumber(cv.getDataType())) {
                this.columnsCanbeMeasure.add(dim);
                continue;
            }
            this.columnsCanbeDimension.add(dim);
        }
        String dim = "\u884c\u8ba1\u6570";
        this.allColumns.add(dim);
        this.addMeasure(this.createCountMeasure(dim));
    }

    public void clearCalculatedFields() {
        List<CalculatedField> list = ((DataSourceWithCalculate)this.dataSource).getAllCalculatedFields();
        CalculatedField[] fields = list.toArray(new CalculatedField[0]);
        for (int i = 0; i < fields.length; ++i) {
            this.removeCalculatedField(fields[i].name);
        }
    }

    public void clearMetric() {
        this.metricList.clear();
    }

    private boolean supportCalculated() {
        return this.dataSource instanceof DataSourceWithCalculate;
    }

    public void removeCalculatedField(String dim) {
        ((DataSourceWithCalculate)this.dataSource).removeCalculatedField(dim);
        this.allColumns.remove(dim);
        this.columnValuesMap.remove(dim);
        this.columnsCanbeMeasure.remove(dim);
        this.columnsCanbeDimension.remove(dim);
        for (Measure m : this.measuresList) {
            if (!m.name.equals(dim)) continue;
            this.measuresList.remove(m);
            break;
        }
    }

    public void removeCalculatedField(CalculatedField field) {
        String dim = field.name;
        ((DataSourceWithCalculate)this.dataSource).removeCalculatedField(field);
        this.allColumns.remove(field.name);
        this.columnValuesMap.remove(dim);
        this.columnsCanbeMeasure.remove(dim);
        this.columnsCanbeDimension.remove(dim);
        for (Measure m : this.measuresList) {
            if (!m.name.equals(dim)) continue;
            this.measuresList.remove(m);
            break;
        }
    }

    public void addCalculatedField(CalculatedField field) {
        int rowCount = this.dataSource.getRowCount();
        String dim = field.name;
        ((DataSourceWithCalculate)this.dataSource).addCalculatedField(field);
        this.allColumns.add(field.name);
        ColumnValues cv = new ColumnValues(field.name);
        int columnCount = this.dataSource.getColumnTypes().length;
        for (int rowIndex = 0; rowIndex < this.dataSource.getRowCount(); ++rowIndex) {
            cv.addValue(this.dataSource.getCell(columnCount - 1, rowIndex));
        }
        cv.finishAdd();
        this.columnValuesMap.put(dim, cv);
        if (DataType.isNumber(cv.getDataType())) {
            this.columnsCanbeMeasure.add(dim);
        } else {
            this.columnsCanbeDimension.add(dim);
        }
    }

    public void clearMeasures() {
        this.measuresList.clear();
    }

    public void addMeasure(Measure measure) {
        this.measuresList.add(measure);
    }

    private Measure createCountMeasure(String dim) {
        Measure m = new Measure(dim, 4, 4, true);
        return m;
    }

    private Measure createMetricMeasure(Metric metric) {
        return new Measure(metric);
    }

    private boolean exceedCard(ColumnValues cv, int rowCount) {
        if (rowCount < 10000) {
            return false;
        }
        double card = 1.0 * (double)cv.getValues().size() / (double)rowCount;
        return card >= (double)0.9f;
    }

    @Override
    public String[] getAllColumns() {
        return this.allColumns.toArray(new String[0]);
    }

    public Measure createMeasure(String dim, int aggType) {
        if ("\u884c\u8ba1\u6570".equals(dim)) {
            return this.createCountMeasure(dim);
        }
        Metric metric = this.getMetric(dim);
        if (metric != null) {
            return new Measure(metric);
        }
        return new Measure(dim, aggType, this.columnValuesMap.get(dim).getDataType());
    }

    private ColumnValues buildColumnValues(String dim, int columnIndex) {
        ColumnValues cv = new ColumnValues(dim);
        int rowCount = this.dataSource.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object value = this.dataSource.getCell(columnIndex, i);
            cv.addValue(value);
        }
        return cv;
    }

    @Override
    public QueryModel getQueryModel() {
        if (this.columnsOnRows.isEmpty() && this.columnsOnColumns.isEmpty() && this.columnsOnMeasure.isEmpty()) {
            return null;
        }
        QueryModel queryModel = new QueryModel();
        queryModel.showSubTotalOnColumn = this.showSubTotalOnColumn;
        queryModel.showSubTotalOnRow = this.showSubTotalOnRow;
        queryModel.showTotalOnColumn = this.showTotalOnColumn;
        queryModel.showTotalOnRow = this.showTotalOnRow;
        queryModel.columnModel = this.columnModel;
        queryModel.scale = this.scale;
        queryModel.metrics = this.metricList.toArray(new Metric[0]);
        HashMap<String, Dimension> allColumnDims = new HashMap<String, Dimension>();
        for (int i = 0; i < this.allColumns.size(); ++i) {
            String dim = this.allColumns.get(i);
            if ("\u884c\u8ba1\u6570".equals(dim)) continue;
            Dimension dimension = this.createDimension(this.columnValuesMap.get(dim));
            allColumnDims.put(dim, dimension);
        }
        int size = this.columnsOnRows.size();
        ArrayList onRows = new ArrayList();
        for (int i = 0; i < size; ++i) {
            onRows.add(allColumnDims.get(this.columnsOnRows.get(i)));
        }
        queryModel.dimensionsOnRow = new Dimension[this.columnsOnRows.size()];
        onRows.toArray(queryModel.dimensionsOnRow);
        size = this.columnsOnColumns.size();
        ArrayList onColumns = new ArrayList();
        for (int i = 0; i < size; ++i) {
            onColumns.add(allColumnDims.get(this.columnsOnColumns.get(i)));
        }
        queryModel.dimensionsOnColumn = new Dimension[this.columnsOnColumns.size()];
        onColumns.toArray(queryModel.dimensionsOnColumn);
        queryModel.dimensions = new Dimension[onRows.size() + onColumns.size()];
        System.arraycopy(queryModel.dimensionsOnRow, 0, queryModel.dimensions, 0, queryModel.dimensionsOnRow.length);
        System.arraycopy(queryModel.dimensionsOnColumn, 0, queryModel.dimensions, queryModel.dimensionsOnRow.length, queryModel.dimensionsOnColumn.length);
        size = this.columnsOnMeasure.size();
        queryModel.measures = this.getMeasures();
        size = this.columnSelectedValues.size();
        if (size > 0) {
            ArrayList<MemberSelection> listMemberSelections = new ArrayList<MemberSelection>();
            for (Map.Entry<String, List> entry : this.columnSelectedValues.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                listMemberSelections.add(this.createMemberSelection(allColumnDims, entry.getKey(), entry.getValue()));
            }
            if (listMemberSelections.size() > 0) {
                queryModel.memberSelections = new MemberSelection[listMemberSelections.size()];
                listMemberSelections.toArray(queryModel.memberSelections);
            }
        }
        return queryModel;
    }

    private MemberSelection createMemberSelection(HashMap<String, Dimension> allDims, String dim, List values) {
        Dimension dimension = allDims.get(dim);
        MemberSelection memberSelection = new MemberSelection(dimension);
        ArrayList orderedValues = new ArrayList();
        for (Object value : this.columnValuesMap.get(dim).getValues()) {
            if (!values.contains(value)) continue;
            orderedValues.add(value);
        }
        ArrayList values2 = new ArrayList();
        values2.addAll(values);
        values2.removeAll(orderedValues);
        orderedValues.addAll(values2);
        Iterator iter = orderedValues.iterator();
        while (iter.hasNext()) {
            memberSelection.addMember(iter.next());
        }
        return memberSelection;
    }

    private Measure createMeasure(Measure measure) {
        return measure.copy();
    }

    private Dimension createDimension(ColumnValues cv) {
        Dimension dim = new Dimension(cv.getColumnName());
        Iterator iter = cv.getValues().iterator();
        while (iter.hasNext()) {
            dim.createMember(iter.next());
        }
        return dim;
    }

    @Override
    public void setSelectedValues(String column, Object[] values) {
        ArrayList<Object> list = this.columnSelectedValues.get(column);
        if (list == null) {
            list = new ArrayList<Object>();
            this.columnSelectedValues.put(column, list);
        } else {
            list.clear();
        }
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                list.add(values[i]);
            }
        }
        this.modelChanged(true);
    }

    public void clearSelectedValues() {
        this.columnSelectedValues.clear();
    }

    @Override
    public DataModel2 getDataModel() {
        return this;
    }

    @Override
    public ColumnValues getColumnValues(String column) {
        return this.columnValuesMap.get(column);
    }

    @Override
    public Measure[] getMeasures() {
        Measure[] ms = new Measure[this.columnsOnMeasure.size()];
        this.measuresList.toArray(ms);
        return ms;
    }

    public Measure getMeasure(String column) {
        for (Measure m : this.measuresList) {
            if (!column.equals(m.name)) continue;
            return m;
        }
        return null;
    }

    public void modelChanged(boolean needBuildData) {
        if (this.disableListeners) {
            return;
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((DataModelListener)iter.next()).changed(needBuildData);
        }
        this.lastStateTime = System.currentTimeMillis();
    }

    public long getLastStateTime() {
        return this.lastStateTime;
    }

    public void disableListeners() {
        this.disableListeners = true;
    }

    public void enableListeners() {
        this.disableListeners = false;
    }

    @Override
    public void addListener(DataModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DataModelListener listener) {
        this.listeners.remove(listener);
    }

    public List getSelectedValues(String column) {
        return this.columnSelectedValues.get(column);
    }

    @Override
    public void setColumnsOnMeasure(String[] columns, int[] aggTypes) {
        this.columnsOnMeasure.clear();
        this.measuresList.clear();
        if (columns != null) {
            this.columnsOnMeasure.addAll(Arrays.asList(columns));
            for (int i = 0; i < columns.length; ++i) {
                this.addMeasure(this.createMeasure(columns[i], aggTypes[i]));
            }
        }
        this.modelChanged(true);
    }

    @Override
    public String[] getColumnsOnMeasure() {
        return this.columnsOnMeasure.toArray(new String[0]);
    }

    @Override
    public void setColumnsOnRows(String[] columns) {
        this.columnsOnRows.clear();
        if (columns != null) {
            this.columnsOnRows.addAll(Arrays.asList(columns));
        }
        this.modelChanged(true);
    }

    @Override
    public String[] getColumnsOnRows() {
        return this.columnsOnRows.toArray(new String[0]);
    }

    @Override
    public void setColumnsOnColumns(String[] columns) {
        this.columnsOnColumns.clear();
        if (columns != null) {
            this.columnsOnColumns.addAll(Arrays.asList(columns));
        }
        this.modelChanged(true);
    }

    @Override
    public String[] getColumnsOnColumns() {
        return this.columnsOnColumns.toArray(new String[0]);
    }

    public String[] getColumnsCanbeDimension() {
        return this.columnsCanbeDimension.toArray(new String[0]);
    }

    public String[] getColumnsCanbeMeasure() {
        return this.columnsCanbeMeasure.toArray(new String[0]);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void addMetric(Metric metric) {
        this.metricList.add(metric);
    }

    public void removeMetric(Metric metric) {
        this.metricList.remove(metric);
    }

    public void removeMetric(String name) {
        Iterator<Metric> iter = this.metricList.iterator();
        while (iter.hasNext()) {
            Metric metric = iter.next();
            if (!metric.getName().equals(name)) continue;
            iter.remove();
        }
    }

    public Metric getMetric(String name) {
        for (Metric m : this.metricList) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }
}

