/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.worksheet;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.streamwork.cuba.MdxResult;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.q.Result;
import com.kingdee.bos.streamwork.pivot.DetailListListener;
import com.kingdee.bos.streamwork.pivot.PivotUtils;
import com.kingdee.bos.streamwork.pivot.worksheet.Config;
import com.kingdee.bos.streamwork.pivot.worksheet.FileChooserUtil;
import com.kingdee.bos.streamwork.pivot.worksheet.MdxResultRenderer;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotCellRender;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotDataCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.ResultRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PivotWorksheetComponent {
    static Logger logger = Logger.getLogger(PivotWorksheetComponent.class);
    private KDTable table;
    private PivotCellRender cellRender;
    Config config;
    private boolean mergerBolocks;
    KDTMouseListener mouseListener = new KDTMouseListener(){

        public void tableClicked(KDTMouseEvent e) {
            int row = e.getRowIndex();
            int column = e.getColIndex();
            if (row >= 0 && column >= 0) {
                PivotWorksheetComponent.this.popRow = row;
                PivotWorksheetComponent.this.popColumn = column;
                if (SwingUtilities.isRightMouseButton((MouseEvent)e)) {
                    PivotWorksheetComponent.this.popup(PivotWorksheetComponent.this.table, row, column, e.getOriginView(), e.getX(), e.getY(), e.getType() == 0);
                } else if (e.getClickCount() == 2) {
                    PivotWorksheetComponent.this.showDetail(true);
                }
            }
        }
    };
    JPopupMenu popupMenu;
    private int popRow = -1;
    private int popColumn = -1;
    private DetailListListener detailListener;
    private FileChooserUtil chooser;

    public PivotWorksheetComponent(KDTable table, Config config) {
        this.config = config;
        if (table == null || config == null) {
            throw new NullPointerException();
        }
        this.cellRender = new PivotCellRender(config);
        this.table = table;
        table.getStyleAttributes().setLocked(true);
        this.initListener();
    }

    private void initListener() {
        this.table.addKDTMouseListener(this.mouseListener);
    }

    public boolean isMergerBolocks() {
        return this.mergerBolocks;
    }

    public void setMergerBolocks(boolean mergerBolocks) {
        this.mergerBolocks = mergerBolocks;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new AbstractAction("\u663e\u793a\u660e\u7ec6\u884c"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PivotWorksheetComponent.this.showDetail(true);
                }
            });
            this.popupMenu.add(new AbstractAction("\u5bfc\u51faExcel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PivotWorksheetComponent.this.export2Excel(PivotWorksheetComponent.this.isMergerBolocks());
                }
            });
        }
        return this.popupMenu;
    }

    protected void popup(KDTable table, int row, int column, Component originView, int x, int y, boolean b) {
        this.popRow = row;
        this.popColumn = column;
        this.getPopupMenu().show((Component)table, x + 30, y + 30);
    }

    public void setDetailListListener(DetailListListener detailListener) {
        this.detailListener = detailListener;
    }

    public boolean showDetail(boolean pop) {
        if (this.detailListener == null) {
            return false;
        }
        IRow row = null;
        int columnIndex = -1;
        if (pop) {
            row = this.table.getRow(this.popRow);
            columnIndex = this.popColumn;
        } else if (this.table.getSelectManager().get() != null) {
            int index = this.table.getSelectManager().get().getTop();
            columnIndex = this.table.getSelectManager().get().getLeft();
            row = this.table.getRow(index);
        }
        if (row == null) {
            return false;
        }
        Member[] context = null;
        PivotCellItem cellItem = this.getCellItem(row.getCell(columnIndex));
        if (cellItem != null && cellItem instanceof PivotDataCellItem) {
            PivotDataCellItem ditem = (PivotDataCellItem)cellItem;
            context = ditem.getMemberContext();
        }
        if (context == null) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int j = 0; j < context.length; ++j) {
            if (context[j].isCalculated() || context[j].isMeasure()) continue;
            map.put(context[j].getDimension().getName(), context[j].getKey());
        }
        this.detailListener.call(map);
        return true;
    }

    public void render(MdxResult result) {
        new MdxResultRenderer(result, this.table, this.config, this.cellRender).render();
    }

    public void render(Result result) {
        new ResultRenderer(result, this.table, this.config, this.cellRender).render();
    }

    public PivotCellItem getCellItem(ICell cell) {
        Object o = cell.getValue();
        if (o instanceof PivotCellItem) {
            return (PivotCellItem)o;
        }
        return null;
    }

    public JComponent getJComponent() {
        return this.table;
    }

    public KDTable getKDTable() {
        return this.table;
    }

    public void dispose() {
    }

    public void export2Excel(boolean isExportMergeBlocks) {
        if (this.chooser == null) {
            this.chooser = new FileChooserUtil(PivotUtils.getMainFrame());
        }
        ExportManager man = new ExportManager();
        man.setExporterParmeter(ExporterParameter.BOOK_LOCKED, (Object)Boolean.FALSE);
        man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
        man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
        man.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)String.valueOf(isExportMergeBlocks));
        File f = this.chooser.saveFile("\u5bfc\u51fa\u7ed3\u679c\u5230Excel", "xls", "Excel\u683c\u5f0f\u6587\u4ef6(xls)");
        if (f != null) {
            KDSBook book = null;
            book = new KDSBook("kdtable export");
            String fileName = f.getAbsolutePath();
            if (!fileName.toLowerCase().endsWith(".xls")) {
                fileName = fileName + ".xls";
            }
            try {
                book.addSheet(null, this.table.getIOManager().saveToKDSSheet(book, true, false, false, this.table.getName() == null ? "Sheet 1" : this.table.getName()));
                man.exportToExcel(book, fileName);
                int r = JOptionPane.showConfirmDialog(PivotUtils.getMainFrame(), fileName + "\n" + "\u4fdd\u5b58\u6210\u529f,\u73b0\u5728\u6253\u5f00\u5417?", "\u63d0\u793a", 0);
                if (r == 0 || r == 0) {
                    Runtime.getRuntime().exec("explorer " + fileName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(PivotUtils.getMainFrame(), "\u5bfc\u51fa\u5931\u8d25,\u6587\u4ef6\u6b63\u5728\u4f7f\u7528,\u8bf7\u5148\u5173\u95ed\u518d\u91cd\u8bd5.");
                return;
            }
        }
    }
}

