/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.pivot.worksheet;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.streamwork.cuba.Cell;
import com.kingdee.bos.streamwork.cuba.Hierarchy;
import com.kingdee.bos.streamwork.cuba.Member;
import com.kingdee.bos.streamwork.cuba.Position;
import com.kingdee.bos.streamwork.cuba.q.Edge;
import com.kingdee.bos.streamwork.cuba.q.Result;
import com.kingdee.bos.streamwork.pivot.worksheet.Config;
import com.kingdee.bos.streamwork.pivot.worksheet.MdxResultRenderer;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotCellRender;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotDataCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotHierarchyCellItem;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotMemberCellItem;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ResultRenderer {
    static Logger logger = Logger.getLogger(MdxResultRenderer.class);
    private Result result;
    private KDTable table;
    private Config config;
    private PivotCellRender cellRender;

    public ResultRenderer(Result result, KDTable table, Config config, PivotCellRender cellRender) {
        this.result = result;
        this.table = table;
        this.config = config;
        this.cellRender = cellRender;
    }

    public void render() {
        int i;
        if (this.table == null || this.result == null) {
            return;
        }
        this.table.removeColumns();
        this.table.getViewManager().unFreeze();
        this.table.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        Edge leftEdge = this.result.getEdge("rows");
        Edge topEdge = this.result.getEdge("columns");
        if (topEdge == null && leftEdge != null) {
            this.renderOneAxisOnRows(leftEdge);
        } else if (topEdge != null && leftEdge == null) {
            this.renderOneAxisOnColumn(topEdge);
        }
        int rowInset = 0;
        int columnInset = 0;
        long t1 = System.currentTimeMillis();
        Hierarchy[] topAxisHies = topEdge.getHierarchies();
        Hierarchy[] leftAxisHies = leftEdge.getHierarchies();
        int topAxisHieCount = topAxisHies.length;
        int leftAxisHieCount = leftAxisHies.length;
        int bodyRowCount = leftEdge.getPositionCount();
        int bodyColCount = topEdge.getPositionCount();
        int rowCount = (this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + topAxisHieCount + bodyRowCount;
        int colCount = leftAxisHieCount + (bodyColCount == 0 ? 1 : bodyColCount);
        if (this.config.showColumnHeaderInTableHeader) {
            if (this.config.showColumnDimensionHeader) {
                rowCount -= topAxisHieCount;
                for (int i2 = 0; i2 < topAxisHieCount; ++i2) {
                    this.table.addHeadRow();
                }
            }
            int j = topAxisHieCount;
            rowCount -= j;
            for (i = 0; i < j; ++i) {
                this.table.addHeadRow();
            }
            for (i = 0; i < colCount + columnInset; ++i) {
                this.table.addColumn().setKey("F" + i);
            }
        } else {
            IRow headRow = this.table.addHeadRow();
            for (i = 0; i < (colCount > 10 ? colCount : 10) + columnInset; ++i) {
                IColumn col = this.table.addColumn();
                col.setKey("F" + i);
                String h = "";
                int c = i;
                do {
                    int m = c % 26;
                    c = c / 26 - 1;
                    h = "" + new Character((char)(65 + m)) + h;
                } while (c >= 0);
                headRow.getCell(i).setValue((Object)h);
            }
        }
        for (int i3 = 0; i3 < rowCount; ++i3) {
            this.table.addRow();
        }
        int rowStart = rowInset;
        int colStart = columnInset;
        colStart += leftAxisHieCount;
        if (this.config.showColumnDimensionHeader) {
            this.renderTopHierarchy(topAxisHies, rowStart, colStart);
        }
        rowStart = rowInset;
        this.renderTopAxis(topEdge, rowStart += this.config.showColumnDimensionHeader ? topAxisHieCount : 0, colStart);
        rowStart = rowInset;
        int n = this.config.showColumnDimensionHeader ? topAxisHieCount : 0;
        colStart = columnInset;
        this.renderLeftHierarchy(leftEdge, leftAxisHies, rowStart += n + topAxisHieCount - 1, colStart);
        rowStart = !this.config.showColumnHeaderInTableHeader ? ++rowStart : rowInset;
        colStart = columnInset;
        long start = System.currentTimeMillis();
        this.renderLeftAxis(leftEdge, rowStart, colStart);
        System.out.println("renderLeftAxis cost " + (System.currentTimeMillis() - start) + "ms.");
        colStart = columnInset;
        start = System.currentTimeMillis();
        this.renderData(topEdge, leftEdge, this.result, rowStart, colStart += leftAxisHieCount);
        System.out.println("renderData cost " + (System.currentTimeMillis() - start) + "ms.");
        this.table.reLayoutAndPaint();
        int top = 0;
        int left = 0;
        int bottom = (this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + topAxisHieCount - 2;
        int right = leftAxisHieCount - 1;
        if (bottom > top || right > left) {
            this.getMergeManager(this.table, this.config.showColumnHeaderInTableHeader).mergeBlock(top + rowInset, left + columnInset, bottom + rowInset, right + columnInset);
        }
        if (this.config.showColumnDimensionHeader) {
            top = 0;
            left = leftAxisHieCount + 1;
            bottom = topAxisHieCount - 1;
            right = this.table.getColumnCount() - 1;
            if (bottom > top || right > left) {
                this.getMergeManager(this.table, this.config.showColumnHeaderInTableHeader).mergeBlock(top, left, bottom, right);
            }
        }
        if (this.config.autoColumnWidth) {
            int c = leftAxisHieCount;
            for (int i4 = 0; i4 < this.table.getColumnCount(); ++i4) {
                if (i4 < c) {
                    this.table.getColumns().autoFitColumnWidth(i4, 20);
                    continue;
                }
                this.table.getColumns().autoFitColumnWidth(i4, 40);
            }
        }
        if (this.config.autoFreeze) {
            if (!this.config.showColumnHeaderInTableHeader) {
                this.table.getViewManager().setFreezeView((this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + topAxisHieCount, leftAxisHieCount);
            } else {
                this.table.getViewManager().setFreezeView(-1, leftAxisHieCount);
            }
        }
        this.table.reLayoutAndPaint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WorksheetComponent render cost " + (System.currentTimeMillis() - t1) + "ms."));
        }
    }

    private void renderOneAxisOnColumn(Edge topEdge) {
        int i;
        int i2;
        long t1 = System.currentTimeMillis();
        Hierarchy[] topAxisHies = topEdge.getHierarchies();
        int topAxisHieCount = topAxisHies.length;
        int bodyRowCount = 1;
        int bodyColCount = topEdge.getPositionCount();
        int rowCount = (this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + topAxisHieCount + bodyRowCount;
        int colCount = 1 + (bodyColCount == 0 ? 1 : bodyColCount);
        if (this.config.showColumnHeaderInTableHeader) {
            if (this.config.showColumnDimensionHeader) {
                rowCount -= topAxisHieCount;
                for (int i3 = 0; i3 < topAxisHieCount; ++i3) {
                    this.table.addHeadRow();
                }
            }
            int j = topAxisHieCount;
            rowCount -= j;
            for (i2 = 0; i2 < j; ++i2) {
                this.table.addHeadRow();
            }
            for (i2 = 0; i2 < colCount; ++i2) {
                this.table.addColumn().setKey("F" + i2);
            }
        } else {
            IRow headRow = this.table.addHeadRow();
            for (i2 = 0; i2 < (colCount > 10 ? colCount : 10); ++i2) {
                IColumn col = this.table.addColumn();
                col.setKey("F" + i2);
                String h = "";
                int c = i2;
                do {
                    int m = c % 26;
                    c = c / 26 - 1;
                    h = "" + new Character((char)(65 + m)) + h;
                } while (c >= 0);
                headRow.getCell(i2).setValue((Object)h);
            }
        }
        for (i = 0; i < rowCount; ++i) {
            this.table.addRow();
        }
        for (i = rowCount; i < 25; ++i) {
            this.table.addRow();
        }
        int rowInset = 0;
        int columnInset = 0;
        int rowStart = rowInset;
        int colStart = columnInset;
        ++colStart;
        if (this.config.showColumnDimensionHeader) {
            this.renderTopHierarchy(topAxisHies, rowStart, colStart);
        }
        rowStart = rowInset;
        this.renderTopAxis(topEdge, rowStart += this.config.showColumnDimensionHeader ? topAxisHieCount : 0, colStart);
        rowStart = rowInset;
        rowStart += (this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + topAxisHieCount - 1;
        rowStart = !this.config.showColumnHeaderInTableHeader ? ++rowStart : rowInset;
        colStart = columnInset;
        ICell cell = this.table.getCell(rowStart, colStart);
        cell.setValue((Object)"\u5408\u8ba1");
        colStart = columnInset;
        this.renderData(topEdge, null, this.result, rowStart, ++colStart);
        this.table.reLayoutAndPaint();
        int top = 0;
        int left = 0;
        int bottom = (this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + topAxisHieCount - 2;
        int right = 0;
        if (bottom > top || right > left) {
            this.getMergeManager(this.table, this.config.showColumnHeaderInTableHeader).mergeBlock(top + rowInset, left + columnInset, bottom + rowInset, right + columnInset);
        }
        if (this.config.showColumnDimensionHeader) {
            top = 0;
            left = 2;
            bottom = topAxisHieCount - 1;
            right = this.table.getColumnCount() - 1;
            if (bottom > top || right > left) {
                this.getMergeManager(this.table, this.config.showColumnHeaderInTableHeader).mergeBlock(top, left, bottom, right);
            }
        }
        if (this.config.autoColumnWidth) {
            int c = 1;
            for (int i4 = 0; i4 < this.table.getColumnCount(); ++i4) {
                if (i4 < c) {
                    int depth = 0;
                    this.table.getColumns().autoFitColumnWidth(i4, 20 + 10 * depth);
                    continue;
                }
                this.table.getColumns().autoFitColumnWidth(i4, 40);
            }
        }
        if (this.config.autoFreeze) {
            if (!this.config.showColumnHeaderInTableHeader) {
                this.table.getViewManager().setFreezeView((this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + topAxisHieCount, 1);
            } else {
                this.table.getViewManager().setFreezeView(-1, 1);
            }
        }
        this.table.reLayoutAndPaint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WorksheetComponent render cost " + (System.currentTimeMillis() - t1) + "ms."));
        }
    }

    private void renderOneAxisOnRows(Edge leftEdge) {
        int c;
        int i;
        int bodyRowCount;
        long t1 = System.currentTimeMillis();
        Hierarchy[] leftAxisHies = leftEdge.getHierarchies();
        int leftAxisHieCount = leftAxisHies.length;
        int rowCount = bodyRowCount = leftEdge.getPositionCount();
        int colCount = leftAxisHieCount;
        if (this.config.showColumnHeaderInTableHeader) {
            this.table.addHeadRow();
            for (i = 0; i < colCount; ++i) {
                this.table.addColumn().setKey("F" + i);
            }
        } else {
            IRow headRow = this.table.addHeadRow();
            for (int i2 = 0; i2 < (colCount > 10 ? colCount : 10); ++i2) {
                IColumn col = this.table.addColumn();
                col.setKey("F" + i2);
                String h = "";
                c = i2;
                do {
                    int m = c % 26;
                    c = c / 26 - 1;
                    h = "" + new Character((char)(65 + m)) + h;
                } while (c >= 0);
                headRow.getCell(i2).setValue((Object)h);
            }
        }
        for (i = 0; i < rowCount; ++i) {
            this.table.addRow();
        }
        for (i = rowCount; i < 25; ++i) {
            this.table.addRow();
        }
        int rowInset = 0;
        int columnInset = 0;
        int rowStart = rowInset;
        int colStart = columnInset;
        colStart += leftAxisHieCount;
        rowStart = rowInset;
        colStart = columnInset;
        this.renderLeftHierarchy(leftEdge, leftAxisHies, rowStart, colStart);
        rowStart = !this.config.showColumnHeaderInTableHeader ? ++rowStart : rowInset;
        colStart = columnInset;
        this.renderLeftAxis(leftEdge, rowStart, colStart);
        this.table.reLayoutAndPaint();
        if (this.config.autoColumnWidth) {
            c = leftAxisHieCount;
            for (int i3 = 0; i3 < this.table.getColumnCount(); ++i3) {
                if (i3 < c) {
                    this.table.getColumns().autoFitColumnWidth(i3, 20);
                    continue;
                }
                this.table.getColumns().autoFitColumnWidth(i3, 40);
            }
        }
        this.table.reLayoutAndPaint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WorksheetComponent render cost " + (System.currentTimeMillis() - t1) + "ms."));
        }
    }

    private KDTMergeManager getMergeManager(KDTable table, boolean header) {
        if (header) {
            return table.getHeadMergeManager();
        }
        return table.getMergeManager();
    }

    private void renderTopHierarchy(Hierarchy[] hies, int rowStart, int colStart) {
        for (int i = 0; i < hies.length; ++i) {
            this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, i + rowStart, colStart, new PivotHierarchyCellItem(hies[i], 0));
        }
    }

    private IRow getRow(KDTable table, boolean header, int rowIndex) {
        if (header) {
            return table.getHeadRow(rowIndex);
        }
        return table.getRow(rowIndex);
    }

    private void renderTopAxis(Edge edge, int rowStart, int colStart) {
        if (edge.getPositionCount() == 0) {
            return;
        }
        int hieCount = edge.getHierarchies().length;
        int[] span = new int[hieCount];
        for (int i = 0; i < hieCount; ++i) {
            span[i] = 0;
        }
        ICell[] lastCell = new ICell[hieCount];
        int[] lastCellIndice = new int[hieCount];
        PivotMemberCellItem[] lastCellItem = new PivotMemberCellItem[hieCount];
        int i = 0;
        Iterator<Position> iter = edge.getPositionIterator();
        while (iter.hasNext()) {
            Position position = iter.next();
            this.table.getColumn(i + colStart).setUserObject((Object)position);
            Member[] ms = position.getMembers();
            for (int j = 0; j < ms.length; ++j) {
                PivotMemberCellItem cellItem;
                ICell cell = this.getRow(this.table, this.config.showColumnHeaderInTableHeader, j + rowStart).getCell(i + colStart);
                if (lastCellItem[j] != null) {
                    boolean b = false;
                    for (int k = j; k >= 0; --k) {
                        int index = lastCellIndice[j];
                        PivotMemberCellItem cellItem2 = null;
                        while (cellItem2 == null) {
                            ICell ancestorOfLastCell = this.getRow(this.table, this.config.showColumnHeaderInTableHeader, k + rowStart).getCell(index-- + colStart);
                            cellItem2 = (PivotMemberCellItem)ancestorOfLastCell.getValue();
                        }
                        if (ms[k].equals(cellItem2.getMember())) continue;
                        b = true;
                        break;
                    }
                    if (!b && this.config.autoMergeColumnHead) {
                        ++lastCellItem[j].colSpan;
                        continue;
                    }
                    int row = lastCell[j].getRowIndex();
                    int col = lastCell[j].getColumnIndex();
                    int colSpan = lastCellItem[j].colSpan;
                    if (colSpan > 0) {
                        this.merge(this.config.showColumnHeaderInTableHeader, row, col, row, col + colSpan);
                    }
                }
                lastCell[j] = cell;
                lastCellIndice[j] = i;
                lastCellItem[j] = cellItem = new PivotMemberCellItem(position, ms[j], 0);
                this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, j + rowStart, i + colStart, cellItem);
            }
            ++i;
        }
        for (int j = 0; j < hieCount; ++j) {
            int row = lastCell[j].getRowIndex();
            int col = lastCell[j].getColumnIndex();
            int colSpan = lastCellItem[j].colSpan;
            if (colSpan <= 0) continue;
            this.merge(this.config.showColumnHeaderInTableHeader, row, col, row, col + colSpan);
        }
    }

    private void renderLeftHierarchy(Edge edge, Hierarchy[] hies, int rowStart, int colStart) {
        if (!this.config.showRowDimensionHeader) {
            return;
        }
        int index = 0;
        for (int i = 0; i < hies.length; ++i) {
            if (i > 0) {
                ++index;
            }
            this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, rowStart, colStart + index, new PivotHierarchyCellItem(hies[i], 1));
        }
    }

    private void renderLeftAxis(Edge edge, int rowStart, int colStart) {
        if (edge.getPositionCount() == 0) {
            return;
        }
        int hieCount = edge.getHierarchies().length;
        int[] span = new int[hieCount];
        for (int i = 0; i < hieCount; ++i) {
            span[i] = 0;
        }
        ICell[] lastCell = new ICell[hieCount];
        int[] lastCellIndice = new int[hieCount];
        PivotMemberCellItem[] lastCellItem = new PivotMemberCellItem[hieCount];
        for (int j = 0; j < hieCount; ++j) {
            IColumn col = this.table.getColumn(j + colStart);
            col.setWidth((int)((double)col.getWidth() * 1.5));
        }
        int i = 0;
        Iterator<Position> iter = edge.getPositionIterator();
        while (iter.hasNext()) {
            int j;
            Position position = iter.next();
            Member[] ms = position.getMembers();
            int propIndent = 0;
            int[] lastPropIndent = new int[ms.length];
            for (j = 0; j < ms.length; ++j) {
                lastPropIndent[j] = 0;
            }
            this.table.getRow(i + rowStart).setUserObject((Object)position);
            for (j = 0; j < ms.length; ++j) {
                PivotMemberCellItem cellItem;
                ICell cell = this.table.getCell(i + rowStart, j + colStart + propIndent);
                if (lastCellItem[j] != null) {
                    boolean b = false;
                    for (int k = j; k >= 0; --k) {
                        int index = lastCellIndice[k];
                        if (index == i) {
                            b = true;
                            break;
                        }
                        PivotCellItem cellItem2 = null;
                        while (cellItem2 == null) {
                            ICell ancestorOfLastCell = this.table.getCell(index-- + rowStart, k + colStart + (k > 0 ? lastPropIndent[k - 1] : 0));
                            cellItem2 = (PivotCellItem)ancestorOfLastCell.getValue();
                        }
                        if (cellItem2 instanceof PivotMemberCellItem && ms[k].equals(((PivotMemberCellItem)cellItem2).getMember())) continue;
                        b = true;
                        break;
                    }
                    if (!b && this.config.autoMergeRowHead) {
                        ++lastCellItem[j].rowSpan;
                        continue;
                    }
                    int row = lastCell[j].getRowIndex();
                    int col = lastCell[j].getColumnIndex();
                    int rowSpan = lastCellItem[j].rowSpan;
                    if (rowSpan > 0) {
                        this.table.getMergeManager().mergeBlock(row, col, row + rowSpan, col);
                    }
                }
                lastCell[j] = cell;
                lastCellIndice[j] = i;
                lastCellItem[j] = cellItem = new PivotMemberCellItem(position, ms[j], 1, false);
                this.fillCellItem(this.table, i + rowStart, j + colStart + propIndent, cellItem);
            }
            ++i;
        }
        for (int j = 0; j < hieCount; ++j) {
            int row = lastCell[j].getRowIndex();
            int col = lastCell[j].getColumnIndex();
            int rowSpan = lastCellItem[j].rowSpan;
            if (rowSpan <= 0) continue;
            this.table.getMergeManager().mergeBlock(row, col, row + rowSpan, col);
        }
    }

    private void renderData(Edge topEdge, Edge leftEdge, Result result, int rowStart, int colStart) {
        block4: {
            int topAxisCount;
            int leftAxisCount;
            block3: {
                leftAxisCount = -1;
                topAxisCount = topEdge.getPositionCount();
                if (leftEdge != null) break block3;
                for (int i = 0; i < topAxisCount; ++i) {
                    Cell cell = result.getCell(-1, i);
                    if (cell == null) continue;
                    this.fillCellItem(this.table, rowStart, i + colStart, new PivotDataCellItem(cell));
                }
                break block4;
            }
            if (leftEdge == null || topEdge == null) break block4;
            leftAxisCount = leftEdge.getPositionCount();
            for (int i = 0; i < leftAxisCount; ++i) {
                for (int j = 0; j < topAxisCount; ++j) {
                    Cell cell = result.getCell(i, j);
                    if (cell == null) continue;
                    this.fillCellItem(this.table, i + rowStart, j + colStart, new PivotDataCellItem(cell));
                }
            }
        }
    }

    void split(boolean header, int rowbegin, int colbegin, int rowend, int colend) {
        if (header) {
            this.table.getHeadMergeManager().splitBlock(rowbegin, colbegin, rowend, colend);
        } else {
            this.table.getMergeManager().splitBlock(rowbegin, colbegin, rowend, colend);
        }
    }

    void split(int rowbegin, int colbegin, int rowend, int colend) {
        this.split(false, rowbegin, colbegin, rowend, colend);
    }

    void merge(boolean header, int rowbegin, int colbegin, int rowend, int colend) {
        if (header) {
            this.table.getHeadMergeManager().mergeBlock(rowbegin, colbegin, rowend, colend);
        } else {
            this.table.getMergeManager().mergeBlock(rowbegin, colbegin, rowend, colend);
        }
    }

    void merge(int rowbegin, int colbegin, int rowend, int colend) {
        this.merge(false, rowbegin, colbegin, rowend, colend);
    }

    void fillCellItem(ICell cell, PivotCellItem cellItem) {
        cell.setValue((Object)cellItem);
        cell.setRenderer((IBasicRender)this.cellRender);
        if (cellItem.getHorizontalAlignment() != null) {
            cell.getStyleAttributes().setHorizontalAlign(cellItem.getHorizontalAlignment());
        }
        if (cellItem.getForeColor() != null) {
            cell.getStyleAttributes().setFontColor(cellItem.getForeColor());
        }
        if (cellItem.getBgColor() != null) {
            cell.getStyleAttributes().setBackground(cellItem.getBgColor());
        }
    }

    void fillCellItem(KDTable table, boolean header, int row, int column, PivotCellItem cellItem) {
        ICell cell = this.getRow(table, header, row).getCell(column);
        this.fillCellItem(cell, cellItem);
    }

    void fillCellItem(KDTable table, int row, int column, PivotCellItem cellItem) {
        this.fillCellItem(table, false, row, column, cellItem);
    }
}

