/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.test;

import com.kingdee.bos.streamwork.columnbased.CBTable;
import com.kingdee.bos.streamwork.columnbased.TableBuilder;
import com.kingdee.bos.streamwork.pivot.PivotException;
import com.kingdee.bos.streamwork.test.TestDBUtil;
import com.sun.rowset.CachedRowSetImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.RowSet;

public class TestCBTable {
    public static void main(String[] args) throws Exception {
        String sql = "select * from t_gl_voucherentry where rownum<=1000";
        CBTable table = TestCBTable.createCBTable(sql);
        RowSet rowset = TestCBTable.createRowSet(sql);
        System.out.println("rowcount:" + table.getRowCount());
        TestCBTable.writeToFile("table1000", table);
        TestCBTable.writeToFile("rowset1000", rowset);
        TestCBTable.compare(table, rowset);
        sql = "select * from t_gl_voucherentry where rownum<=5000";
        table = TestCBTable.createCBTable(sql);
        rowset = TestCBTable.createRowSet(sql);
        System.out.println("rowcount:" + table.getRowCount());
        TestCBTable.writeToFile("table5000", table);
        TestCBTable.writeToFile("rowset5000", rowset);
        TestCBTable.compare(table, rowset);
        sql = "select * from t_gl_voucherentry where rownum<=10000";
        table = TestCBTable.createCBTable(sql);
        rowset = TestCBTable.createRowSet(sql);
        System.out.println("rowcount:" + table.getRowCount());
        TestCBTable.writeToFile("table10000", table);
        TestCBTable.writeToFile("rowset10000", rowset);
        TestCBTable.compare(table, rowset);
        sql = "select * from t_gl_voucherentry where rownum<=50000";
        table = TestCBTable.createCBTable(sql);
        rowset = TestCBTable.createRowSet(sql);
        System.out.println("rowcount:" + table.getRowCount());
        TestCBTable.writeToFile("table50000", table);
        TestCBTable.writeToFile("rowset50000", rowset);
        TestCBTable.compare(table, rowset);
    }

    private static void compare(CBTable table, RowSet rowset) throws SQLException {
        int columnCount = table.getColumnCount();
        for (int i = 0; i < table.getRowCount(); ++i) {
            rowset.next();
            for (int j = 0; j < columnCount; ++j) {
                Object v1 = table.getCell(j, i);
                Object v2 = rowset.getObject(j + 1);
                boolean equals = true;
                if (v1 == null) {
                    if (v2 != null) {
                        equals = false;
                    }
                } else {
                    equals = v1.equals(v2);
                }
                if (equals) continue;
                System.out.println("Not equals at column:" + j + ",row:" + i);
                System.out.println("v1:" + v1.toString());
                System.out.println("v2:" + v2.toString());
            }
        }
        System.out.println("equals true.");
    }

    private static void writeToFile(String filename, Object obj) throws IOException {
        File file = new File(filename);
        FileOutputStream fos = new FileOutputStream(filename);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        fos.close();
        long length = file.length();
        System.out.println("Write to File " + file.getAbsolutePath() + ", length:" + length);
    }

    private static CBTable createCBTable(String sql) {
        Connection cn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            CBTable cbTable;
            cn = TestDBUtil.getConnection_oracle();
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            CBTable cBTable = cbTable = TableBuilder.buildResultSet(rs);
            return cBTable;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PivotException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (cn != null) {
                    cn.close();
                }
            }
            catch (Throwable e) {}
        }
    }

    private static RowSet createRowSet(String sql) {
        Connection cn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            cn = TestDBUtil.getConnection_oracle();
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            CachedRowSetImpl rowSet = new CachedRowSetImpl();
            rowSet.populate(rs);
            CachedRowSetImpl cachedRowSetImpl = rowSet;
            return cachedRowSetImpl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new PivotException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (cn != null) {
                    cn.close();
                }
            }
            catch (Throwable e) {}
        }
    }
}

