/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.test;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.streamwork.cuba.CUBAConfig;
import com.kingdee.bos.streamwork.cuba.CUBADriver;
import com.kingdee.bos.streamwork.cuba.q.Result;
import com.kingdee.bos.streamwork.pivot.worksheet.Config;
import com.kingdee.bos.streamwork.pivot.worksheet.PivotWorksheetComponent;
import com.kingdee.bos.streamwork.test.TestDBUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.sql.Connection;
import java.util.HashMap;
import javax.swing.UIManager;

public class TestResult
extends KDFrame {
    KDTable table;
    PivotWorksheetComponent worksheet;

    public TestResult() throws Exception {
        this.initUI();
        this.build();
    }

    private void initUI() {
        this.setTitle("\u9884\u7b97\u8868");
        this.setPreferredSize(new Dimension(1024, 768));
        this.setSize(new Dimension(1024, 768));
        this.setExtendedState(6);
        this.setLayout(new BorderLayout());
        this.table = new KDTable();
        this.add((Component)this.table, "Center");
        Config cc = Config.getConfig();
        cc.showColumnDimensionHeader = false;
        cc.showColumnHeaderInTableHeader = true;
        cc.autoColumnWidth = true;
        cc.autoFreeze = false;
        this.worksheet = new PivotWorksheetComponent(this.table, cc);
    }

    private void build() throws Exception {
        String xmlfilename = "d:/cubes/sales.xml";
        String mdxfilename = "d:/cubes/salesmdx.txt";
        FileReader reader = new FileReader(mdxfilename);
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        String mdx = sb.toString();
        long begin = System.currentTimeMillis();
        CUBAConfig config = new CUBAConfig();
        config.supportSelfData = true;
        config.BUILD_AUTOJOINFACTSQL = false;
        FileInputStream in = new FileInputStream(xmlfilename);
        HashMap<String, Connection> map = new HashMap<String, Connection>();
        map.put("JdbcConnection", TestDBUtil.getConnection_oracle());
        com.kingdee.bos.streamwork.cuba.Connection con = CUBADriver.openConnection(in, map, config);
        Result result = con.executeQuery(mdx);
        System.out.println("all cost " + (System.currentTimeMillis() - begin) + " ms.");
        this.worksheet.render(result);
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestResult test = new TestResult();
        test.setVisible(true);
        test.setDefaultCloseOperation(3);
    }
}

