/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.streamwork.xls;

import com.kingdee.bos.streamwork.xls.IXlsReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class POIReader
implements IXlsReader {
    private InputStream stream = null;
    private Record[] records = null;
    protected Workbook workbook = null;
    private Sheet input;
    private int cRow;
    private String[] columnNames;
    private Row columns;
    private Row buf = null;
    private char separator = (char)44;
    private boolean suppressHeaders = false;
    private String stringDateFormat = null;
    private String fileName = null;
    private static SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");

    public POIReader() {
    }

    public POIReader(String fileName) throws Exception {
        this(fileName, ',', false, null);
    }

    public POIReader(String fileName, char separator, boolean suppressHeaders, String stringDateFormat) throws Exception {
        this.setSeparator(separator);
        this.setSuppressHeaders(suppressHeaders);
        this.setStringDateFormat(stringDateFormat);
        this.setFileName(fileName);
        this.openFile();
    }

    @Override
    public void openFile() throws Exception {
        FileInputStream inp = new FileInputStream(this.fileName);
        this.workbook = WorkbookFactory.create((InputStream)inp);
        int sCount = this.workbook.getNumberOfSheets();
        this.input = this.workbook.getSheetAt(0);
        this.cRow = 0;
        if (this.isSuppressHeaders()) {
            Row data = this.input.getRow(this.cRow++);
            this.columnNames = new String[data.getLastCellNum()];
            for (int i = 0; i < data.getLastCellNum(); ++i) {
                this.columnNames[i] = "\u5217" + String.valueOf(i + 1);
            }
            data = null;
        } else {
            Row data = this.input.getRow(this.cRow++);
            this.columnNames = new String[data.getLastCellNum()];
            for (short i = 0; i < data.getLastCellNum(); i = (short)(i + 1)) {
                String headerName;
                Cell cell = data.getCell((int)i);
                this.columnNames[i] = cell == null ? "\u5217" + String.valueOf(i + 1) : ((headerName = data.getCell((int)i).getStringCellValue()) == null || headerName.trim().length() == 0 ? "\u5217" + String.valueOf(i + 1) : data.getCell((int)i).getStringCellValue().toUpperCase());
            }
        }
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String getColumn(int columnIndex) {
        Cell thisCell = this.columns.getCell(columnIndex - 1);
        if (thisCell.getCellType() == 1) {
            return thisCell.getStringCellValue();
        }
        if (thisCell.getCellType() == 0) {
            double cValue = thisCell.getNumericCellValue();
            CellStyle cStyle = thisCell.getCellStyle();
            short cFormatIndex = cStyle.getDataFormat();
            DataFormat thisFormat = this.workbook.createDataFormat();
            String retVal = Double.toString(cValue);
            if (retVal.substring(retVal.length() - 2).equals(".0")) {
                retVal = retVal.substring(0, retVal.length() - 2);
            }
            return retVal;
        }
        return thisCell.getStringCellValue();
    }

    @Override
    public Object getObject(int columnIndex) {
        String columnName = this.columnNames[columnIndex - 1].toLowerCase();
        Cell thisCell = this.columns.getCell(columnIndex - 1);
        switch (thisCell.getCellType()) {
            case 3: {
                return null;
            }
            case 1: {
                return thisCell.getStringCellValue();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)thisCell)) {
                    try {
                        return this.getColumnDate(columnIndex);
                    }
                    catch (Exception e) {
                        return thisCell.getNumericCellValue();
                    }
                }
                return thisCell.getNumericCellValue();
            }
            case 4: {
                return Boolean.parseBoolean(thisCell.getStringCellValue());
            }
        }
        return null;
    }

    @Override
    public Date getColumnDate(int columnIndex) throws ParseException {
        Date retVal;
        block7: {
            Cell cellData = this.columns.getCell(columnIndex - 1);
            retVal = null;
            try {
                retVal = cellData.getDateCellValue();
            }
            catch (NumberFormatException e) {
                String sData = cellData.getStringCellValue();
                if (sData == null || sData.trim().length() <= 0) break block7;
                if (this.getStringDateFormat() == null) {
                    try {
                        return dateFormat1.parse(sData);
                    }
                    catch (Throwable t) {
                        try {
                            return dateFormat2.parse(sData);
                        }
                        catch (Throwable t2) {
                            break block7;
                        }
                    }
                }
                SimpleDateFormat sdFormat = new SimpleDateFormat(this.getStringDateFormat());
                retVal = sdFormat.parse(sData);
            }
        }
        return retVal;
    }

    @Override
    public boolean getColumnBoolean(int columnIndex) {
        return this.columns.getCell(columnIndex - 1).getBooleanCellValue();
    }

    @Override
    public double getColumnDouble(int columnIndex) {
        return this.columns.getCell(columnIndex - 1).getNumericCellValue();
    }

    @Override
    public int getColumnInt(int columnIndex) {
        return (int)this.columns.getCell(columnIndex - 1).getNumericCellValue();
    }

    @Override
    public long getColumnLong(int columnIndex) {
        return (long)this.columns.getCell(columnIndex - 1).getNumericCellValue();
    }

    @Override
    public short getColumnShort(int columnIndex) {
        return (short)this.columns.getCell(columnIndex - 1).getNumericCellValue();
    }

    @Override
    public String getColumn(String columnName) throws Exception {
        columnName = columnName.toUpperCase();
        for (int loop = 0; loop < this.columnNames.length; ++loop) {
            if (!columnName.equals(this.columnNames[loop])) continue;
            return this.getColumn(loop);
        }
        throw new Exception("Column '" + columnName + "' not found.");
    }

    @Override
    public Date getColumnDate(String columnName) throws Exception {
        columnName = columnName.toUpperCase();
        for (int loop = 0; loop < this.columnNames.length; ++loop) {
            if (!columnName.equals(this.columnNames[loop])) continue;
            return this.getColumnDate(loop);
        }
        throw new Exception("Column '" + columnName + "' not found.");
    }

    public boolean getColumnBoolean(String columnName) throws Exception {
        columnName = columnName.toUpperCase();
        for (int loop = 0; loop < this.columnNames.length; ++loop) {
            if (!columnName.equals(this.columnNames[loop])) continue;
            return this.getColumnBoolean(loop);
        }
        throw new Exception("Column '" + columnName + "' not found.");
    }

    @Override
    public double getColumnDouble(String columnName) throws Exception {
        columnName = columnName.toUpperCase();
        for (int loop = 0; loop < this.columnNames.length; ++loop) {
            if (!columnName.equals(this.columnNames[loop])) continue;
            return this.getColumnDouble(loop);
        }
        throw new Exception("Column '" + columnName + "' not found.");
    }

    @Override
    public int getColumnInt(String columnName) throws Exception {
        columnName = columnName.toUpperCase();
        for (int loop = 0; loop < this.columnNames.length; ++loop) {
            if (!columnName.equals(this.columnNames[loop])) continue;
            return this.getColumnInt(loop);
        }
        throw new Exception("Column '" + columnName + "' not found.");
    }

    @Override
    public short getColumnShort(String columnName) throws Exception {
        columnName = columnName.toUpperCase();
        for (int loop = 0; loop < this.columnNames.length; ++loop) {
            if (!columnName.equals(this.columnNames[loop])) continue;
            return this.getColumnShort(loop);
        }
        throw new Exception("Column '" + columnName + "' not found.");
    }

    @Override
    public long getColumnLong(String columnName) throws Exception {
        columnName = columnName.toUpperCase();
        for (int loop = 0; loop < this.columnNames.length; ++loop) {
            if (!columnName.equals(this.columnNames[loop])) continue;
            return this.getColumnLong(loop);
        }
        throw new Exception("Column '" + columnName + "' not found.");
    }

    @Override
    public boolean next() throws Exception {
        Object dataLine;
        if (this.isSuppressHeaders() && this.buf != null) {
            dataLine = this.buf;
            this.buf = null;
        } else {
            int nRows = this.input.getLastRowNum();
            if (nRows == 0) {
                nRows = this.input.getPhysicalNumberOfRows();
            }
            dataLine = this.cRow > nRows ? null : this.input.getRow(this.cRow++);
        }
        if (dataLine == null) {
            this.input = null;
            return false;
        }
        this.columns = dataLine;
        return true;
    }

    @Override
    public void close() {
        try {
            this.input = null;
            this.buf = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public void setSeparator(char separator) {
        this.separator = separator;
    }

    @Override
    public boolean isSuppressHeaders() {
        return this.suppressHeaders;
    }

    @Override
    public void setSuppressHeaders(boolean suppressHeaders) {
        this.suppressHeaders = suppressHeaders;
    }

    @Override
    public String getStringDateFormat() {
        return this.stringDateFormat;
    }

    @Override
    public void setStringDateFormat(String stringDateFormat) {
        this.stringDateFormat = stringDateFormat;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

