/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction;

import com.kingdee.bos.transaction.AttributeConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BosAttributeConfig
implements AttributeConfig {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.transaction.BosAttributeConfig");
    private static final Properties DEFAULT_ATTRIBUTE = new Properties();
    private static Map attCache;
    private static Map indexs;

    public BosAttributeConfig(String earPath) {
        this.init(earPath);
    }

    protected void init(String earPath) {
        if (attCache == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Init Transaction Define from EAR");
            }
            attCache = new HashMap();
            try {
                File earFile = new File(earPath);
                if (!earFile.exists()) {
                    logger.error((Object)("EAR Config Location[" + earFile + "] not found."));
                    throw new IOException("EAR Config file[" + earFile + "] not exists!");
                }
                JarFile jarEar = null;
                InputStream applicationIs = null;
                if (earFile.isDirectory()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"EAR Loaction is A Directory.");
                    }
                    applicationIs = new FileInputStream(new File(earFile, "META-INF/application.xml"));
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"EAR Location is A jar File.");
                    }
                    jarEar = new JarFile(earFile, true, 1);
                    JarEntry appEntry = jarEar.getJarEntry("META-INF/application.xml");
                    applicationIs = jarEar.getInputStream(appEntry);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"InputStream for application.xml is ready.");
                }
                List ejbs = this.getEjbModulesFromEar(applicationIs);
                applicationIs.close();
                String ejbName2 = null;
                for (String ejbName2 : ejbs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Loop Process EJBModule " + ejbName2));
                    }
                    InputStream ejbIs = null;
                    if (earFile.isDirectory()) {
                        File ejbFile = new File(earFile, ejbName2);
                        if (!ejbFile.exists()) {
                            throw new NullPointerException("Ejb module[" + ejbFile + "] not exist!");
                        }
                        if (ejbFile.isDirectory()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("EAR is Dir, and EJB[" + ejbName2 + "] is a Dir too."));
                            }
                            ejbIs = new FileInputStream(new File(ejbFile, "META-INF/ejb-jar.xml"));
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("EAR is Dir, and EJB[" + ejbName2 + "] is a Jar."));
                            }
                            JarFile jarEjb = new JarFile(ejbFile, true, 1);
                            JarEntry entryEjb = jarEjb.getJarEntry("META-INF/ejb-jar.xml");
                            ejbIs = jarEjb.getInputStream(entryEjb);
                        }
                    } else {
                        JarEntry entryModule = jarEar.getJarEntry(ejbName2);
                        if (entryModule.getSize() <= 0L) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("EAR is A Jar, and EJB[" + ejbName2 + "] is a Dir."));
                            }
                            JarEntry entryEjb = jarEar.getJarEntry(ejbName2 + "/META-INF/ejb-jar.xml");
                            ejbIs = jarEar.getInputStream(entryEjb);
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("EAR is A Dir, and EJB[" + ejbName2 + "] is a Jar too."));
                            }
                            InputStream moduleIs = jarEar.getInputStream(entryModule);
                            JarInputStream jis = new JarInputStream(moduleIs);
                            JarEntry entryEjb = null;
                            while ((entryEjb = jis.getNextJarEntry()) != null) {
                                if (!"META-INF/ejb-jar.xml".equals(entryEjb.getName())) continue;
                                byte[] bs = entryEjb.getExtra();
                                ejbIs = new ByteArrayInputStream(bs);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Find ejb-jar.xml in JarEntry Stream.");
                                }
                                jis.close();
                                break;
                            }
                            jis.close();
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"InputStream for ejb-jar.xml is ready.");
                    }
                    this.processEjbModule(ejbIs);
                    if (ejbIs == null) continue;
                    ejbIs.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unkown Exception while init", (Throwable)e);
            }
            attCache = Collections.unmodifiableMap(attCache);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"init complete.");
            }
        }
    }

    private List getEjbModulesFromEar(InputStream is) throws Exception {
        ArrayList<String> ejbs = new ArrayList<String>();
        SAXBuilder builder = new SAXBuilder(true);
        builder.setValidation(false);
        builder.setEntityResolver((EntityResolver)MyEntityResolver.getInstance());
        Document doc = builder.build(is);
        Element root = doc.getRootElement();
        List modules = root.getChildren("module");
        for (Element module : modules) {
            String ejbModuleName = module.getChildTextTrim("ejb");
            if (ejbModuleName == null) continue;
            ejbs.add(ejbModuleName);
        }
        return ejbs;
    }

    private void processEjbModule(InputStream is) throws Exception {
        SAXBuilder builder = new SAXBuilder(true);
        builder.setValidation(false);
        builder.setEntityResolver((EntityResolver)MyEntityResolver.getInstance());
        Document doc = builder.build(is);
        Element root = doc.getRootElement();
        List ejbs = root.getChild("enterprise-beans").getChildren("session");
        for (Element ejb : ejbs) {
            String ejbName = ejb.getChildTextTrim("ejb-name");
            String ejbClass = ejb.getChildTextTrim("ejb-class");
            indexs.put(ejbName, ejbClass);
        }
        List methods = root.getChild("assembly-descriptor").getChildren("container-transaction");
        for (Element method : methods) {
            String ejbName = method.getChild("method").getChildTextTrim("ejb-name");
            String methodName = method.getChild("method").getChildTextTrim("method-name");
            String ejbClass = (String)indexs.get(ejbName);
            String txAttr = Ejb2Spring.mappingTxAttribute(method.getChildTextTrim("trans-attribute"));
            Properties props = (Properties)attCache.get(ejbClass);
            if (props == null) {
                props = new Properties();
                attCache.put(ejbClass, props);
            }
            props.put(methodName, txAttr);
        }
    }

    @Override
    public Properties getAttribute(Class clazz) {
        Object attr;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("<<<<<<<<<Request Transaction Attribute for Class: " + clazz + ">>>>>>>>>>"));
        }
        if ((attr = attCache.get(clazz.getName())) == null) {
            logger.warn((Object)("No define find for Class[" + clazz + "],default is return."));
            return DEFAULT_ATTRIBUTE;
        }
        return (Properties)attr;
    }

    static {
        indexs = new HashMap();
        DEFAULT_ATTRIBUTE.put("*", "PROPAGATION_SUPPORTS");
    }

    private static class MyEntityResolver
    implements EntityResolver {
        private static MyEntityResolver singleton = new MyEntityResolver();

        public static MyEntityResolver getInstance() {
            return singleton;
        }

        private MyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource inSrc = new InputSource();
            if ("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN".equals(publicId) && "http://java.sun.com/dtd/ejb-jar_2_0.dtd".equals(systemId)) {
                inSrc.setSystemId(systemId);
                inSrc.setPublicId(publicId);
                InputStream is = this.getClass().getResourceAsStream("/com/kingdee/bos/transaction/ejb-jar_2_0.dtd");
                if (is == null) {
                    throw new IllegalStateException("please add ejb-jar_2_0.dtd to classpath");
                }
                inSrc.setByteStream(is);
                return inSrc;
            }
            if ("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN".equals(publicId) && "http://java.sun.com/dtd/application_1_3.dtd".equals(systemId)) {
                inSrc.setSystemId(systemId);
                inSrc.setPublicId(publicId);
                InputStream is = this.getClass().getResourceAsStream("/com/kingdee/bos/transaction/application_1_3.dtd");
                if (is == null) {
                    throw new IllegalStateException("please add application_1_3.dtd to classpath");
                }
                inSrc.setByteStream(is);
                return inSrc;
            }
            return null;
        }
    }

    private static class Ejb2Spring {
        private static final Map ejb2Spring;

        private Ejb2Spring() {
        }

        public static String mappingTxAttribute(String ejbTxAttr) {
            return (String)ejb2Spring.get(ejbTxAttr);
        }

        static {
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("Supports", "PROPAGATION_SUPPORTS");
            temp.put("Required", "PROPAGATION_REQUIRED");
            temp.put("RequiresNew", "PROPAGATION_REQUIRES_NEW");
            temp.put("Mandatory", "PROPAGATION_MANDATORY");
            temp.put("NotSupported", "PROPAGATION_NOT_SUPPORTED");
            temp.put("Never", "PROPAGATION_NEVER");
            ejb2Spring = Collections.unmodifiableMap(temp);
        }
    }
}

