/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction;

import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.transaction.ConcurrentGroup;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ConcurrentController {
    public static ConcurrentGroup[] locks = null;
    public static Map locksIndex = new HashMap();
    private static final Logger logger = Logger.getLogger(ConcurrentController.class);

    public static ConcurrentGroup findLockByMethod(Object obj, Method method) {
        Class<?> clazz = obj.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String fullName = clazz.getName();
        int pos = fullName.lastIndexOf(".");
        String name = fullName.substring(pos + 1);
        String pkg = "";
        if (pos != -1) {
            pkg = fullName.substring(0, pos);
        }
        String methodName = method.getName();
        for (int i = 0; i < locks.length; ++i) {
            ConcurrentGroup lock = locks[i];
            if (!lock.match(pkg, name, methodName)) continue;
            return lock;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        ConfigReader r = new ConfigReader();
        FileInputStream is = new FileInputStream("test.conf");
        ConcurrentGroup[] groups = r.parse(is);
        for (int i = 0; i < groups.length; ++i) {
            ConcurrentGroup g = groups[i];
            ConcurrentGroup.GroupItem[] items = g.items;
            for (int j = 0; j < items.length; ++j) {
                ConcurrentGroup.GroupItem item = items[j];
            }
        }
    }

    static {
        try {
            List slns = DeployInfoManagerFactory.getDeployInfoManager().getSolutionDeployInfos();
            String confFile = ((SolutionDeployInfo)slns.get(0)).getConcurrentConfigPath();
            FileInputStream is = new FileInputStream(confFile);
            ConfigReader config = new ConfigReader();
            locks = config.parse(is);
        }
        catch (Exception e) {
            locks = new ConcurrentGroup[0];
        }
    }

    private static class ConfigReader {
        private static final String itemFormat = "^[\\s]*([+\\-]?)[\\s]*([^#&&\\S]+)[\\s]*$";
        private static final String groupFormat = "^[\\s]*\\[([\\S]+)\\][\\s]+([\\d]+)[\\s]*$";

        private ConfigReader() {
        }

        public ConcurrentGroup[] parse(InputStream is) throws Exception {
            Vector<ConcurrentGroup> vLocks = new Vector<ConcurrentGroup>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            Pattern itemReg = Pattern.compile(itemFormat);
            Pattern groupReg = Pattern.compile(groupFormat);
            String lastGroupName = null;
            int lastGroupMax = 0;
            Vector<ConcurrentGroup.GroupItem> lastGroupItems = new Vector<ConcurrentGroup.GroupItem>();
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    Matcher m = groupReg.matcher(line);
                    if (m.matches()) {
                        if (lastGroupName != null) {
                            ConcurrentGroup.GroupItem[] items = lastGroupItems.toArray(new ConcurrentGroup.GroupItem[0]);
                            ConcurrentGroup group = new ConcurrentGroup(lastGroupMax, items);
                            vLocks.add(group);
                            locksIndex.put(lastGroupName, group);
                        }
                        lastGroupName = m.group(1);
                        lastGroupMax = Integer.parseInt(m.group(2));
                        lastGroupItems.clear();
                        continue;
                    }
                    m = itemReg.matcher(line);
                    if (!m.matches()) continue;
                    String incStr = m.group(1);
                    boolean inc = true;
                    if ("+".equals(incStr)) {
                        inc = true;
                    } else if ("-".equals(incStr)) {
                        inc = false;
                    }
                    String item = m.group(2);
                    int pos = item.lastIndexOf(":");
                    String method = "*";
                    if (pos != -1) {
                        method = item.substring(pos + 1);
                        item = item.substring(0, pos);
                    }
                    if (method == null || method.length() == 0) {
                        method = "*";
                    }
                    pos = item.lastIndexOf(".");
                    String pkg = "";
                    String name = "*";
                    if (pos != -1) {
                        pkg = item.substring(0, pos);
                        name = item.substring(pos + 1);
                    }
                    if (name == null || name.length() == 0) {
                        name = "*";
                    }
                    lastGroupItems.add(new ConcurrentGroup.GroupItem(inc, pkg, name, method));
                }
                if (lastGroupName != null) {
                    ConcurrentGroup.GroupItem[] items = lastGroupItems.toArray(new ConcurrentGroup.GroupItem[0]);
                    ConcurrentGroup group = new ConcurrentGroup(lastGroupMax, items);
                    vLocks.add(group);
                    locksIndex.put(lastGroupName, group);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Parse concurrent config line error. line=" + line));
                throw e;
            }
            return vLocks.toArray(new ConcurrentGroup[0]);
        }
    }
}

