/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction;

import com.kingdee.bos.transaction.ConcurrentException;
import java.util.regex.Pattern;

public class ConcurrentGroup {
    private int limitThread = 1;
    private int activeThread = 0;
    public GroupItem[] items = null;
    private static final int MATCH_TRUE = 1;
    private static final int MATCH_FALSE = -1;
    private static final int MATCH_UNKOWN = 0;

    ConcurrentGroup(int max, GroupItem[] items) {
        if (max >= 0) {
            this.limitThread = max;
        }
        this.items = items == null ? new GroupItem[0] : items;
    }

    synchronized int setMax(int max) {
        if (max >= 0) {
            this.limitThread = max;
        }
        return this.limitThread;
    }

    int getMax() {
        return this.limitThread;
    }

    int getActive() {
        return this.activeThread;
    }

    synchronized void lock() {
        ++this.activeThread;
        if (this.activeThread > this.limitThread) {
            throw new ConcurrentException("MaxLimit is [" + this.limitThread + "]");
        }
    }

    synchronized void unlock() {
        --this.activeThread;
    }

    public boolean match(String pkg, String name, String method) {
        for (int i = 0; i < this.items.length; ++i) {
            GroupItem item = this.items[i];
            int result = item.match(pkg, name, method);
            if (1 == result) {
                return true;
            }
            if (-1 != result) continue;
            return false;
        }
        return false;
    }

    public static class GroupItem {
        public boolean included = true;
        public Pattern regPackage;
        public Pattern regClassName;
        public Pattern regMethodName;

        public GroupItem(String pkg, String name, String method) {
            this(true, pkg, name, method);
        }

        public GroupItem(boolean inc, String pkg, String name, String method) {
            this.included = inc;
            this.regPackage = Pattern.compile(GroupItem.reg(pkg));
            this.regClassName = Pattern.compile(GroupItem.reg(name));
            this.regMethodName = Pattern.compile(GroupItem.reg(method));
        }

        private static String reg(String r) {
            r = r.replaceAll("\\.", "\\\\.");
            r = r.replaceAll("\\*", "\\[\\.\\]*");
            r = r.replaceAll("\\?", "\\[\\.\\]?");
            return r;
        }

        public int match(String pkg, String name, String method) {
            boolean isMatch;
            boolean bl = isMatch = this.regPackage.matcher(pkg).matches() && this.regClassName.matcher(name).matches() && this.regMethodName.matcher(method).matches();
            if (isMatch) {
                return this.included ? 1 : -1;
            }
            return 0;
        }
    }
}

