/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction;

import com.kingdee.bos.transaction.AbstractTransactionInterceptor;
import com.kingdee.bos.transaction.AttributeConfig;
import com.kingdee.bos.transaction.BOSTransactionAttribute;
import com.kingdee.bos.transaction.springframework.transaction.PlatformTransactionManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public final class TransactionInterceptor
extends AbstractTransactionInterceptor
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.transaction.TransactionInterceptor");
    private final Object target;

    public TransactionInterceptor(Object target, PlatformTransactionManager transactionManager, AttributeConfig config) {
        this.target = target;
        this.setTransactionManager(transactionManager);
        this.setTransactionAttributes(config.getAttribute(target.getClass()));
        this.afterPropertiesSet();
    }

    public TransactionInterceptor(Object target, PlatformTransactionManager transactionManager, BOSTransactionAttribute attrs) {
        this.target = target;
        this.setTransactionManager(transactionManager);
        this.setTransactionProperties(attrs);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object retVal = null;
        AbstractTransactionInterceptor.TransactionInfo txInfo = this.createTransactionIfNecessary(method);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("invoke meyhod=[" + method + "] txInfo=" + txInfo));
        }
        try {
            retVal = method.invoke(this.target, args);
        }
        catch (IllegalAccessException iae) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy invoke catch a IllegalAccessException", (Throwable)iae);
            }
            TransactionInterceptor.tryRollback();
        }
        catch (IllegalArgumentException iae) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Prxoy invoke catch a IllegalArgumentException", (Throwable)iae);
            }
            TransactionInterceptor.tryRollback();
        }
        catch (InvocationTargetException ie) {
            Throwable t;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy Invoke catch a target Exception, process continue", ie.getCause());
            }
            if ((t = ie.getCause()) instanceof RuntimeException || t instanceof Error) {
                TransactionInterceptor.tryRollback();
            }
            throw t;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy invoke doFinally");
            }
            this.doFinally(txInfo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy invoke before doCommit");
            }
            this.doCommitTransactionAfterReturning(txInfo);
        }
        return retVal;
    }
}

