/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.CachedConnection;
import java.sql.Connection;
import java.sql.SQLException;

public class TxContext {
    public static final boolean isTxConnectionCache = false;
    private final boolean doInTx;
    private final TxContext parentTx;
    public CachedConnection cachedConnection;
    private static final ThreadLocal<TxContext> threadTx = new ThreadLocal();

    public TxContext(boolean doInTx, TxContext current) {
        this.doInTx = doInTx;
        this.parentTx = current;
    }

    public boolean isDoInTx() {
        return this.doInTx;
    }

    public static TxContext currentTxContext() {
        return threadTx.get();
    }

    public static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection0(ctx);
    }

    private static TxContext topContext(TxContext curr) {
        TxContext self = curr;
        TxContext parent = self.parentTx;
        while (parent != null) {
            self = parent;
            parent = self.parentTx;
        }
        return self;
    }

    static void storeTxContext(TxContext tx) {
        threadTx.set(tx);
    }

    static void restoreTxContext(TxContext tx) {
        threadTx.set(tx.parentTx);
        CachedConnection conn = tx.cachedConnection;
        if (conn != null) {
            try {
                conn.delegate.close();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Close Cached Connection Error.");
            }
            tx.cachedConnection = null;
        }
    }
}

