/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.jndi;

import com.kingdee.bos.transaction.springframework.jndi.JndiTemplate;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JndiLocatorSupport {
    public static final String CONTAINER_PREFIX = "java:comp/env/";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JndiTemplate jndiTemplate = new JndiTemplate();
    private boolean resourceRef = false;

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiTemplate = new JndiTemplate(jndiEnvironment);
    }

    public Properties getJndiEnvironment() {
        return this.jndiTemplate.getEnvironment();
    }

    public void setResourceRef(boolean resourceRef) {
        this.resourceRef = resourceRef;
    }

    public boolean isResourceRef() {
        return this.resourceRef;
    }

    protected Object lookup(String jndiName) throws NamingException {
        String jndiNameToUse = this.convertJndiName(jndiName);
        Object jndiObject = this.getJndiTemplate().lookup(jndiNameToUse);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Located object with JNDI name '" + jndiNameToUse + "': value=[" + jndiObject + "]"));
        }
        return jndiObject;
    }

    protected String convertJndiName(String jndiName) {
        if (this.isResourceRef() && !jndiName.startsWith(CONTAINER_PREFIX) && jndiName.indexOf(58) == -1) {
            jndiName = CONTAINER_PREFIX + jndiName;
        }
        return jndiName;
    }
}

