/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.transaction.interceptor;

import com.kingdee.bos.transaction.springframework.aop.framework.AopConfigException;
import java.io.Serializable;

public class RollbackRuleAttribute
implements Serializable {
    public static final RollbackRuleAttribute ROLLBACK_ON_RUNTIME_EXCEPTIONS = new RollbackRuleAttribute("java.lang.RuntimeException");
    private final String exceptionName;

    public RollbackRuleAttribute(Class clazz) {
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new AopConfigException("Cannot construct rollback rule from " + clazz + "; " + "it's not a Throwable");
        }
        this.exceptionName = clazz.getName();
    }

    public RollbackRuleAttribute(String exceptionName) {
        this.exceptionName = exceptionName;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public int getDepth(Throwable t) {
        return this.getDepth(t.getClass(), 0);
    }

    private int getDepth(Class exceptionClass, int depth) {
        if (exceptionClass.getName().indexOf(this.exceptionName) != -1) {
            return depth;
        }
        if (exceptionClass.equals(Throwable.class)) {
            return -1;
        }
        return this.getDepth(exceptionClass.getSuperclass(), depth + 1);
    }

    public String toString() {
        return "RollbackRule with pattern '" + this.exceptionName + "'";
    }
}

