/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.transaction.interceptor;

import com.kingdee.bos.transaction.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.RollbackRuleAttribute;
import com.kingdee.bos.transaction.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import com.kingdee.bos.transaction.springframework.util.StringUtils;
import java.beans.PropertyEditorSupport;

public class TransactionAttributeEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(String s) throws IllegalArgumentException {
        if (s == null || "".equals(s)) {
            this.setValue(null);
        } else {
            String[] tokens = StringUtils.commaDelimitedListToStringArray(s);
            RuleBasedTransactionAttribute attr = new RuleBasedTransactionAttribute();
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (token.startsWith("PROPAGATION")) {
                    attr.setPropagationBehaviorName(token);
                    continue;
                }
                if (token.startsWith("ISOLATION")) {
                    attr.setIsolationLevelName(token);
                    continue;
                }
                if (token.startsWith("timeout_")) {
                    String value = token.substring("timeout_".length());
                    attr.setTimeout(Integer.parseInt(value));
                    continue;
                }
                if (token.equals("readOnly")) {
                    attr.setReadOnly(true);
                    continue;
                }
                if (token.startsWith("+")) {
                    attr.getRollbackRules().add(new NoRollbackRuleAttribute(token.substring(1)));
                    continue;
                }
                if (token.startsWith("-")) {
                    attr.getRollbackRules().add(new RollbackRuleAttribute(token.substring(1)));
                    continue;
                }
                throw new IllegalArgumentException("Illegal transaction attribute token: [" + token + "]");
            }
            this.setValue(attr);
        }
    }
}

