/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.transaction.jta;

import com.kingdee.bos.transaction.springframework.beans.factory.FactoryBean;
import com.kingdee.bos.transaction.springframework.transaction.TransactionSystemException;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebSphereTransactionManagerFactoryBean
implements FactoryBean {
    public static final String FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    public static final String FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    public static final String FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
    private static final Log logger = LogFactory.getLog(WebSphereTransactionManagerFactoryBean.class);
    private final TransactionManager transactionManager;

    public WebSphereTransactionManagerFactoryBean() throws TransactionSystemException {
        Class<?> clazz;
        try {
            logger.debug((Object)"Trying WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
            clazz = Class.forName(FACTORY_CLASS_5_1);
            logger.debug((Object)"Found WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
        }
        catch (ClassNotFoundException ex) {
            try {
                logger.debug((Object)"Trying WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                clazz = Class.forName(FACTORY_CLASS_5_0);
                logger.debug((Object)"Found WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
            }
            catch (ClassNotFoundException ex2) {
                try {
                    logger.debug((Object)"Trying WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                    clazz = Class.forName(FACTORY_CLASS_4);
                    logger.debug((Object)"Found WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                }
                catch (ClassNotFoundException ex3) {
                    throw new TransactionSystemException("Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4");
                }
            }
        }
        try {
            Method method = clazz.getMethod("getTransactionManager", null);
            this.transactionManager = (TransactionManager)method.invoke(null, null);
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Found WebSphere TransactionManager factory class [" + clazz.getName() + "], but couldn't invoke its static 'getTransactionManager' method", ex);
        }
    }

    @Override
    public Object getObject() {
        return this.transactionManager;
    }

    @Override
    public Class getObjectType() {
        return this.transactionManager.getClass();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

