/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.transaction.springframework.transaction.support;

import com.kingdee.bos.transaction.springframework.transaction.NestedTransactionNotSupportedException;
import com.kingdee.bos.transaction.springframework.transaction.SavepointManager;
import com.kingdee.bos.transaction.springframework.transaction.TransactionException;
import com.kingdee.bos.transaction.springframework.transaction.TransactionStatus;
import com.kingdee.bos.transaction.springframework.transaction.TransactionUsageException;

public class DefaultTransactionStatus
implements TransactionStatus {
    private final Object transaction;
    private final boolean newTransaction;
    private final boolean newSynchronization;
    private final boolean readOnly;
    private final boolean debug;
    private final Object suspendedResources;
    private boolean rollbackOnly;
    private Object savepoint;

    public DefaultTransactionStatus(Object transaction, boolean newTransaction, boolean newSynchronization, boolean readOnly, boolean debug, Object suspendedResources) {
        this.transaction = transaction;
        this.newTransaction = newTransaction;
        this.newSynchronization = newSynchronization;
        this.readOnly = readOnly;
        this.debug = debug;
        this.suspendedResources = suspendedResources;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isNewTransaction() {
        return this.transaction != null && this.newTransaction;
    }

    public boolean isNewSynchronization() {
        return this.newSynchronization;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Object getSuspendedResources() {
        return this.suspendedResources;
    }

    @Override
    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    protected void setSavepoint(Object savepoint) {
        this.savepoint = savepoint;
    }

    public Object getSavepoint() {
        return this.savepoint;
    }

    public boolean hasSavepoint() {
        return this.savepoint != null;
    }

    public boolean isTransactionSavepointManager() {
        return this.getTransaction() instanceof SavepointManager;
    }

    protected SavepointManager getSavepointManager() {
        if (!this.isTransactionSavepointManager()) {
            throw new NestedTransactionNotSupportedException("Transaction object [" + this.getTransaction() + "] does not support savepoints");
        }
        return (SavepointManager)this.getTransaction();
    }

    @Override
    public Object createSavepoint() throws TransactionException {
        return this.getSavepointManager().createSavepoint();
    }

    @Override
    public void rollbackToSavepoint(Object savepoint) throws TransactionException {
        this.getSavepointManager().rollbackToSavepoint(savepoint);
    }

    @Override
    public void releaseSavepoint(Object savepoint) throws TransactionException {
        this.getSavepointManager().releaseSavepoint(savepoint);
    }

    public void createAndHoldSavepoint() throws TransactionException {
        this.setSavepoint(this.getSavepointManager().createSavepoint());
    }

    public void rollbackToHeldSavepoint() throws TransactionException {
        if (!this.hasSavepoint()) {
            throw new TransactionUsageException("No savepoint associated with current transaction");
        }
        this.getSavepointManager().rollbackToSavepoint(this.getSavepoint());
    }

    public void releaseHeldSavepoint() throws TransactionException {
        if (!this.hasSavepoint()) {
            throw new TransactionUsageException("No savepoint associated with current transaction");
        }
        this.getSavepointManager().releaseSavepoint(this.getSavepoint());
    }
}

