/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util.rpc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class ObjectFactory {
    private static Logger logger = Logger.getLogger(ObjectFactory.class);
    private static Bridge b = new Bridge();
    private static Method m = null;

    public static ArrayList loadClasses(String packagename) throws BOSException {
        try {
            String s;
            if (!packagename.endsWith(".")) {
                packagename = packagename + ".";
            }
            String path = packagename.replace('.', '/');
            ClassLoader loader = ObjectFactory.class.getClassLoader();
            URL url = loader.getResource(path);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            ArrayList classes = new ArrayList();
            while ((s = reader.readLine()) != null && s.length() != 0) {
                if (!s.endsWith(".class")) continue;
                s = s.substring(0, s.lastIndexOf(".class"));
                String classname = packagename + s;
                Class<?> cls = Class.forName(classname);
                int mod = cls.getModifiers();
                if (Modifier.isAbstract(mod) || Modifier.isInterface(mod)) continue;
                classes.add(cls);
            }
            return classes;
        }
        catch (Exception e) {
            throw new BOSException("load classes from package {" + packagename + "} failed", (Throwable)e);
        }
    }

    public static Method getMethod(Class cls, String methodName) {
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            return methods[i];
        }
        return null;
    }

    public static boolean isSubClassOf(Class cls, Class superClass) {
        if (cls.equals(superClass)) {
            return true;
        }
        Class<?>[] array = cls.getClasses();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(superClass)) continue;
            return true;
        }
        return false;
    }

    public static Class getClass(String className) throws BOSException {
        try {
            if ("int".equals(className)) {
                return Integer.TYPE;
            }
            if ("boolean".equals(className)) {
                return Boolean.TYPE;
            }
            if ("char".equals(className)) {
                return Character.TYPE;
            }
            if ("long".equals(className)) {
                return Long.TYPE;
            }
            if ("byte".equals(className)) {
                return Byte.TYPE;
            }
            if ("short".equals(className)) {
                return Short.TYPE;
            }
            return Class.forName(className);
        }
        catch (Throwable t) {
            throw new BOSException("get class failed! {" + className + "}", t);
        }
    }

    public static Object newInstance(Class cls, Class[] types, Object[] params) throws BOSException {
        try {
            Constructor c = cls.getConstructor(types);
            return c.newInstance(params);
        }
        catch (Throwable t) {
            throw new BOSException("new instance failed! {" + cls.getName() + "}", t);
        }
    }

    public static Method getMethod(Class cls, String method, Class[] types) throws BOSException {
        try {
            return cls.getMethod(method, types);
        }
        catch (Throwable t) {
            throw new BOSException("get method failed! {" + cls.getName() + "#" + method + "}", t);
        }
    }

    public static Object invoke(Object o, Method method, Object[] params) throws BOSException {
        try {
            return method.invoke(o, params);
        }
        catch (Throwable t) {
            throw new BOSException("invoke method failed! {" + (o == null ? "static" : o.getClass().getName()) + "#" + method + "}", t);
        }
    }

    public static Object invokeRequired(Object o, Method method, Object[] params) throws BOSException {
        try {
            EJBTransactionProxy proxy = EJBFactory.getEJBTransactionProxy(b);
            return proxy.invoke(m, new Object[]{o, method, params}, 0);
        }
        catch (Throwable t) {
            if (t instanceof BOSException) {
                throw (BOSException)t;
            }
            throw new BOSException("call method " + o.getClass().getName() + "#" + method.getName() + " failed!", t);
        }
    }

    static {
        try {
            m = Bridge.class.getMethod("invoke", Object.class, Method.class, Object[].class);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static class Bridge {
        public Object invoke(Object o, Method method, Object[] params) throws Throwable {
            try {
                Object r = method.invoke(o, params);
                return r;
            }
            catch (Throwable t) {
                EJBTransactionProxy.tryRollback();
                throw t;
            }
        }
    }
}

