/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util.rpc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.rpc.Ajax;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.util.Uuid;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class WebProxy {
    private static HashSet excludeMethods = null;
    private static int count;
    static final String SEPERATOR = "$";
    private Class target;
    private Constructor constructor;
    private String namespace;
    private HashMap methods;
    private HashMap constructors;
    private String java_script;
    private String uuid;

    private static synchronized int inc() {
        return count++;
    }

    String getTarget() {
        return this.target.getName();
    }

    String getNameSpace() {
        return this.namespace;
    }

    String getJavaScript() {
        return this.java_script;
    }

    String getUuid() {
        return this.uuid;
    }

    WebProxy(Class target) throws BOSException {
        try {
            this.constructor = target.getConstructor(Context.class);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException(target + " has not constructor with only a Context parameter.");
        }
        this.target = target;
        this.namespace = "T" + WebProxy.inc();
        this.uuid = Uuid.randomUUID().toString();
        this.initJavaScript();
    }

    private void initJavaScript() {
        this.methods = new HashMap();
        this.constructors = new HashMap();
        Method[] methods = this.target.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Constructor[] tmp;
            Method m = methods[i];
            if ((m.getModifiers() & 1) == 0 || (tmp = WebProxy.checkParameterType(m)) == null) continue;
            this.methods.put(m.getName(), m);
            this.constructors.put(m.getName(), tmp);
        }
        StringBuffer scripts = new StringBuffer();
        scripts.append("\r\n\r\n/*--------------------------------*/\r\n");
        scripts.append("var ").append(this.namespace).append("={};");
        for (String method : this.constructors.keySet()) {
            Constructor[] types = (Constructor[])this.constructors.get(method);
            this.appendScript(method, types.length, scripts);
        }
        scripts.append("\r\n/*--------------------------------*/\r\n\r\n");
        this.java_script = scripts.toString();
    }

    private void appendScript(String method, int paraCount, StringBuffer scripts) {
        int i;
        scripts.append("\r\n\r\n");
        scripts.append(this.namespace).append(".").append(method);
        scripts.append("=function (){\r\n");
        scripts.append("\treturn _$$_ajax_ue_call('");
        scripts.append(this.uuid).append(SEPERATOR).append(method);
        scripts.append("',[");
        for (i = 0; i < paraCount; ++i) {
            if (i > 0) {
                scripts.append(",");
            }
            scripts.append("'P'");
        }
        scripts.append("],arguments);\r\n");
        scripts.append("}");
        scripts.append("\r\n\r\n");
        scripts.append(this.namespace).append(".").append(method).append(SEPERATOR);
        scripts.append("=function (){\r\n");
        scripts.append("\treturn _$$_ajax_ue_call('");
        scripts.append(this.uuid).append(SEPERATOR).append(method).append(SEPERATOR);
        scripts.append("',[");
        for (i = 0; i < paraCount; ++i) {
            if (i > 0) {
                scripts.append(",");
            }
            scripts.append("'P'");
        }
        scripts.append("],arguments);\r\n");
        scripts.append("}");
    }

    private static Constructor[] checkParameterType(Method m) {
        if (excludeMethods.contains(m.getName())) {
            return null;
        }
        Class<?>[] types = m.getParameterTypes();
        Constructor[] constructors = new Constructor[types.length];
        for (int i = 0; i < types.length; ++i) {
            try {
                if (types[i].getName().equals(String.class.getName())) {
                    constructors[i] = null;
                    continue;
                }
                if (types[i].getName().equals(ArrayList.class.getName())) {
                    constructors[i] = null;
                    continue;
                }
                if (types[i].getName().equals(List.class.getName())) {
                    constructors[i] = null;
                    continue;
                }
                if (types[i].getName().equals(Collection.class.getName())) {
                    constructors[i] = null;
                    continue;
                }
                if (types[i].getName().equals(HashMap.class.getName())) {
                    constructors[i] = null;
                    continue;
                }
                if (types[i].getName().equals(Map.class.getName())) {
                    constructors[i] = null;
                    continue;
                }
                constructors[i] = types[i].getConstructor(String.class);
                continue;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return constructors;
    }

    Object invoke(Context ctx, String method, Object[] parameters) throws Exception {
        Constructor[] constructors;
        boolean requireTx = method.endsWith(SEPERATOR);
        if (requireTx) {
            method = method.substring(0, method.length() - SEPERATOR.length());
        }
        if (parameters.length != (constructors = (Constructor[])this.constructors.get(method)).length) {
            throw new BOSException("paramters length is {" + parameters.length + "}, and required length is {" + constructors.length + "}.");
        }
        Object[] values = new Object[constructors.length];
        for (int i = 0; i < values.length; ++i) {
            Object o = parameters[i];
            if (o == null) continue;
            values[i] = constructors[i] != null ? constructors[i].newInstance(o) : o;
        }
        Object target = this.constructor.newInstance(ctx);
        Method m = (Method)this.methods.get(method);
        if (requireTx) {
            return ObjectFactory.invokeRequired(target, m, values);
        }
        return m.invoke(target, values);
    }

    public static String register(Class target, String namespace) throws BOSException {
        return Ajax.register(target, namespace);
    }

    public static String register(Class[] targets, String[] namespaces) throws BOSException {
        return Ajax.register(targets, namespaces);
    }

    public static String include(Class target) throws BOSException {
        return WebProxy.include(target, null);
    }

    public static String include(Class[] targets) throws BOSException {
        return WebProxy.include(targets, null);
    }

    public static String include(Class target, String namespace) throws BOSException {
        String s = WebProxy.register(target, namespace);
        return WebProxy.toScriptTag(s);
    }

    public static String include(Class[] targets, String[] namespaces) throws BOSException {
        String s = WebProxy.register(targets, namespaces);
        return WebProxy.toScriptTag(s);
    }

    private static String toScriptTag(String rpcStub) {
        return "<script src='/easweb/workflow/invoke.jsp?" + rpcStub + "'></script>";
    }

    public static String include2(Class target, String namespace) throws BOSException {
        String s = WebProxy.register(target, namespace);
        return WebProxy.toScriptTag2(s);
    }

    private static String toScriptTag2(String rpcStub) {
        return "<script src='/easportal/workflow/invoke.jsp?" + rpcStub + "'></script>";
    }

    static {
        excludeMethods = new HashSet();
        Method[] methods = Object.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            excludeMethods.add(methods[i].getName());
        }
        count = 0;
    }
}

