/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.exception;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.exception.ExceptionInfo;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;

public class ExceptionInfoUtil {
    public static String formatShort(ExceptionInfo info, List argList) {
        String result = info.getShortInfo();
        return MessageFormat.format(result, argList.toArray());
    }

    public static String localeStr(String key, Properties localeLangs, Properties defaultLangs) {
        String value = localeLangs.getProperty(key);
        if (value == null) {
            value = defaultLangs.getProperty(key);
        }
        return value;
    }

    public static void processLocaleProperties(Map localeProperties, InputStream inputStream) throws Exception {
        Properties props = new Properties();
        props.load(inputStream);
        String locale = props.getProperty("locale");
        if (locale == null) {
            return;
        }
        Properties orgProps = (Properties)localeProperties.get(locale = locale.toLowerCase());
        if (orgProps == null) {
            localeProperties.put(locale, props);
        } else {
            orgProps.putAll((Map<?, ?>)props);
        }
    }

    public static void processXML(Map exceptionInfos, InputStream inputStream) throws Exception {
        Document doc = XMLParser.parseXML(inputStream);
        Element root = doc.getRootElement();
        if (!"exceptions".equalsIgnoreCase(root.getName())) {
            return;
        }
        String locale = root.getAttributeValue("locale");
        String defSubSystem = root.getAttributeValue("subsystem");
        String defType = root.getAttributeValue("type");
        if (locale == null) {
            throw new IllegalDataException("null", "Must set locale attribute on <exceptions> element");
        }
        HashMap<String, ExceptionInfo> map = (HashMap<String, ExceptionInfo>)exceptionInfos.get(locale = locale.toLowerCase());
        if (map == null) {
            map = new HashMap<String, ExceptionInfo>();
            exceptionInfos.put(locale, map);
        }
        List exceptionEls = root.getChildren("exception");
        for (Element exceptionEl : exceptionEls) {
            Element responsesEl;
            String id = exceptionEl.getAttributeValue("id").toLowerCase();
            String type = exceptionEl.getAttributeValue("type");
            type = type != null ? type.toLowerCase() : defType;
            String subsystem = exceptionEl.getAttributeValue("subsystem");
            subsystem = subsystem != null ? subsystem.toLowerCase() : defSubSystem;
            ExceptionInfo info = new ExceptionInfo(id);
            info.setType(type);
            info.setSubsystem(subsystem);
            Element shortEl = exceptionEl.getChild("short");
            String shortDesc = shortEl.getChildTextTrim("text");
            List paramEls = shortEl.getChildren("param");
            ArrayList<String> param = new ArrayList<String>();
            for (int i = 0; i < paramEls.size(); ++i) {
                Element paramEl = (Element)paramEls.get(i);
                param.add(paramEl.getTextTrim());
            }
            info.setShortInfo(shortDesc);
            info.setArgs(param.toArray(new String[0]));
            Element explainEl = exceptionEl.getChild("explain");
            if (explainEl != null) {
                List reasonEls = explainEl.getChildren("reason");
                ArrayList<String> reasonList = new ArrayList<String>();
                for (int i = 0; i < reasonEls.size(); ++i) {
                    Element reasonEl = (Element)reasonEls.get(i);
                    reasonList.add(reasonEl.getTextTrim());
                }
                info.setReasons(reasonList.toArray(new String[0]));
                List sceneEls = explainEl.getChildren("scene");
                ArrayList<String> sceneList = new ArrayList<String>();
                for (int i = 0; i < sceneEls.size(); ++i) {
                    Element sceneEl = (Element)sceneEls.get(i);
                    sceneList.add(sceneEl.getTextTrim());
                }
                info.setScenes(sceneList.toArray(new String[0]));
                List codeEls = explainEl.getChildren("code");
                HashMap<Attribute, String> codeMap = new HashMap<Attribute, String>();
                for (int i = 0; i < codeEls.size(); ++i) {
                    Element codeEl = (Element)codeEls.get(i);
                    codeMap.put(codeEl.getAttribute("value"), codeEl.getTextTrim());
                }
                info.setCodes(codeMap);
            }
            if ((responsesEl = exceptionEl.getChild("responses")) != null) {
                List responseEls = responsesEl.getChildren("response");
                ArrayList<String> responseList = new ArrayList<String>();
                for (int i = 0; i < responseEls.size(); ++i) {
                    Element responseEl = (Element)responseEls.get(i);
                    responseList.add(responseEl.getTextTrim());
                }
                info.setResponses(responseList.toArray(new String[0]));
            }
            List tryEls = exceptionEl.getChildren("try");
            ArrayList<String[]> tryList = new ArrayList<String[]>();
            for (int i = 0; i < tryEls.size(); ++i) {
                Element tryEl = (Element)tryEls.get(i);
                List stepEls = tryEl.getChildren("step");
                String[] steps = new String[stepEls.size()];
                for (int j = 0; j < steps.length; ++j) {
                    steps[j] = ((Element)stepEls.get(j)).getTextTrim();
                }
                tryList.add(steps);
            }
            info.setTrys(tryList);
            map.put(id, info);
        }
    }
}

