/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.exception;

import com.kingdee.exception.ExceptionInfo;
import com.kingdee.exception.ExceptionInfoUtil;
import com.kingdee.exception.ExceptionMessage;
import com.kingdee.exception.IExceptionInfoManager;
import com.kingdee.exception.IExceptionInfoSupport;
import com.kingdee.exception.IExceptionProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class ExceptionUtil {
    public static final String CONFIG_FILE_KEY = "ExceptionUtil.CONFIG_FILE";
    public static final String CONFIG_FILE_NAME = "exceptionUtilConfig.xml";
    private static final Logger defLogger = Logger.getLogger(ExceptionUtil.class);
    private static Map processorCache = new HashMap();
    private static Map processorClz = new HashMap();
    private static Map managerCache = new HashMap();

    private static void init(InputStream input) throws Exception {
        Element processorsEl;
        SAXBuilder builder = new SAXBuilder();
        Element config = builder.build(input).getRootElement();
        Element managersEl = config.getChild("managers");
        if (managersEl != null) {
            List managerEls = managersEl.getChildren("manager");
            for (int i = 0; i < managerEls.size(); ++i) {
                Element contextEl = (Element)managerEls.get(i);
                String cls = contextEl.getAttributeValue("class");
                List propertyEls = contextEl.getChildren("property");
                Properties props = new Properties();
                for (int j = 0; j < propertyEls.size(); ++j) {
                    Element propertyEl = (Element)propertyEls.get(j);
                    String key = propertyEl.getAttributeValue("key");
                    String value = propertyEl.getAttributeValue("value");
                    if (value == null || value.trim().length() == 0) {
                        value = propertyEl.getTextTrim();
                    }
                    props.put(key, value);
                }
                List acceptEls = contextEl.getChildren("accept");
                ArrayList<String> acceptClz = new ArrayList<String>();
                for (int j = 0; j < acceptEls.size(); ++j) {
                    Element acceptEl = (Element)acceptEls.get(j);
                    acceptClz.add(acceptEl.getTextTrim());
                }
                try {
                    ExceptionUtil.registerManager(Class.forName(cls), props, acceptClz);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((processorsEl = config.getChild("processors")) != null) {
            List processorEls = processorsEl.getChildren("processor");
            for (int i = 0; i < processorEls.size(); ++i) {
                Element processorEl = (Element)processorEls.get(i);
                String clsname = processorEl.getTextTrim();
                if (clsname == null || clsname.trim().length() == 0) continue;
                String type = processorEl.getAttributeValue("type");
                String singleton = processorEl.getAttributeValue("singleton");
                try {
                    ExceptionUtil.registerProcessor(type, Class.forName(clsname), Boolean.valueOf(singleton));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public static void registerManager(Class managerCls, Properties props, List acceptClz) throws Exception {
        IExceptionInfoManager manager = (IExceptionInfoManager)managerCls.newInstance();
        manager.init(props);
        if (acceptClz != null) {
            for (int i = 0; i < acceptClz.size(); ++i) {
                managerCache.put(acceptClz.get(i), manager);
                if (managerCache.size() != 1) continue;
                managerCache.put("*", manager);
            }
        }
    }

    public static void registerManager(IExceptionInfoManager manager, List acceptClz) throws Exception {
        if (acceptClz != null) {
            for (int i = 0; i < acceptClz.size(); ++i) {
                managerCache.put(acceptClz.get(i), manager);
            }
        }
    }

    public static void registerProcessor(String type, Class processorCls, boolean singleton) throws Exception {
        if (singleton) {
            IExceptionProcessor processor = (IExceptionProcessor)processorCls.newInstance();
            processorCache.put(type, processor);
        } else {
            processorClz.put(type, processorCls);
        }
    }

    public static void registerProcessor(String type, IExceptionProcessor processor) throws Exception {
        processorCache.put(type, processor);
    }

    public static String getSimpleMessage(IExceptionInfoSupport bind) {
        if (bind.getInfoId() != null) {
            IExceptionInfoManager manager = ExceptionUtil.getManager(bind);
            if (manager == null) {
                return bind.getInfoId();
            }
            return manager.getSimpleDesc(bind);
        }
        return null;
    }

    public static String getDetailMessage(IExceptionInfoSupport bind) {
        if (bind.getInfoId() != null) {
            IExceptionInfoManager manager = ExceptionUtil.getManager(bind);
            if (manager != null) {
                return manager.getDetailDesc(bind);
            }
            return bind.getInfoId();
        }
        return null;
    }

    public static ExceptionMessage getMessages(IExceptionInfoSupport bind) {
        ArrayList<IExceptionInfoSupport> list = new ArrayList<IExceptionInfoSupport>();
        IExceptionInfoSupport subBind = bind;
        list.add(subBind);
        ExceptionMessage message = new ExceptionMessage();
        StringBuffer simpleDesc = new StringBuffer();
        StringBuffer detailDesc = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            IExceptionInfoSupport ex = (IExceptionInfoSupport)list.get(i);
            IExceptionInfoManager manager = ExceptionUtil.getManager(ex);
            if (manager != null) {
                if (ex.getInfoId() != null) {
                    simpleDesc.append(manager.getSimpleDesc(ex));
                    detailDesc.append(manager.getDetailDesc(ex));
                    continue;
                }
                if (!(ex instanceof Throwable)) continue;
                simpleDesc.append(((Throwable)((Object)ex)).getMessage());
                detailDesc.append(((Throwable)((Object)ex)).getMessage());
                continue;
            }
            if (ex.getInfoId() != null) {
                simpleDesc.append("Exception ID:" + ex.getInfoId());
                detailDesc.append("Exception ID:" + ex.getInfoId());
                continue;
            }
            if (!(ex instanceof Throwable)) continue;
            simpleDesc.append(((Throwable)((Object)ex)).getMessage());
            detailDesc.append(((Throwable)((Object)ex)).getMessage());
        }
        message.setSimple(simpleDesc.toString());
        message.setDetail(detailDesc.toString());
        Throwable ex = bind.getCause();
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            message.setStack(sw.toString());
        }
        return message;
    }

    private static IExceptionProcessor getProcesssor(String type) throws InstantiationException, IllegalAccessException {
        if (type == null) {
            return null;
        }
        IExceptionProcessor processor = (IExceptionProcessor)processorCache.get(type = type.toLowerCase());
        if (processor == null) {
            Class cls = (Class)processorClz.get(type);
            if (cls == null) {
                return null;
            }
            processor = (IExceptionProcessor)cls.newInstance();
        }
        return processor;
    }

    public static void process(Throwable exception, String type) {
        if (exception instanceof IExceptionInfoSupport) {
            IExceptionInfoSupport support = (IExceptionInfoSupport)((Object)exception);
            ExceptionUtil.processSupport(support, type);
        } else {
            defLogger.error((Object)exception.getMessage(), exception);
        }
    }

    private static void processSupport(IExceptionInfoSupport bind, String type) {
        Logger logger;
        if (bind == null || bind.getInfoId() == null) {
            return;
        }
        ExceptionMessage message = ExceptionUtil.getMessages(bind);
        String detailDesc = message.getDetail();
        String stackDesc = message.getStack();
        Object target = bind.getTarget();
        Logger logger2 = logger = target == null ? defLogger : Logger.getLogger(target.getClass());
        if (stackDesc == null) {
            logger.warn((Object)detailDesc);
        } else {
            logger.error((Object)(detailDesc + "\n" + stackDesc));
        }
        try {
            IExceptionProcessor processor = ExceptionUtil.getProcesssor(type);
            if (processor != null) {
                processor.process(bind, message);
            }
        }
        catch (Exception ex) {
            defLogger.error((Object)ex);
        }
    }

    public static ExceptionInfo getExceptionInfo(IExceptionInfoSupport bind) {
        if (bind.getInfoId() != null) {
            IExceptionInfoManager manager = ExceptionUtil.getManager(bind);
            if (manager == null) {
                return null;
            }
            return manager.getExceptionInfo(bind);
        }
        return null;
    }

    public static String getShortMsg(IExceptionInfoSupport bind) {
        ExceptionInfo exceptionInfo = ExceptionUtil.getExceptionInfo(bind);
        return exceptionInfo != null ? ExceptionInfoUtil.formatShort(exceptionInfo, bind.getArgs()) : "";
    }

    private static IExceptionInfoManager getManager(Object ex) {
        IExceptionInfoManager manager = (IExceptionInfoManager)managerCache.get(ex.getClass().getName());
        if (manager == null) {
            manager = (IExceptionInfoManager)managerCache.get("*");
        }
        return manager;
    }

    static {
        try {
            String path = System.getProperty(CONFIG_FILE_KEY);
            if (path != null) {
                File file = new File(path);
                if (file.exists() && file.isFile()) {
                    ExceptionUtil.init(new FileInputStream(file));
                }
            } else {
                URL url = ExceptionUtil.class.getResource(CONFIG_FILE_NAME);
                if (url == null) {
                    url = ClassLoader.getSystemResource(CONFIG_FILE_NAME);
                }
                if (url != null) {
                    ExceptionUtil.init(url.openStream());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

