/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.exception;

import com.kingdee.exception.ExceptionInfo;
import com.kingdee.exception.ExceptionInfoUtil;
import com.kingdee.exception.IExceptionInfoManager;
import com.kingdee.exception.IExceptionInfoSupport;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JARExceptionInfoManager
implements IExceptionInfoManager {
    public static final String JAR_PATHS = "JAR_PATHS";
    public static final String CLS_ROOTS = "CLASS_ROOT";
    protected Map localeProperties = new HashMap();
    protected Map exceptionInfos = new HashMap();
    public static final String CLASS_PATH_PRFIX = "%CLASS_PATH%";
    protected String defaultLocale = "l2";
    public static final String CONFIG_FILE = "exceptions.cfg";

    @Override
    public String getSimpleDesc(IExceptionInfoSupport bind) {
        ExceptionInfo info = this.getExceptionInfo(bind);
        if (info == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ExceptionInfoUtil.formatShort(info, bind.getArgs()));
        return sb.toString();
    }

    @Override
    public String getDetailDesc(IExceptionInfoSupport bind) {
        String footer;
        List trys;
        String[] responses;
        Map codes;
        String[] scenes;
        String[] reasons;
        String sInfo = this.getSimpleDesc(bind);
        if (sInfo == null) {
            return null;
        }
        Properties defProp = (Properties)this.localeProperties.get(this.defaultLocale);
        Properties locProp = (Properties)this.localeProperties.get(bind.getLang());
        if (locProp == null) {
            locProp = defProp;
        }
        ExceptionInfo info = this.getExceptionInfo(bind);
        StringBuffer sb = new StringBuffer();
        String header = ExceptionInfoUtil.localeStr("header", locProp, defProp);
        if (header != null && header.trim().length() > 0) {
            sb.append(header + "\n");
        }
        sb.append(sInfo + "\n\n");
        sb.append(ExceptionInfoUtil.localeStr("exception.id", locProp, defProp));
        sb.append(bind.getInfoId().toUpperCase() + "\n");
        sb.append(ExceptionInfoUtil.localeStr("exception.type", locProp, defProp));
        sb.append(info.getType() + "\n");
        sb.append(ExceptionInfoUtil.localeStr("exception.subsystem", locProp, defProp));
        sb.append(info.getSubsystem().toUpperCase() + "\n");
        if (bind.getCode() != null) {
            sb.append(ExceptionInfoUtil.localeStr("exception.code", locProp, defProp));
            sb.append(bind.getCode() + "\n");
        }
        if ((reasons = info.getReasons()) != null && reasons.length > 0) {
            sb.append(ExceptionInfoUtil.localeStr("section.explain", locProp, defProp) + "\n");
            for (int i = 0; i < reasons.length; ++i) {
                sb.append("\t" + reasons[i] + "\n");
            }
        }
        if ((scenes = info.getScenes()) != null && scenes.length > 0) {
            sb.append(ExceptionInfoUtil.localeStr("section.scenes", locProp, defProp) + "\n");
            for (int i = 0; i < scenes.length; ++i) {
                sb.append("\t" + scenes[i] + "\n");
            }
        }
        if ((codes = info.getCodes()) != null && !codes.isEmpty()) {
            sb.append(ExceptionInfoUtil.localeStr("section.codes", locProp, defProp) + "\n");
            for (Object key : codes.keySet()) {
                Object value = codes.get(key);
                sb.append("\t" + key + " : " + value + "\n");
            }
        }
        if ((responses = info.getResponses()) != null && responses.length > 0) {
            sb.append(ExceptionInfoUtil.localeStr("section.response", locProp, defProp) + "\n");
            for (int i = 0; i < responses.length; ++i) {
                sb.append("\t" + responses[i] + "\n");
            }
        }
        if ((trys = info.getTrys()) != null && !trys.isEmpty()) {
            sb.append(ExceptionInfoUtil.localeStr("section.trys", locProp, defProp) + "\n");
            for (int i = 0; i < trys.size(); ++i) {
                List list = (List)trys.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    sb.append("\t" + list.get(j) + "\n");
                }
                sb.append("\n");
            }
        }
        if ((footer = "\n" + ExceptionInfoUtil.localeStr("footer", locProp, defProp)) != null && footer.trim().length() > 0) {
            sb.append(footer);
        }
        return sb.toString();
    }

    @Override
    public ExceptionInfo getExceptionInfo(IExceptionInfoSupport bind) {
        Map exMap;
        if (bind == null) {
            return null;
        }
        String lang = bind.getLang();
        if (lang != null) {
            lang = lang.toLowerCase().trim();
        }
        if ((exMap = (Map)this.exceptionInfos.get(lang)) == null) {
            exMap = (Map)this.exceptionInfos.get(this.defaultLocale);
        }
        if (exMap == null) {
            return null;
        }
        return (ExceptionInfo)exMap.get(bind.getInfoId().toLowerCase());
    }

    @Override
    public void init(Properties props) throws Exception {
        String clsPaths;
        String jarPaths = props.getProperty(JAR_PATHS);
        if (jarPaths != null) {
            String[] paths = jarPaths.split(";");
            for (int i = 0; i < paths.length; ++i) {
                try {
                    this.init(paths[i]);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((clsPaths = props.getProperty(CLS_ROOTS)) != null) {
            String[] paths = clsPaths.split(";");
            for (int i = 0; i < paths.length; ++i) {
                try {
                    this.initWidthClsPath(paths[i]);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void init(String jarPath) throws Exception {
        if (jarPath == null) {
            throw new Exception("Can't find jar path in system properties");
        }
        if (!jarPath.endsWith(".jar")) {
            throw new Exception("jar path must ends with .jar");
        }
        if (jarPath.startsWith(CLASS_PATH_PRFIX)) {
            jarPath = jarPath.substring(CLASS_PATH_PRFIX.length()).trim();
            String[] classPaths = System.getProperty("java.class.path").split(";");
            int index = -1;
            for (int i = 0; i < classPaths.length; ++i) {
                if (!classPaths[i].endsWith("/" + jarPath)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                throw new Exception("Can't find jar in class path, the jar name is " + jarPath);
            }
            jarPath = classPaths[index];
        }
        jarPath = jarPath.toLowerCase();
        this.loadJarFile(jarPath);
    }

    public void initWidthClsPath(String className) throws Exception {
        URL url;
        String rootDirName;
        Class<?> cls = Class.forName(className.trim());
        Properties prop = new Properties();
        URL configUrl = cls.getResource("/exceptions.cfg");
        if ("JAR".equalsIgnoreCase(configUrl.getProtocol())) {
            URL url2 = cls.getClassLoader().getResource(className.replaceAll("\\.", "/") + ".class");
            JarURLConnection jarURLConnection = (JarURLConnection)url2.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            this.loadJarFile(jarFile);
            return;
        }
        prop.load(cls.getResourceAsStream("/exceptions.cfg"));
        String locale = prop.getProperty("locale");
        if (locale != null) {
            this.defaultLocale = locale.toLowerCase();
        }
        if (!(rootDirName = prop.getProperty("root")).startsWith("/")) {
            rootDirName = "/" + rootDirName;
        }
        if ("bundleresource".equals((url = cls.getResource(rootDirName)).getProtocol())) {
            URLConnection connection = url.openConnection();
            Class<?> c = Class.forName("org.eclipse.osgi.framework.internal.core.BundleURLConnection");
            Method m = c.getMethod("getLocalURL", new Class[0]);
            url = (URL)m.invoke((Object)connection, new Object[0]);
        }
        if ("JAR".equalsIgnoreCase(url.getProtocol())) {
            JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            this.loadJarFile(jarFile);
        } else {
            String root = url.getFile();
            this.parseFile(root);
        }
    }

    private void parseFile(String dir) throws Exception {
        File root = new File(dir);
        String[] files = root.list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            File file = new File(root.getAbsoluteFile() + File.separator + files[i]);
            if (file.isDirectory()) {
                try {
                    this.parseFile(file.getAbsolutePath());
                }
                catch (Exception ex) {}
                continue;
            }
            if (filename.endsWith(".properties")) {
                try {
                    ExceptionInfoUtil.processLocaleProperties(this.localeProperties, new FileInputStream(file));
                }
                catch (Exception ex) {}
                continue;
            }
            if (!filename.endsWith(".xml")) continue;
            try {
                ExceptionInfoUtil.processXML(this.exceptionInfos, new FileInputStream(file));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void loadJarFile(String path) throws Exception {
        JarFile jarFile = new JarFile(path);
        this.loadJarFile(jarFile);
    }

    private void loadJarFile(JarFile jarFile) throws Exception {
        String prefix;
        JarEntry cfgEntry = jarFile.getJarEntry(CONFIG_FILE);
        if (cfgEntry == null) {
            return;
        }
        Properties cfgProps = new Properties();
        cfgProps.load(jarFile.getInputStream(cfgEntry));
        String locale = cfgProps.getProperty("locale");
        if (locale != null) {
            this.defaultLocale = locale.toLowerCase();
        }
        if ((prefix = cfgProps.getProperty("root")) == null) {
            prefix = "";
        } else if (!prefix.endsWith("/")) {
            prefix = prefix.trim() + "/";
        }
        Enumeration<JarEntry> enu = jarFile.entries();
        while (enu.hasMoreElements()) {
            JarEntry entry = enu.nextElement();
            String name = entry.getName();
            long size = entry.getSize();
            if (size == 0L || !name.startsWith(prefix)) continue;
            if (name.endsWith(".properties")) {
                try {
                    ExceptionInfoUtil.processLocaleProperties(this.localeProperties, jarFile.getInputStream(entry));
                }
                catch (Exception ex) {}
                continue;
            }
            if (!name.endsWith(".xml")) continue;
            try {
                ExceptionInfoUtil.processXML(this.exceptionInfos, jarFile.getInputStream(entry));
            }
            catch (Exception ex) {}
        }
    }
}

