/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.jdbc.rowset.ColumnInaccessibleException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.AbstractRow;
import com.kingdee.jdbc.rowset.impl.Row;
import com.kingdee.jdbc.rowset.impl.RowSetMetaDataImpl;
import com.kingdee.jdbc.rowset.impl.SQLInputImpl;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

abstract class AbstractRowSet
implements IRowSet,
Cloneable {
    protected IRowSetMetaData rowSetMD;
    protected ArrayList cachedRows;
    protected int cursorPos;
    protected int absolutePos;
    protected int numRows;
    protected int currentRow;
    private transient boolean lastValueNull;
    private transient ArrayList listeners = new ArrayList();

    public AbstractRowSet() {
        this.initContainer();
    }

    private void initContainer() {
        this.cachedRows = new ArrayList(16);
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
    }

    @Override
    public void close() throws SQLException {
        this.release();
    }

    private void release() {
        this.initContainer();
        this.notifyRowSetChanged();
        this.listeners = null;
    }

    @Override
    public void addRowSetListener(RowSetListener rowsetlistener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.add(rowsetlistener);
    }

    @Override
    public void removeRowSetListener(RowSetListener rowsetlistener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(rowsetlistener);
    }

    protected void notifyCursorMoved() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            RowSetEvent rowsetevent = new RowSetEvent(this);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).cursorMoved(rowsetevent);
            }
        }
    }

    protected void notifyRowChanged() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            RowSetEvent rowsetevent = new RowSetEvent(this);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowChanged(rowsetevent);
            }
        }
    }

    protected void notifyRowSetChanged() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            RowSetEvent rowsetevent = new RowSetEvent(this);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowSetChanged(rowsetevent);
            }
        }
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public void setType(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public void setConcurrency(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Map getTypeMap() {
        return null;
    }

    public void setTypeMap(Map typeMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public void setPassword(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getEscapeProcessing() throws SQLException {
        return true;
    }

    @Override
    public void setEscapeProcessing(boolean flag) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean flag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUsername() {
        return null;
    }

    @Override
    public void setUsername(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUrl() throws SQLException {
        return null;
    }

    @Override
    public void setUrl(String s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDataSourceName() {
        return null;
    }

    @Override
    public void setDataSourceName(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected AbstractRow getCurrentRow() {
        return (Row)this.cachedRows.get(this.cursorPos - 1);
    }

    @Override
    public int findColumn(String s) throws SQLException {
        return this.getColIdxByName(s);
    }

    protected int getColIdxByName(String s) throws SQLException {
        int i = this.rowSetMD.getColumnCount();
        for (int j = 1; j <= i; ++j) {
            String s1 = this.rowSetMD.getColumnName(j);
            if (s1 == null || !s.equalsIgnoreCase(s1)) continue;
            return j;
        }
        throw new SQLException("Invalid column name: " + s);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowSetMD;
    }

    @Override
    public IRowSetMetaData getRowSetMetaData() throws SQLException {
        return this.rowSetMD;
    }

    @Override
    public int size() {
        return this.numRows;
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(i) != 2003) {
            throw new SQLException("Datatype Mismatch");
        }
        this.setLastValueNull(false);
        Array array = (Array)this.getCurrentRow().getColumnObject(i);
        if (array == null) {
            this.setLastValueNull(true);
            return null;
        }
        return array;
    }

    @Override
    public Array getArray(String s) throws SQLException {
        return this.getArray(this.getColIdxByName(s));
    }

    @Override
    public InputStream getAsciiStream(int i) throws SQLException {
        ByteArrayInputStream asciiStream = null;
        this.checkIndex(i);
        this.checkCursor();
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.lastValueNull = true;
            return null;
        }
        try {
            if (!this.isString(this.rowSetMD.getColumnType(i))) {
                throw new SQLException("Data type mismatch");
            }
            asciiStream = new ByteArrayInputStream(((String)obj).getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedencodingexception) {
            throw new SQLException(unsupportedencodingexception.getMessage());
        }
        return asciiStream;
    }

    @Override
    public InputStream getAsciiStream(String s) throws SQLException {
        return this.getAsciiStream(this.getColIdxByName(s));
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return TypeConversionUtils.objToBigDecimal(obj);
        }
        catch (IllegalConversionException _ex) {
            throw new SQLException("getBigDecimal Failed on value (" + obj.toString().trim() + ") in column " + i);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int i, int j) throws SQLException {
        return this.getBigDecimal(i).setScale(j);
    }

    @Override
    public BigDecimal getBigDecimal(String s) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(s));
    }

    @Override
    public BigDecimal getBigDecimal(String s, int i) throws SQLException {
        return this.getBigDecimal(this.getColIdxByName(s), i);
    }

    @Override
    public InputStream getBinaryStream(int i) throws SQLException {
        ByteArrayInputStream binaryStream = null;
        this.checkIndex(i);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(i))) {
            throw new SQLException("Data Type Mismatch");
        }
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.lastValueNull = true;
            return null;
        }
        binaryStream = new ByteArrayInputStream((byte[])obj);
        return binaryStream;
    }

    @Override
    public InputStream getBinaryStream(String s) throws SQLException {
        return this.getBinaryStream(this.getColIdxByName(s));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(i) != 2004) {
            throw new SQLException("Datatype Mismatch");
        }
        this.setLastValueNull(false);
        Blob blob = (Blob)this.getCurrentRow().getColumnObject(i);
        if (blob == null) {
            this.setLastValueNull(true);
            return null;
        }
        return blob;
    }

    @Override
    public Blob getBlob(String s) throws SQLException {
        return this.getBlob(this.getColIdxByName(s));
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        try {
            Double dbl = new Double(obj.toString());
            return dbl.compareTo(new Double(0.0)) != 0;
        }
        catch (NumberFormatException _ex) {
            throw new SQLException("getBoolen Failed on value (" + obj.toString().trim() + ") in column " + i);
        }
    }

    @Override
    public boolean getBoolean(String s) throws SQLException {
        return this.getBoolean(this.getColIdxByName(s));
    }

    @Override
    public byte getByte(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return new Byte(obj.toString());
        }
        catch (NumberFormatException _ex) {
            throw new SQLException("getByte Failed on value (" + obj.toString() + ") in column " + i);
        }
    }

    @Override
    public byte getByte(String s) throws SQLException {
        return this.getByte(this.getColIdxByName(s));
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(i))) {
            throw new SQLException("Data Type Mismatch");
        }
        return (byte[])this.getCurrentRow().getColumnObject(i);
    }

    @Override
    public byte[] getBytes(String s) throws SQLException {
        return this.getBytes(this.getColIdxByName(s));
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        Reader charStream;
        this.checkIndex(i);
        this.checkCursor();
        if (this.isBinary(this.rowSetMD.getColumnType(i))) {
            Object obj = this.getCurrentRow().getColumnObject(i);
            if (obj == null) {
                this.lastValueNull = true;
                return null;
            }
            charStream = new InputStreamReader(new ByteArrayInputStream((byte[])obj));
        } else if (this.isString(this.rowSetMD.getColumnType(i))) {
            Object obj1 = this.getCurrentRow().getColumnObject(i);
            if (obj1 == null) {
                this.lastValueNull = true;
                return null;
            }
            charStream = new StringReader(obj1.toString());
        } else {
            throw new SQLException("Datatye mismatch");
        }
        return charStream;
    }

    @Override
    public Reader getCharacterStream(String s) throws SQLException {
        return this.getCharacterStream(this.getColIdxByName(s));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(i) != 2005) {
            throw new SQLException("Datatype Mismatch");
        }
        this.setLastValueNull(false);
        Clob clob = (Clob)this.getCurrentRow().getColumnObject(i);
        if (clob == null) {
            this.setLastValueNull(true);
            return null;
        }
        return clob;
    }

    @Override
    public Clob getClob(String s) throws SQLException {
        return this.getClob(this.getColIdxByName(s));
    }

    @Override
    public Date getDate(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return TypeConversionUtils.objToDate(obj);
        }
        catch (InvalidDateException ide) {
            throw new SQLException("getDate Failed on value (" + obj.toString().trim() + ") in column " + i + "no conversion available");
        }
        catch (IllegalConversionException ice) {
            throw new SQLException("getDate Failed on value (" + obj.toString().trim() + ") in column " + i + "no conversion available");
        }
    }

    @Override
    public Date getDate(int i, Calendar calendar) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        obj = this.convertTemporal(obj, this.rowSetMD.getColumnType(i), 91);
        Calendar cal = Calendar.getInstance();
        cal.setTime((java.util.Date)obj);
        calendar.set(1, cal.get(1));
        calendar.set(2, cal.get(2));
        calendar.set(5, cal.get(5));
        return new Date(calendar.getTime().getTime());
    }

    @Override
    public Date getDate(String s) throws SQLException {
        return this.getDate(this.getColIdxByName(s));
    }

    @Override
    public Date getDate(String s, Calendar calendar) throws SQLException {
        return this.getDate(this.getColIdxByName(s), calendar);
    }

    @Override
    public double getDouble(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return 0.0;
        }
        try {
            return TypeConversionUtils.objToDouble(obj);
        }
        catch (IllegalConversionException _ex) {
            throw new SQLException("getDouble Failed on value (" + obj.toString().trim() + ") in column " + i);
        }
    }

    @Override
    public double getDouble(String s) throws SQLException {
        return this.getDouble(this.getColIdxByName(s));
    }

    @Override
    public float getFloat(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return 0.0f;
        }
        try {
            return TypeConversionUtils.objToFloat(obj);
        }
        catch (IllegalConversionException _ex) {
            throw new SQLException("getFloat Failed on value (" + obj.toString().trim() + ") in column " + i);
        }
    }

    @Override
    public float getFloat(String s) throws SQLException {
        return this.getFloat(this.getColIdxByName(s));
    }

    @Override
    public int getInt(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return TypeConversionUtils.objToInt(obj);
        }
        catch (IllegalConversionException _ex) {
            throw new SQLException("getInt Failed on value (" + obj.toString().trim() + ") in column " + i);
        }
    }

    @Override
    public int getInt(String s) throws SQLException {
        return this.getInt(this.getColIdxByName(s));
    }

    @Override
    public long getLong(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return 0L;
        }
        try {
            return TypeConversionUtils.objToLong(obj);
        }
        catch (IllegalConversionException _ex) {
            throw new SQLException("getLong Failed on value (" + obj.toString().trim() + ") in column " + i);
        }
    }

    @Override
    public long getLong(String s) throws SQLException {
        return this.getLong(this.getColIdxByName(s));
    }

    @Override
    public Object getObject(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (obj instanceof Struct) {
            Struct struct = (Struct)obj;
            Map map = this.getTypeMap();
            Class class1 = (Class)map.get(struct.getSQLTypeName());
            if (class1 != null) {
                SQLData sqldata = null;
                try {
                    sqldata = (SQLData)class1.newInstance();
                }
                catch (InstantiationException instantiationexception) {
                    throw new SQLException("Unable to instantiate: " + instantiationexception.getMessage());
                }
                catch (IllegalAccessException illegalaccessexception) {
                    throw new SQLException("Unable to instantiate: " + illegalaccessexception.getMessage());
                }
                Object[] aobj = struct.getAttributes(map);
                SQLInputImpl sqlinputimpl = new SQLInputImpl(aobj, map);
                sqldata.readSQL(sqlinputimpl, struct.getSQLTypeName());
                return sqldata;
            }
        }
        return obj;
    }

    public Object getObject(int i, Map map) throws SQLException {
        Struct struct;
        Class class1;
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        if (obj instanceof Struct && (class1 = (Class)map.get((struct = (Struct)obj).getSQLTypeName())) != null) {
            SQLData sqldata = null;
            try {
                sqldata = (SQLData)class1.newInstance();
            }
            catch (InstantiationException instantiationexception) {
                throw new SQLException("Unable to instantiate: " + instantiationexception.getMessage());
            }
            catch (IllegalAccessException illegalaccessexception) {
                throw new SQLException("Unable to instantiate: " + illegalaccessexception.getMessage());
            }
            Object[] aobj = struct.getAttributes(map);
            SQLInputImpl sqlinputimpl = new SQLInputImpl(aobj, map);
            sqldata.readSQL(sqlinputimpl, struct.getSQLTypeName());
            return sqldata;
        }
        return obj;
    }

    @Override
    public Object getObject(String s) throws SQLException {
        return this.getObject(this.getColIdxByName(s));
    }

    public Object getObject(String s, Map map) throws SQLException {
        return this.getObject(this.getColIdxByName(s), map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        if (this.rowSetMD.getColumnType(i) != 2006) {
            throw new SQLException("Datatype Mismatch");
        }
        this.setLastValueNull(false);
        Ref ref = (Ref)this.getCurrentRow().getColumnObject(i);
        if (ref == null) {
            this.setLastValueNull(true);
            return null;
        }
        return ref;
    }

    @Override
    public Ref getRef(String s) throws SQLException {
        return this.getRef(this.getColIdxByName(s));
    }

    @Override
    public int getRow() throws SQLException {
        if (this.numRows > 0 && this.cursorPos > 0 && this.cursorPos < this.numRows + 1) {
            return this.cursorPos;
        }
        return 0;
    }

    @Override
    public short getShort(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return 0;
        }
        try {
            return TypeConversionUtils.objToShort(obj);
        }
        catch (IllegalConversionException _ex) {
            throw new SQLException("getShort Failed on value (" + obj.toString().trim() + ") in column " + i);
        }
    }

    @Override
    public short getShort(String s) throws SQLException {
        return this.getShort(this.getColIdxByName(s));
    }

    @Override
    public String getString(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        return obj.toString();
    }

    @Override
    public String getString(String s) throws SQLException {
        return this.getString(this.getColIdxByName(s));
    }

    @Override
    public Time getTime(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return TypeConversionUtils.objToTime(obj);
        }
        catch (InvalidDateException ide) {
            throw new SQLException("getTime Failed on value (" + obj.toString().trim() + ") in column " + i + "no conversion available");
        }
        catch (IllegalConversionException ice) {
            throw new SQLException("getTime Failed on value (" + obj.toString().trim() + ") in column " + i + "no conversion available");
        }
    }

    @Override
    public Time getTime(int i, Calendar calendar) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        obj = this.convertTemporal(obj, this.rowSetMD.getColumnType(i), 92);
        Calendar cal = Calendar.getInstance();
        cal.setTime((java.util.Date)obj);
        calendar.set(11, cal.get(11));
        calendar.set(12, cal.get(12));
        calendar.set(13, cal.get(13));
        return new Time(calendar.getTime().getTime());
    }

    @Override
    public Time getTime(String s) throws SQLException {
        return this.getTime(this.getColIdxByName(s));
    }

    @Override
    public Time getTime(String s, Calendar calendar) throws SQLException {
        return this.getTime(this.getColIdxByName(s), calendar);
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        try {
            return TypeConversionUtils.objToTimestamp(obj);
        }
        catch (InvalidDateException ide) {
            throw new SQLException("getTimestamp Failed on value (" + obj.toString().trim() + ") in column " + i + "no conversion available");
        }
        catch (IllegalConversionException ice) {
            throw new SQLException("getTimestamp Failed on value (" + obj.toString().trim() + ") in column " + i + "no conversion available");
        }
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
        this.checkIndex(i);
        this.checkCursor();
        this.setLastValueNull(false);
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.setLastValueNull(true);
            return null;
        }
        obj = this.convertTemporal(obj, this.rowSetMD.getColumnType(i), 93);
        Calendar cal = Calendar.getInstance();
        cal.setTime((java.util.Date)obj);
        calendar.set(1, cal.get(1));
        calendar.set(2, cal.get(2));
        calendar.set(5, cal.get(5));
        calendar.set(11, cal.get(11));
        calendar.set(12, cal.get(12));
        calendar.set(13, cal.get(13));
        return new Timestamp(calendar.getTime().getTime());
    }

    @Override
    public Timestamp getTimestamp(String s) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(s));
    }

    @Override
    public Timestamp getTimestamp(String s, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColIdxByName(s), calendar);
    }

    @Override
    public InputStream getUnicodeStream(int i) throws SQLException {
        StringBufferInputStream unicodeStream = null;
        this.checkIndex(i);
        this.checkCursor();
        if (!this.isBinary(this.rowSetMD.getColumnType(i)) && !this.isString(this.rowSetMD.getColumnType(i))) {
            throw new SQLException("Data Type Mismatch");
        }
        Object obj = this.getCurrentRow().getColumnObject(i);
        if (obj == null) {
            this.lastValueNull = true;
            return null;
        }
        unicodeStream = new StringBufferInputStream(obj.toString());
        return unicodeStream;
    }

    @Override
    public InputStream getUnicodeStream(String s) throws SQLException {
        return this.getUnicodeStream(this.getColIdxByName(s));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueNull;
    }

    protected void checkIndex(int i) throws SQLException {
        if (i < 1 || i > this.rowSetMD.getColumnCount()) {
            throw new SQLException("Invalid column index");
        }
        if (((RowSetMetaDataImpl)this.rowSetMD).isInaccessible(i)) {
            throw new ColumnInaccessibleException();
        }
    }

    protected void checkCursor() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException("Invalid cursor position");
        }
    }

    private void setLastValueNull(boolean flag) {
        this.lastValueNull = flag;
    }

    protected boolean isBinary(int i) {
        switch (i) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    protected boolean isNumeric(int i) {
        return i == -7 || i == -6 || i == -5 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8;
    }

    protected boolean isTemporal(int i) {
        return i == 91 || i == 92 || i == 93;
    }

    protected boolean isString(int i) {
        return i == -1 || i == 1 || i == 12;
    }

    protected Object convertTemporal(Object obj, int orgType, int destType) throws SQLException {
        if (orgType == destType) {
            return obj;
        }
        if (this.isNumeric(destType) || !this.isString(destType) && !this.isTemporal(destType)) {
            throw new SQLException("Datatype Mismatch");
        }
        try {
            switch (destType) {
                case 91: {
                    return TypeConversionUtils.objToDate(obj);
                }
                case 93: {
                    return TypeConversionUtils.objToTimestamp(obj);
                }
                case 92: {
                    return TypeConversionUtils.objToTime(obj);
                }
                case -1: 
                case 1: 
                case 12: {
                    return obj.toString();
                }
            }
            throw new SQLException("Data Type Mismatch");
        }
        catch (InvalidDateException ide) {
            throw new SQLException("Data Type Mismatch");
        }
        catch (IllegalConversionException ice) {
            throw new SQLException("Data Type Mismatch");
        }
    }

    @Override
    public boolean absolute(int i) throws SQLException {
        int toPos;
        if (i > 0) {
            if (i > this.numRows) {
                this.afterLast();
                return false;
            }
            if (this.absolutePos <= 0) {
                this.internalFirst();
            }
            toPos = i;
        } else {
            if (this.numRows + i < 0) {
                this.beforeFirst();
                return false;
            }
            if (this.absolutePos > this.numRows) {
                this.internalLast();
            }
            toPos = this.numRows + i + 1;
        }
        while (this.absolutePos != toPos && !(this.absolutePos >= toPos ? !this.internalPrevious() : !this.internalNext())) {
        }
        this.notifyCursorMoved();
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.numRows > 0) {
            this.cursorPos = this.numRows + 1;
            this.absolutePos = 0;
            this.notifyCursorMoved();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.notifyCursorMoved();
    }

    @Override
    public boolean first() throws SQLException {
        boolean flag = this.internalFirst();
        this.notifyCursorMoved();
        return flag;
    }

    @Override
    public boolean last() throws SQLException {
        boolean flag = this.internalLast();
        this.notifyCursorMoved();
        return flag;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new SQLException("Invalid Cursor position");
        }
        boolean flag = this.internalNext();
        this.notifyCursorMoved();
        return flag;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new SQLException("Invalid Cursor position");
        }
        boolean flag = this.internalPrevious();
        this.notifyCursorMoved();
        return flag;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.cursorPos = this.currentRow;
    }

    @Override
    public boolean relative(int i) throws SQLException {
        if (this.numRows == 0 || this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException("relative: Invalid cursor operation");
        }
        if (i == 0) {
            return true;
        }
        if (i > 0) {
            if (this.cursorPos + i > this.numRows) {
                this.afterLast();
            } else {
                for (int j = 0; j < i && this.internalNext(); ++j) {
                }
            }
        } else if (this.cursorPos + i < 0) {
            this.beforeFirst();
        } else {
            for (int k = -i; k > 0 && this.internalPrevious(); --k) {
            }
        }
        this.notifyCursorMoved();
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    protected boolean internalFirst() {
        boolean flag = false;
        if (this.numRows > 0) {
            this.cursorPos = 1;
            flag = true;
        }
        this.absolutePos = flag ? 1 : 0;
        return flag;
    }

    protected boolean internalLast() {
        boolean flag = false;
        if (this.numRows > 0) {
            this.cursorPos = this.numRows;
            flag = true;
        }
        this.absolutePos = flag ? this.numRows : 0;
        return flag;
    }

    protected boolean internalNext() {
        boolean flag = false;
        if (this.cursorPos < this.numRows) {
            ++this.cursorPos;
            flag = true;
        } else if (this.cursorPos == this.numRows) {
            ++this.cursorPos;
            flag = false;
        }
        this.absolutePos = flag ? ++this.absolutePos : 0;
        return flag;
    }

    protected boolean internalPrevious() {
        boolean flag = false;
        if (this.cursorPos > 1) {
            --this.cursorPos;
            flag = true;
        } else if (this.cursorPos == 1) {
            --this.cursorPos;
            flag = false;
        }
        this.absolutePos = flag ? --this.absolutePos : 0;
        return flag;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        int i = this.cursorPos;
        int j = this.absolutePos;
        this.internalFirst();
        if (this.cursorPos == i) {
            return true;
        }
        this.cursorPos = i;
        this.absolutePos = j;
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        int i = this.cursorPos;
        int j = this.absolutePos;
        this.internalLast();
        if (this.cursorPos == i) {
            return true;
        }
        this.cursorPos = i;
        this.absolutePos = j;
        return false;
    }

    @Override
    public IRowSet createCopy() throws SQLException {
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(baOut);
            objOut.writeObject(this);
            ByteArrayInputStream baIn = new ByteArrayInputStream(baOut.toByteArray());
            ObjectInputStream objIn = new ObjectInputStream(baIn);
            return (IRowSet)objIn.readObject();
        }
        catch (IOException ioe) {
            throw new SQLException("Clone failed: " + ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("Clone failed: " + cnfe.getMessage());
        }
    }

    @Override
    public IRowSet createShared() throws SQLException {
        try {
            return (IRowSet)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new SQLException(cnse.getMessage());
        }
    }

    @Override
    public Collection toCollection() throws SQLException {
        int i = 0;
        int j = this.rowSetMD.getColumnCount();
        ArrayList vecRows = new ArrayList();
        Iterator iterator = this.cachedRows.iterator();
        while (iterator.hasNext()) {
            Vector<Object> vector = new Vector<Object>(j);
            Row row = (Row)iterator.next();
            for (int k = 1; k <= j; ++k) {
                vector.add(row.getColumnObject(k));
            }
            vecRows.add(vector);
            ++i;
        }
        return vecRows;
    }

    @Override
    public Collection toCollection(int i) throws SQLException {
        ArrayList<Object> vector = new ArrayList<Object>(this.numRows);
        for (Row row : this.cachedRows) {
            vector.add(row.getColumnObject(i));
        }
        return vector;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean swap(int row1, int row2) {
        int r1 = row1 - 1;
        int r2 = row2 - 1;
        if (r1 < 0 || r1 >= this.numRows || r2 < 1 || r2 >= this.numRows) {
            return false;
        }
        if (r1 == r2) {
            return true;
        }
        Object obj2 = this.cachedRows.get(r2);
        this.cachedRows.set(r2, this.cachedRows.get(r1));
        this.cachedRows.set(r1, obj2);
        this.notifyRowSetChanged();
        return true;
    }

    private boolean[] initUuidTags() throws SQLException {
        int numCols = this.rowSetMD.getColumnCount();
        boolean[] maybeUuid = new boolean[numCols];
        for (int j = 1; j <= numCols; ++j) {
            int sqlType = this.rowSetMD.getColumnType(j);
            if (sqlType != 1 && sqlType != 12 && sqlType != -1) continue;
            maybeUuid[j - 1] = true;
        }
        return maybeUuid;
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        try {
            boolean isRowSetMDNull = this.rowSetMD == null;
            marshaller.writeBoolean(isRowSetMDNull);
            if (!isRowSetMDNull) {
                this.rowSetMD.marshal(marshaller);
            }
            int numCols = this.rowSetMD.getColumnCount();
            marshaller.writeInt(this.numRows);
            boolean[] maybeUuid = this.initUuidTags();
            for (int i = 0; i < this.numRows; ++i) {
                Row row = (Row)this.cachedRows.get(i);
                for (int j = 1; j <= numCols; ++j) {
                    Object val = row.getColumnObject(j);
                    if (maybeUuid[j - 1] && val != null && !"".equals(val)) {
                        try {
                            val = BOSUuid.read(val.toString());
                        }
                        catch (Exception ex) {
                            maybeUuid[j - 1] = false;
                        }
                    }
                    marshaller.writeObject(val);
                }
            }
            marshaller.writeInt(this.cursorPos);
            marshaller.writeInt(this.absolutePos);
            marshaller.writeInt(this.currentRow);
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getClass().getName() + " - " + sqle.getMessage());
        }
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        try {
            boolean isRowSetMDNull = unmarshaller.readBoolean();
            if (!isRowSetMDNull) {
                this.rowSetMD = new RowSetMetaDataImpl();
                this.rowSetMD.unmarshal(unmarshaller);
            }
            int numCols = this.rowSetMD.getColumnCount();
            this.numRows = unmarshaller.readInt();
            for (int i = 0; i < this.numRows; ++i) {
                Row row = new Row(numCols);
                for (int j = 1; j <= numCols; ++j) {
                    Object val = unmarshaller.readObject();
                    if (val instanceof BOSUuid) {
                        val = val.toString();
                    }
                    row.initColumnObject(j, val);
                }
                this.cachedRows.add(row);
            }
            this.cursorPos = unmarshaller.readInt();
            this.absolutePos = unmarshaller.readInt();
            this.currentRow = unmarshaller.readInt();
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getClass().getName() + " - " + sqle.getMessage());
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate(this).readExternal(in);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate(this).writeExternal(out);
    }

    Object getFieldValue(int i, int j) throws SQLException {
        return ((Row)this.cachedRows.get(i - 1)).getColumnObject(j);
    }
}

