/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.jdbc.rowset.impl;

import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.jdbc.rowset.impl.SerialClob;
import com.kingdee.jdbc.rowset.impl.SerialStruct;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

public class SerialArray
implements Array,
IMarshalObject,
Cloneable {
    private Object[] elements;
    private int baseType;
    private String baseTypeName;
    private int len;

    SerialArray(Array array, Map map) throws SQLException {
        this.elements = (Object[])array.getArray(map);
        this.baseType = this.getBaseType();
        this.baseTypeName = this.getBaseTypeName();
        this.len = this.elements.length;
        switch (this.baseType) {
            case 2002: {
                for (int i = 0; i < this.len; ++i) {
                    this.elements[i] = new SerialStruct((Struct)this.elements[i], map);
                }
                break;
            }
            case 2003: {
                for (int j = 0; j < this.len; ++j) {
                    this.elements[j] = new SerialArray((Array)this.elements[j], map);
                }
                break;
            }
            case 2004: {
                for (int k = 0; k < this.len; ++k) {
                    this.elements[k] = new SerialBlob((Blob)this.elements[k]);
                }
                break;
            }
            case 2005: {
                for (int l = 0; l < this.len; ++l) {
                    this.elements[l] = new SerialClob((Clob)this.elements[l]);
                }
                break;
            }
        }
    }

    @Override
    public Object getArray() throws SQLException {
        Object[] aobj = new Object[this.len];
        System.arraycopy(this.elements, 0, aobj, 0, this.len);
        return aobj;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        Object[] aobj = new Object[count];
        System.arraycopy(this.elements, (int)index, aobj, 0, count);
        return aobj;
    }

    public Object getArray(long l, int i, Map map) throws SQLException {
        Object[] aobj = new Object[i];
        System.arraycopy(this.elements, (int)l, aobj, 0, i);
        return aobj;
    }

    public Object getArray(Map map) throws SQLException {
        Object[] aobj = new Object[this.len];
        System.arraycopy(this.elements, 0, aobj, 0, this.len);
        return aobj;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.baseTypeName;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long l, int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(long l, int i, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object clone() throws CloneNotSupportedException {
        SerialArray array = (SerialArray)super.clone();
        array.elements = (Object[])this.elements.clone();
        array.baseType = this.baseType;
        array.baseTypeName = this.baseTypeName.intern();
        array.len = this.len;
        return array;
    }

    public SerialArray() {
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeInt(this.baseType);
        marshaller.writeObject(this.baseTypeName);
        marshaller.writeInt(this.len);
        for (int i = 0; i < this.len; ++i) {
            marshaller.writeObject(this.elements[i]);
        }
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.baseType = unmarshaller.readInt();
        this.baseTypeName = (String)unmarshaller.readObject();
        this.len = unmarshaller.readInt();
        this.elements = new Object[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.elements[i] = unmarshaller.readObject();
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate(this).readExternal(in);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate(this).writeExternal(out);
    }

    @Override
    public void free() throws SQLException {
    }
}

