/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.bos.BOSException;
import com.kingdee.util.InnerObjectInputStream;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ObjectUtils {
    public static Object[] toObjectArray(Object obj) {
        return new Object[]{obj};
    }

    public static Object[] toObjectArray(Object obj1, Object obj2) {
        return new Object[]{obj1, obj2};
    }

    public static Object[] toObjectArray(Object obj1, Object obj2, Object obj3) {
        return new Object[]{obj1, obj2, obj3};
    }

    public static Object createCopy(Object o) throws CloneNotSupportedException {
        if (!Serializable.class.isAssignableFrom(o.getClass())) {
            throw new CloneNotSupportedException();
        }
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(baOut);
            objOut.writeObject(o);
            ByteArrayInputStream baIn = new ByteArrayInputStream(baOut.toByteArray());
            InnerObjectInputStream objIn = new InnerObjectInputStream(baIn, o.getClass().getClassLoader());
            return objIn.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public static Class getArgumentTypeClass(String argumentType) throws BOSException {
        boolean isArray = false;
        if (argumentType.indexOf("[") > 0 && argumentType.indexOf("]") > 0) {
            isArray = true;
            argumentType = argumentType.replace('[', ' ');
            argumentType = argumentType.replace(']', ' ');
        }
        argumentType = argumentType.trim();
        Class<Comparable<Integer>> returnClass = null;
        try {
            if (!isArray) {
                returnClass = StringUtils.equalsIgnoreCase(argumentType, "integer") ? Integer.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "short") ? Short.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "int") ? Integer.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "long") ? Long.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "float") ? Float.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "double") ? Double.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "char") ? Character.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "boolean") ? Boolean.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "byte") ? Byte.TYPE : (StringUtils.equalsIgnoreCase(argumentType, "bigdecimal") ? Class.forName("java.math.BigDecimal") : (StringUtils.equalsIgnoreCase(argumentType, "date") ? Class.forName("java.sql.Date") : (StringUtils.equalsIgnoreCase(argumentType, "time") ? Class.forName("java.sql.Time") : (StringUtils.equalsIgnoreCase(argumentType, "timestamp") ? Class.forName("java.sql.Timestamp") : (StringUtils.equalsIgnoreCase(argumentType, "string") ? Class.forName("java.lang.String") : (StringUtils.equalsIgnoreCase(argumentType, "bosuuid") ? Class.forName("com.kingdee.bos.util.BOSUuid") : (StringUtils.equalsIgnoreCase(argumentType, "uuid") ? Class.forName("com.kingdee.util.Uuid") : (StringUtils.equalsIgnoreCase(argumentType, "enum") ? Class.forName("com.kingdee.util.enums.Enum") : (StringUtils.equalsIgnoreCase(argumentType, "ObjectPK") || StringUtils.equalsIgnoreCase(argumentType, "IObjectPK") ? Class.forName("com.kingdee.bos.dao.IObjectPK") : Class.forName(argumentType))))))))))))))))));
            } else {
                if (StringUtils.equalsIgnoreCase(argumentType, "integer")) {
                    returnClass = int[].class;
                }
                returnClass = StringUtils.equalsIgnoreCase(argumentType, "short") ? short[].class : (StringUtils.equalsIgnoreCase(argumentType, "int") ? int[].class : (StringUtils.equalsIgnoreCase(argumentType, "long") ? long[].class : (StringUtils.equalsIgnoreCase(argumentType, "float") ? float[].class : (StringUtils.equalsIgnoreCase(argumentType, "double") ? double[].class : (StringUtils.equalsIgnoreCase(argumentType, "char") ? char[].class : (StringUtils.equalsIgnoreCase(argumentType, "boolean") ? boolean[].class : (StringUtils.equalsIgnoreCase(argumentType, "byte") ? byte[].class : (StringUtils.equalsIgnoreCase(argumentType, "bigdecimal") ? Class.forName("[Ljava.math.BigDecimal;") : (StringUtils.equalsIgnoreCase(argumentType, "date") ? Class.forName("[Ljava.sql.Date;") : (StringUtils.equalsIgnoreCase(argumentType, "time") ? Class.forName("[Ljava.sql.Time;") : (StringUtils.equalsIgnoreCase(argumentType, "timestamp") ? Class.forName("[Ljava.sql.Timestamp;") : (StringUtils.equalsIgnoreCase(argumentType, "string") ? Class.forName("[Ljava.lang.String;") : (StringUtils.equalsIgnoreCase(argumentType, "bosuuid") ? Class.forName("[Lcom.kingdee.bos.util.BOSUuid;") : (StringUtils.equalsIgnoreCase(argumentType, "uuid") ? Class.forName("[Lcom.kingdee.util.Uuid;") : (StringUtils.equalsIgnoreCase(argumentType, "enum") ? Class.forName("[Lcom.kingdee.util.enum.Enum;") : (StringUtils.equalsIgnoreCase(argumentType, "ObjectPK") || StringUtils.equalsIgnoreCase(argumentType, "IObjectPK") ? Class.forName("[Lcom.kingdee.bos.dao.IObjectPK;") : Class.forName("[L" + argumentType + ";")))))))))))))))));
            }
            return returnClass;
        }
        catch (ClassNotFoundException e) {
            throw new BOSException(e.getMessage());
        }
    }
}

