/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ResourceBundleUtil {
    private static Logger logger = Logger.getLogger(ResourceBundleUtil.class);
    public static final String BOSResourceBundle_PATH = "BOSResourceBundle.path";
    private static String DEFAULT_FILE = "BOSResourceBundle.xml";
    private static String ORMRPC_CONFIG = "ormrpc.config";
    private static boolean enable = true;
    private static boolean lookupByDefault = true;
    private static Map knf = new HashMap();
    private static Map vnf = new HashMap();

    private static void init() throws Exception {
        List locales;
        Document doc;
        Element root;
        String config = System.getProperty(BOSResourceBundle_PATH);
        if (StringUtils.isEmpty(config)) {
            String home = System.getProperty("EAS_HOME");
            String rpcConfig = System.getProperty(ORMRPC_CONFIG);
            config = rpcConfig != null && rpcConfig.toLowerCase().indexOf("client") > 0 || home != null && home.toLowerCase().indexOf("client") > 0 ? home + "/client/deploy/client/" + DEFAULT_FILE : home + "/server/properties/" + DEFAULT_FILE;
        }
        if ("false".equalsIgnoreCase((root = (doc = XMLParser.parseXML(new FileInputStream(config))).getRootElement()).getAttributeValue("enable"))) {
            enable = false;
        }
        if ("false".equalsIgnoreCase(root.getAttributeValue("lookupByDefault"))) {
            lookupByDefault = false;
        }
        if ((locales = root.getChildren("locale")) != null && locales.size() > 0) {
            for (Element locale : locales) {
                String postfix;
                Element rinm = locale.getChild("keyNotFound");
                String value = rinm != null ? rinm.getAttributeValue("value") : "Not Matched";
                Element vinm = locale.getChild("valueNotFound");
                String vv = vinm != null ? vinm.getAttributeValue("value") : "Not Matched";
                String localeString = locale.getAttributeValue("localeString");
                if (!StringUtils.isEmpty(localeString)) {
                    knf.put(localeString.toLowerCase(), value);
                    vnf.put(localeString.toLowerCase(), vv);
                }
                if (StringUtils.isEmpty(postfix = locale.getAttributeValue("postfix"))) continue;
                knf.put(postfix.toLowerCase(), value);
                vnf.put(postfix.toLowerCase(), vv);
            }
        }
    }

    public static String getString(ResourceBundle bundle, String key) {
        if (!enable) {
            return bundle.getString(key);
        }
        String value = null;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            String localeString = bundle.getLocale().toString().toLowerCase();
            if (knf.containsKey(localeString)) {
                return (String)knf.get(localeString);
            }
            throw mre;
        }
        return value;
    }

    public static Object keyNotFound(ResourceBundle bundle) {
        if (!lookupByDefault) {
            return knf.get(bundle.getLocale().toString().toLowerCase());
        }
        return null;
    }

    public static Object valueNotFound(ResourceBundle bundle) {
        String l = bundle.getLocale().toString().toLowerCase();
        if (vnf.containsKey(l)) {
            if (!lookupByDefault) {
                return vnf.get(l);
            }
            return null;
        }
        return "";
    }

    public static Map getKnf() {
        return knf;
    }

    public static Map getVnf() {
        return vnf;
    }

    static {
        try {
            ResourceBundleUtil.init();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

