/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SortedStringObjectMap
implements Map,
Cloneable,
IMarshalObject {
    private static final long serialVersionUID = -2603905422649090816L;
    static final int DEFAULT_INITIAL_CAPACITY = 10;
    static final float ALLOC_FACTOR = 1.5f;
    protected String[] keys;
    protected Object[] values;
    protected int size;

    public SortedStringObjectMap(int initialCapacity) {
        this.keys = new String[initialCapacity];
        this.values = new Object[initialCapacity];
        this.size = 0;
    }

    public SortedStringObjectMap() {
        this(10);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        int position = this.searchKey(key);
        return position >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.searchValue(value) >= 0;
    }

    public Collection values() {
        return new Values();
    }

    public void putAll(Map t) {
        for (String key : t.keySet()) {
            this.put(key, t.get(key));
        }
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public Set keySet() {
        return new KeySet();
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        int position = this.searchKey(key);
        if (position < 0) {
            return null;
        }
        assert (position < this.size);
        return this.values[position];
    }

    public Object remove(Object key) {
        int position = this.searchKey(key);
        if (position < 0) {
            return null;
        }
        assert (position < this.size);
        return this.internalRemove(position);
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        int position = this.searchKey(key);
        Object oldValue = null;
        if (position >= 0) {
            oldValue = this.values[position];
            this.values[position] = value;
        } else {
            this.internalInsert(position, (String)key, value);
        }
        return oldValue;
    }

    public void trimToSize() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = this.keys[i].intern();
            Object value = this.values[i];
            if (value == null || !(value instanceof String)) continue;
            this.values[i] = ((String)value).intern();
        }
        int oldCapacity = this.keys.length;
        if (this.size < oldCapacity) {
            String[] oldKeys = this.keys;
            Object[] oldValues = this.values;
            this.keys = new String[this.size];
            this.values = new Object[this.size];
            System.arraycopy(oldKeys, 0, this.keys, 0, this.size);
            System.arraycopy(oldValues, 0, this.values, 0, this.size);
        }
    }

    private int searchKey(Object obj) {
        if (this.size == 0) {
            return -1;
        }
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            String midVal = this.keys[mid];
            int cmp = this.compareKey(midVal, (String)obj);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private int compareKey(String thisObj, String anotherObj) {
        int anotherVal;
        if (thisObj == anotherObj) {
            return 0;
        }
        int thisVal = thisObj.hashCode();
        if (thisVal < (anotherVal = anotherObj.hashCode())) {
            return -1;
        }
        if (thisVal > anotherVal) {
            return 1;
        }
        if (thisObj.equals(anotherObj)) {
            return 0;
        }
        return thisObj.compareTo(anotherObj);
    }

    private int searchValue(Object obj) {
        if (this.size == 0) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.values[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    private void internalInsert(int pos, String key, Object value) {
        if (this.isEmpty()) {
            if (this.keys.length == 0) {
                this.keys = new String[1];
                this.values = new Object[1];
            }
            this.keys[0] = key;
            this.values[0] = value;
            this.size = 1;
        } else {
            if (pos < 0) {
                pos = -(pos + 1);
            }
            if (this.size + 1 > this.keys.length) {
                Object[] newValues;
                String[] newKeys;
                if (this.keys.length < 2) {
                    newKeys = new String[2];
                    newValues = new Object[2];
                } else {
                    newKeys = new String[(int)((float)this.keys.length * 1.5f)];
                    newValues = new Object[(int)((float)this.keys.length * 1.5f)];
                }
                System.arraycopy(this.keys, 0, newKeys, 0, pos);
                System.arraycopy(this.keys, pos, newKeys, pos + 1, this.size - pos);
                this.keys = newKeys;
                System.arraycopy(this.values, 0, newValues, 0, pos);
                System.arraycopy(this.values, pos, newValues, pos + 1, this.size - pos);
                this.values = newValues;
            } else {
                System.arraycopy(this.keys, pos, this.keys, pos + 1, this.size - pos);
                System.arraycopy(this.values, pos, this.values, pos + 1, this.size - pos);
            }
            this.keys[pos] = key;
            this.values[pos] = value;
            ++this.size;
        }
    }

    private Object internalRemove(int pos) {
        if (pos < 0 || pos >= this.size) {
            return null;
        }
        Object obj = this.values[pos];
        int remain = this.size - (pos + 1);
        System.arraycopy(this.keys, pos + 1, this.keys, pos, remain);
        System.arraycopy(this.values, pos + 1, this.values, pos, remain);
        this.keys[this.size - 1] = null;
        this.values[this.size - 1] = null;
        --this.size;
        return obj;
    }

    protected Entry getEntry(Object k) {
        Object value = this.get(k);
        if (value != null) {
            return new Entry(k, value);
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Entry e = (Entry)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            buf.append((key == this ? "(this Map)" : key) + "=" + (value == this ? "(this Map)" : value));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public Object clone() {
        SortedStringObjectMap that = new SortedStringObjectMap(this.size);
        System.arraycopy(this.keys, 0, that.keys, 0, this.size);
        System.arraycopy(this.values, 0, that.values, 0, this.size);
        that.size = this.size;
        return that;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map t = (Map)obj;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry e : this.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    void removeValue(Object val) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.values[i] != val) continue;
            this.internalRemove(i);
        }
    }

    @Override
    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            marshaller.writeObject(this.keys[i]);
            marshaller.writeObject(this.values[i]);
        }
    }

    @Override
    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.size = unmarshaller.readInt();
        this.keys = new String[this.size];
        this.values = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = ((String)unmarshaller.readObject()).intern();
            this.values[i] = unmarshaller.readObject();
            if (this.values[i] == null || !(this.values[i] instanceof String)) continue;
            this.values[i] = ((String)this.values[i]).intern();
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate(this).readExternal(in);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate(this).writeExternal(out);
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    static class Entry
    implements Map.Entry {
        final Object key;
        Object value;

        Entry(Object k, Object v) {
            this.value = v;
            this.key = k;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SortedStringObjectMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return SortedStringObjectMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            SortedStringObjectMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = SortedStringObjectMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object k = entry.getKey();
            return SortedStringObjectMap.this.remove(k) != null;
        }

        @Override
        public int size() {
            return SortedStringObjectMap.this.size;
        }

        @Override
        public void clear() {
            SortedStringObjectMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SortedStringObjectMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return SortedStringObjectMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return SortedStringObjectMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            SortedStringObjectMap.this.clear();
        }
    }

    private class ValueIterator
    extends AbstractIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends AbstractIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends AbstractIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private abstract class AbstractIterator
    implements Iterator {
        Entry next;
        int index = 0;
        Entry current;

        AbstractIterator() {
            Entry n = null;
            if (SortedStringObjectMap.this.size != 0) {
                n = new Entry(SortedStringObjectMap.this.keys[this.index], SortedStringObjectMap.this.values[this.index]);
            }
            this.next = n;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            Entry n = null;
            if (this.index < SortedStringObjectMap.this.size - 1) {
                n = new Entry(SortedStringObjectMap.this.keys[this.index + 1], SortedStringObjectMap.this.values[this.index + 1]);
            }
            this.next = n;
            ++this.index;
            this.current = e;
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.key;
            this.current = null;
            SortedStringObjectMap.this.remove(k);
        }
    }
}

