/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Dictionary;

public class TypeConversionUtils {
    private static Boolean useJdk15Method = null;

    public static String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof StringEnum) {
            return ((StringEnum)obj).getValue();
        }
        return obj.toString();
    }

    public static BigDecimal objToBigDecimal(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof String && StringUtils.isEmpty((String)obj)) {
            return null;
        }
        try {
            if (obj instanceof Double) {
                return BigDecimal.valueOf((Double)obj);
            }
            return new BigDecimal(obj.toString());
        }
        catch (NumberFormatException ex) {
            throw new IllegalConversionException("NumberFormatException");
        }
    }

    public static BigDecimal objToBigDecimal(Object obj, int scale) throws IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String && StringUtils.isEmpty((String)obj)) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            BigDecimal bigdecimal = (BigDecimal)obj;
            obj = bigdecimal.setScale(scale, 6);
            return (BigDecimal)obj;
        }
        try {
            if (obj instanceof Integer) {
                BigDecimal bigdecimal = new BigDecimal((double)((Integer)obj).intValue());
                return bigdecimal.setScale(scale, 6);
            }
            if (obj instanceof Float) {
                BigDecimal bigdecimal = new BigDecimal(((Float)obj).doubleValue());
                return bigdecimal.setScale(scale, 6);
            }
            if (obj instanceof Double) {
                BigDecimal bigdecimal = new BigDecimal((Double)obj);
                return bigdecimal.setScale(scale, 6);
            }
            if (obj instanceof String) {
                BigDecimal bigdecimal = new BigDecimal((String)obj);
                return bigdecimal.setScale(scale, 6);
            }
            BigDecimal bigdecimal = new BigDecimal(obj.toString());
            return bigdecimal.setScale(scale, 6);
        }
        catch (NumberFormatException _ex) {
            throw new IllegalConversionException("NumberFormatException");
        }
    }

    public static boolean objToBoolean(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String s = obj.toString();
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("yes")) {
            return true;
        }
        if (s.equals("1")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equalsIgnoreCase("no")) {
            return false;
        }
        if (s.equals("0")) {
            return false;
        }
        try {
            return Boolean.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static Boolean objToBBoolean(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String s = obj.toString();
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (s.equals("1")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s.equalsIgnoreCase("no")) {
            return Boolean.FALSE;
        }
        if (s.equals("0")) {
            return Boolean.FALSE;
        }
        try {
            return Boolean.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static byte objToByte(Object obj) throws IllegalConversionException {
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        return (byte)TypeConversionUtils.objToInt(obj);
    }

    public static short objToShort(Object obj) throws IllegalConversionException {
        if (obj instanceof Short) {
            return (Short)obj;
        }
        return (short)TypeConversionUtils.objToInt(obj);
    }

    public static int objToInt(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (obj instanceof IntEnum) {
            return ((IntEnum)obj).getValue();
        }
        try {
            return Integer.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion" + _ex.getMessage());
        }
    }

    public static Integer objToInteger(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (obj instanceof IntEnum) {
            return ((IntEnum)obj).getValue();
        }
        try {
            return Integer.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static long objToLong(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).longValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).longValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        try {
            return Long.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static Long objToLLong(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).longValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).longValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        try {
            return Long.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static float objToFloat(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).floatValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).floatValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).floatValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).floatValue();
        }
        try {
            return Float.valueOf(obj.toString()).floatValue();
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static Float objToFFloat(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return Float.valueOf(0.0f);
        }
        if (obj instanceof Float) {
            return (Float)obj;
        }
        if (obj instanceof Integer) {
            return Float.valueOf(((Integer)obj).floatValue());
        }
        if (obj instanceof Long) {
            return Float.valueOf(((Long)obj).floatValue());
        }
        if (obj instanceof Double) {
            return Float.valueOf(((Double)obj).floatValue());
        }
        if (obj instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)obj).floatValue());
        }
        try {
            return Float.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static double objToDouble(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).doubleValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        try {
            return Double.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static Double objToDDouble(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).doubleValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).doubleValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).doubleValue();
        }
        try {
            return Double.valueOf(obj.toString());
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static Time objToTime(Object obj) throws InvalidDateException, IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        try {
            if (obj instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)obj;
                return new Time(timestamp.getTime());
            }
            if (obj instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)obj;
                return new Time(date.getTime());
            }
            DateFormat df = DateFormat.getTimeInstance();
            String strObj = obj.toString();
            return new Time(df.parse(strObj).getTime());
        }
        catch (IllegalArgumentException _ex) {
            throw new InvalidDateException("Illegal date value - Java Time Objects cannot be earlier than 1/1/70");
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static Time string2Time(String time) throws IllegalConversionException {
        Date date = TypeConversionUtils.string2Date(time);
        if (date == null) {
            return null;
        }
        return new Time(date.getTime());
    }

    public static Date string2Date(String str) throws IllegalConversionException {
        java.util.Date date;
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        if ((str = str.trim().toLowerCase()).startsWith("{ts")) {
            str = str.substring(3).trim();
        }
        if (str.startsWith("'")) {
            str = str.substring(1).trim();
        }
        if (str.endsWith("}")) {
            str = str.substring(0, str.length() - 1).trim();
        }
        if (str.endsWith("'")) {
            str = str.substring(0, str.length() - 1).trim();
        }
        String dfs = "yyyy-MM-dd";
        if (str.length() > dfs.length()) {
            dfs = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = new SimpleDateFormat(dfs);
        try {
            date = df.parse(str);
        }
        catch (ParseException e) {
            throw new IllegalConversionException("parse date error");
        }
        return new Date(date.getTime());
    }

    public static Timestamp string2Timestamp(String str) throws IllegalConversionException {
        Date date = TypeConversionUtils.string2Date(str);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static void main(String[] args) {
        System.out.println(TypeConversionUtils.string2Date("{ts'1979-01-01'}"));
    }

    public static Date objToDate(Object obj) throws InvalidDateException, IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        try {
            if (obj instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)obj;
                return new Date(timestamp.getTime());
            }
            if (obj instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)obj;
                return new Date(date.getTime());
            }
            return new Date(DateTimeUtils.parseDate(obj.toString()).getTime());
        }
        catch (IllegalArgumentException _ex) {
            throw new InvalidDateException("Illegal date value - Java Date Objects cannot be earlier than 1/1/70");
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static java.util.Date objToUtilDate(Object obj) throws InvalidDateException, IllegalConversionException {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof Time) {
                Time time = (Time)obj;
                return new java.util.Date(time.getTime());
            }
            if (obj instanceof Date) {
                Date date = (Date)obj;
                return new java.util.Date(date.getTime());
            }
            if (obj instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)obj;
                return new java.util.Date(timestamp.getTime());
            }
            if (obj instanceof java.util.Date) {
                return (java.util.Date)obj;
            }
            String strObj = obj.toString();
            return DateTimeUtils.parseDate(strObj);
        }
        catch (IllegalArgumentException _ex) {
            throw new InvalidDateException("Illegal java.util.Date value - java.util.Date Objects cannot be earlier than 1/1/70");
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static Timestamp objToTimestamp(Object obj) throws InvalidDateException, IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        try {
            if (obj instanceof Time) {
                Time time = (Time)obj;
                return new Timestamp(time.getTime());
            }
            if (obj instanceof Date) {
                Date date = (Date)obj;
                return new Timestamp(date.getTime());
            }
            if (obj instanceof java.util.Date) {
                java.util.Date dt = (java.util.Date)obj;
                return new Timestamp(dt.getTime());
            }
            String strObj = obj.toString();
            return new Timestamp(DateTimeUtils.parseDate(strObj).getTime());
        }
        catch (IllegalArgumentException _ex) {
            throw new InvalidDateException("Illegal Timestamp value - Java Timestamp Objects cannot be earlier than 1/1/70");
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
    }

    public static byte[] objToBytes(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof Long) {
            long val = (Long)obj;
            byte[] b = new byte[8];
            b[7] = (byte)(val >>> 0);
            b[6] = (byte)(val >>> 8);
            b[5] = (byte)(val >>> 16);
            b[4] = (byte)(val >>> 24);
            b[3] = (byte)(val >>> 32);
            b[2] = (byte)(val >>> 40);
            b[1] = (byte)(val >>> 48);
            b[0] = (byte)(val >>> 56);
            return b;
        }
        if (obj instanceof Integer) {
            long val = ((Integer)obj).longValue();
            byte[] b = new byte[8];
            b[7] = (byte)(val >>> 0);
            b[6] = (byte)(val >>> 8);
            b[5] = (byte)(val >>> 16);
            b[4] = (byte)(val >>> 24);
            b[3] = (byte)(val >>> 32);
            b[2] = (byte)(val >>> 40);
            b[1] = (byte)(val >>> 48);
            b[0] = (byte)(val >>> 56);
            return b;
        }
        try {
            if (obj instanceof String) {
                String s = (String)obj;
                return s.getBytes();
            }
        }
        catch (Exception _ex) {
            throw new IllegalConversionException("Illegal conversion");
        }
        throw new IllegalConversionException("Illegal conversion");
    }

    public static BOSUuid objToBOSUuid(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BOSUuid) {
            return (BOSUuid)obj;
        }
        if (obj instanceof String) {
            return BOSUuid.read((String)obj);
        }
        throw new IllegalConversionException();
    }

    public static Uuid objToUuid(Object obj) throws IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Uuid) {
            return (Uuid)obj;
        }
        if (obj instanceof String) {
            return Uuid.read((String)obj);
        }
        throw new IllegalConversionException();
    }

    public static Dictionary stringToDictionary(String s, Dictionary dictionary) {
        return TypeConversionUtils.stringToDictionary(s, dictionary, ',');
    }

    public static Dictionary stringToDictionary(String s, Dictionary dictionary, char ch) {
        if (s == null) {
            return dictionary;
        }
        String[] as = StringUtils.fastSplit(s, ch);
        for (int i = as.length - 1; i > -1; --i) {
            String[] as1 = StringUtils.split(as[i], 61);
            dictionary.put(as1[0], as1[1]);
        }
        return dictionary;
    }

    public static int getLongHi(long l) {
        return (int)(l >> 32);
    }

    public static int getLongLo(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public static long intToLong(int hiWord, int loWord) {
        long l = (long)hiWord & 0xFFFFFFFFL;
        return (l <<= 32) | (long)loWord & 0xFFFFFFFFL;
    }

    public static long intToLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static int longToInt(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public static Object stringToObject(int sqlType, String str) throws IllegalConversionException {
        if (str == null) {
            return null;
        }
        switch (sqlType) {
            case -7: {
                return TypeConversionUtils.objToBoolean(str);
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(TypeConversionUtils.objToInt(str));
            }
            case -5: {
                return new Long(TypeConversionUtils.objToLong(str));
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(TypeConversionUtils.objToDouble(str));
            }
            case 2: 
            case 3: {
                return TypeConversionUtils.objToBigDecimal(str);
            }
            case -1: 
            case 1: 
            case 12: {
                return str;
            }
            case -3: 
            case -2: 
            case 2004: {
                return TypeConversionUtils.objToBytes(str);
            }
            case 91: {
                return TypeConversionUtils.string2Date(str);
            }
            case 92: {
                return TypeConversionUtils.string2Time(str);
            }
            case 93: {
                return TypeConversionUtils.string2Timestamp(str);
            }
            case 2005: {
                return str;
            }
        }
        throw new IllegalConversionException("sqlType " + sqlType + " not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String numberToPlainString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Number)) {
            throw new IllegalConversionException();
        }
        BigDecimal dec = TypeConversionUtils.objToBigDecimal(obj);
        Class<TypeConversionUtils> clazz = TypeConversionUtils.class;
        synchronized (TypeConversionUtils.class) {
            if (useJdk15Method == null) {
                useJdk15Method = Boolean.TRUE;
                try {
                    BigDecimal.class.getMethod("toPlainString", null);
                }
                catch (Exception e) {
                    useJdk15Method = Boolean.FALSE;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (useJdk15Method.booleanValue()) {
                try {
                    Method toPlainString = BigDecimal.class.getMethod("toPlainString", null);
                    return (String)toPlainString.invoke((Object)dec, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return dec.toString();
        }
    }
}

