/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.enums;

import com.kingdee.util.BOSResourceBundle;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.ResourceProviderManager;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class Enum
implements Comparable,
Serializable {
    private static final long serialVersionUID = -2144611916495959351L;
    private static final Map<String, Entry> cEnumClasses = new HashMap<String, Entry>();
    private final String iName;

    protected Enum(String name) {
        this(name, null);
    }

    Enum(String name, Assist assist) {
        String className;
        Entry entry;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The Enum name must not be empty");
        }
        this.iName = name;
        if (assist == null) {
            assist = this.getAssist(this.getClass().getName());
        }
        if ((entry = cEnumClasses.get(className = assist.innerGetKey())) == null) {
            entry = new Entry();
            cEnumClasses.put(className, entry);
        }
        if (entry.map.containsKey(name)) {
            throw new IllegalArgumentException("The Enum name must be unique, '" + name + "' has already been added in " + className);
        }
        entry.map.put(name, this);
        entry.list.add(this);
    }

    protected Object readResolve() {
        return Enum.getEnum(this.getClass(), this.getName());
    }

    protected static Enum getEnum(Class enumClass, String name) {
        return (Enum)Enum.getEnumMap(enumClass).get(name);
    }

    protected static Map getEnumMap(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        return Enum.getEnumMap(new DefaultAssist(enumClass.getName()));
    }

    static Map getEnumMap(Assist assist, boolean isInit) {
        String classname = assist.innerGetKey();
        Entry entry = cEnumClasses.get(classname);
        if (entry == null) {
            if (isInit) {
                assist.initEnum();
                entry = cEnumClasses.get(classname);
            }
            if (entry == null) {
                return Collections.emptyMap();
            }
        }
        return Collections.unmodifiableMap(entry.map);
    }

    static Map getEnumMap(Assist assist) {
        String classname = assist.innerGetKey();
        Entry entry = cEnumClasses.get(classname);
        if (entry == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(entry.map);
    }

    static List getEnumList(Assist assist, boolean isInit) {
        String classname = assist.innerGetKey();
        Entry entry = cEnumClasses.get(classname);
        if (entry == null) {
            if (isInit) {
                assist.initEnum();
                entry = cEnumClasses.get(classname);
            }
            if (entry == null) {
                return Collections.EMPTY_LIST;
            }
        }
        return Collections.unmodifiableList(entry.list);
    }

    public static final void clear() {
        String[] classnames = Assist.clearKeys();
        if (classnames == null) {
            return;
        }
        for (String c : classnames) {
            cEnumClasses.remove(c);
        }
    }

    protected static List getEnumList(Class enumClass) {
        return Enum.getEnumList(enumClass, true);
    }

    static List getEnumList(Class enumClass, boolean isInit) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        return Enum.getEnumList(new DefaultAssist(enumClass.getName()), isInit);
    }

    protected static List getEnumList(Class enumClass, Locale locale) {
        return Enum.getEnumList(enumClass, false);
    }

    protected static String[] getEnumNames(Class enumClass) {
        List enums = Enum.getEnumList(enumClass);
        String[] names = new String[enums.size()];
        for (int i = 0; i < enums.size(); ++i) {
            Enum _enum = (Enum)enums.get(i);
            names[i] = _enum.getName();
        }
        return names;
    }

    protected static Iterator iterator(Class enumClass) {
        return Enum.getEnumList(enumClass).iterator();
    }

    public final String getName() {
        return this.iName;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.iName.equals(((Enum)other).iName);
        }
        if (other.getClass().getName().equals(this.getClass().getName())) {
            try {
                return this.iName.equals(((Enum)other).iName);
            }
            catch (ClassCastException ex) {
                try {
                    Method mth = other.getClass().getMethod("getName", null);
                    String name = (String)mth.invoke(other, null);
                    return this.iName.equals(name);
                }
                catch (NoSuchMethodException ex2) {
                }
                catch (IllegalAccessException ex2) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                return false;
            }
        }
        return false;
    }

    public final int hashCode() {
        return 7 + this.iName.hashCode();
    }

    public int compareTo(Object other) {
        return this.iName.compareTo(((Enum)other).iName);
    }

    public String toString() {
        String str = this.getAlias(null);
        return str == null ? this.iName : str;
    }

    public String getAlias() {
        return this.getAlias(null);
    }

    public String getAlias(Locale locale) {
        return this.getAssist(this.getClass().getName()).getResource(this.getName(), locale);
    }

    Assist getAssist(String classname) {
        return new DefaultAssist(classname);
    }

    protected static String[] getEnumAliases(Class enumClass, Locale locale) {
        List enums = Enum.getEnumList(enumClass);
        String[] aliases = new String[enums.size()];
        for (int i = 0; i < enums.size(); ++i) {
            Enum _enum = (Enum)enums.get(i);
            aliases[i] = _enum.getAlias(locale);
        }
        return aliases;
    }

    public static void getStaticFields(Class enumCalss) {
        Field[] fields = enumCalss.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 8) == 0 || (fields[i].getModifiers() & 1) == 0) continue;
            try {
                fields[i].get(null);
                break;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    static class DefaultAssist
    extends Assist {
        private final String className;

        DefaultAssist(String className) {
            this.className = className;
        }

        @Override
        protected void initEnum() {
            try {
                Enum.getStaticFields(Class.forName(this.className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        @Override
        protected String getKey() {
            return this.className;
        }

        @Override
        protected String getResource(String name, Locale locale) {
            String s;
            if (locale == null) {
                locale = DefaultAssist.getDefaultLocale();
            }
            if (ResourceProviderManager.isMultiLanguages() && !StringUtils.isEmpty(s = ResourceProviderManager.getEnumString(this.className, locale, name))) {
                return s;
            }
            ResourceBundle res = null;
            try {
                res = BOSResourceBundle.getBundle(this.className, locale);
                return res.getString(name);
            }
            catch (MissingResourceException mre) {
                return name;
            }
        }

        @Override
        protected boolean isKeyErasable() {
            return false;
        }
    }

    static abstract class Assist {
        private static final Set<String> keys = new HashSet<String>();

        Assist() {
        }

        protected abstract void initEnum();

        protected static Locale getDefaultLocale() {
            Locale thisLocale = null;
            try {
                Class<?> clazz = Class.forName("com.kingdee.bos.ContextUtils");
                Method m = clazz.getMethod("getOriginalLocaleFromEnv", null);
                thisLocale = (Locale)m.invoke(null, null);
                if (thisLocale == null) {
                    thisLocale = LocaleUtils.getDefaultOriginLocale();
                }
            }
            catch (Throwable t) {
                thisLocale = LocaleUtils.getDefaultOriginLocale();
            }
            return thisLocale;
        }

        protected abstract String getResource(String var1, Locale var2);

        protected abstract String getKey();

        protected abstract boolean isKeyErasable();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String innerGetKey() {
            String key = this.getKey();
            if (this.isKeyErasable()) {
                Set<String> set = keys;
                synchronized (set) {
                    keys.add(key);
                }
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String[] clearKeys() {
            String[] ks;
            Set<String> set = keys;
            synchronized (set) {
                ks = keys.toArray(new String[0]);
                keys.clear();
            }
            return ks;
        }
    }

    private static class Entry {
        final Map<String, Enum> map = new HashMap<String, Enum>();
        final List<Enum> list = new ArrayList<Enum>();

        private Entry() {
        }
    }
}

