/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.marshal;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.BigDecimalUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.Null;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.MarshalConstants;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class Marshaller
implements ObjectOutput,
MarshalConstants {
    private static Logger logger = Logger.getLogger(Marshaller.class);
    private final ObjectOutput out;
    private final HandleTable handles;
    private final Intern intern;
    private int depth;
    private static Method writeReplaceMethod;
    private static Method invokeWriteReplace;

    public Marshaller(ObjectOutput out) throws IOException {
        this.out = out;
        this.handles = new HandleTable(10, 3.0f);
        this.intern = new Intern();
        this.writeStreamHeader();
    }

    void assignHandles(Object obj) {
        this.handles.assign(obj);
    }

    protected void writeStreamHeader() throws IOException {
        this.out.writeByte(51);
        this.out.writeByte(1);
    }

    @Override
    public final void writeObject(Object obj) throws IOException {
        try {
            this.writeObject0(obj);
        }
        catch (IOException ex) {
            if (this.depth == 0) {
                this.writeFatalException(ex);
            }
            throw ex;
        }
    }

    private void clear() {
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject0(Object obj) throws IOException {
        ++this.depth;
        try {
            int h;
            if (obj == null) {
                this.writeNull();
                return;
            }
            if (obj instanceof Integer) {
                this.writeIntObject((Integer)obj);
                return;
            }
            if (obj instanceof Boolean) {
                this.writeBooleanObject((Boolean)obj);
                return;
            }
            if (obj instanceof Byte) {
                this.writeByteObject((Byte)obj);
                return;
            }
            if (obj instanceof Short) {
                this.writeShortObject((Short)obj);
                return;
            }
            if (obj instanceof Character) {
                this.writeCharObject((Character)obj);
                return;
            }
            if (obj instanceof Float) {
                this.writeFloatObject((Float)obj);
                return;
            }
            if (obj == Null.NULL) {
                this.writeNullObject();
                return;
            }
            if ((obj = this.intern.intern(obj)) instanceof Externalizable) {
                obj = this.writeReplaceObject(obj);
            }
            if ((h = this.handles.lookup(obj)) != -1) {
                this.writeHandle(h);
                return;
            }
            if (obj instanceof String) {
                this.writeString((String)obj);
            } else if (obj instanceof BigDecimal) {
                this.writeBigDecimal((BigDecimal)obj);
            } else if (obj instanceof Date) {
                this.writeDate((Date)obj);
            } else if (obj instanceof Time) {
                this.writeTime((Time)obj);
            } else if (obj instanceof Timestamp) {
                this.writeTimestamp((Timestamp)obj);
            } else if (obj instanceof java.util.Date) {
                this.writeUtilDate((java.util.Date)obj);
            } else if (obj instanceof BOSUuid) {
                this.writeBOSUuid((BOSUuid)obj);
            } else if (obj instanceof Enum) {
                this.writeEnum((Enum)obj);
            } else if (obj instanceof BOSObjectType) {
                this.writeBOSObjectType((BOSObjectType)obj);
            } else if (obj instanceof Locale) {
                this.writeLocale((Locale)obj);
            } else if (obj instanceof Long) {
                this.writeLongObject((Long)obj);
            } else if (obj instanceof Double) {
                this.writeDoubleObject((Double)obj);
            } else if (obj instanceof BigInteger) {
                this.writeBigInteger((BigInteger)obj);
            } else if (obj instanceof Uuid) {
                this.writeUuid((Uuid)obj);
            } else if (obj instanceof IMarshalObject) {
                this.writeMarshalData((IMarshalObject)obj);
            } else if (obj instanceof Externalizable) {
                this.writeExternalData((Externalizable)obj);
            } else {
                this.writeSerialData(obj);
            }
        }
        finally {
            --this.depth;
        }
    }

    private Object writeReplaceObject(Object orig) {
        if (orig == null) {
            return null;
        }
        Class<?> cl = orig.getClass();
        ObjectStreamClass osc = ObjectStreamClass.lookup(cl);
        try {
            Boolean hasMethod = (Boolean)writeReplaceMethod.invoke((Object)osc, null);
            if (hasMethod.booleanValue()) {
                return invokeWriteReplace.invoke((Object)osc, orig);
            }
            return orig;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return orig;
        }
    }

    private void writeNull() throws IOException {
        this.out.writeByte(64);
    }

    private void writeHandle(int handle) throws IOException {
        if (handle < 256) {
            this.out.writeByte(65);
            this.out.writeByte(handle);
        } else if (handle < 65536) {
            this.out.writeByte(66);
            this.out.writeShort(handle);
        } else {
            this.out.writeByte(67);
            this.out.writeInt(handle);
        }
    }

    private void writeString(String str) throws IOException {
        this.handles.assign(str);
        this.out.writeByte(70);
        this.out.writeObject(str);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArray(Object array) throws IOException {
        this.out.writeByte(71);
        Class<?> ccl = array.getClass().getComponentType();
        this.writeClassDesc(ccl);
        this.handles.assign(array);
        if (ccl.isPrimitive()) {
            if (ccl == Integer.TYPE) {
                int[] ia = (int[])array;
                this.out.writeInt(ia.length);
                for (int i = 0; i < ia.length; ++i) {
                    this.out.writeInt(ia[i]);
                }
                return;
            } else if (ccl == Byte.TYPE) {
                byte[] ba = (byte[])array;
                this.out.writeInt(ba.length);
                for (int i = 0; i < ba.length; ++i) {
                    this.out.writeByte(ba[i]);
                }
                return;
            } else if (ccl == Long.TYPE) {
                long[] ja = (long[])array;
                this.out.writeInt(ja.length);
                for (int i = 0; i < ja.length; ++i) {
                    this.out.writeLong(ja[i]);
                }
                return;
            } else if (ccl == Float.TYPE) {
                float[] fa = (float[])array;
                this.out.writeInt(fa.length);
                for (int i = 0; i < fa.length; ++i) {
                    this.out.writeFloat(fa[i]);
                }
                return;
            } else if (ccl == Double.TYPE) {
                double[] da = (double[])array;
                this.out.writeInt(da.length);
                for (int i = 0; i < da.length; ++i) {
                    this.out.writeDouble(da[i]);
                }
                return;
            } else if (ccl == Short.TYPE) {
                short[] sa = (short[])array;
                this.out.writeInt(sa.length);
                for (int i = 0; i < sa.length; ++i) {
                    this.out.writeShort(sa[i]);
                }
                return;
            } else if (ccl == Character.TYPE) {
                char[] ca = (char[])array;
                this.out.writeInt(ca.length);
                for (int i = 0; i < ca.length; ++i) {
                    this.out.writeShort(ca[i]);
                }
                return;
            } else {
                if (ccl != Boolean.TYPE) throw new InternalError();
                boolean[] za = (boolean[])array;
                this.out.writeInt(za.length);
                for (int i = 0; i < za.length; ++i) {
                    this.out.writeBoolean(za[i]);
                }
            }
            return;
        } else {
            Object[] objs = (Object[])array;
            int len = objs.length;
            this.out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                this.writeObject0(objs[i]);
            }
        }
    }

    private void writeClassDesc(Class cl) throws IOException {
        this.writeString0(cl.getName());
    }

    private void writeString0(String str) throws IOException {
        if (str == null) {
            this.writeNull();
            return;
        }
        int handle = this.handles.lookup(str);
        if (handle != -1) {
            this.writeHandle(handle);
        } else {
            this.writeString(str);
        }
    }

    private void writeMarshalData(IMarshalObject obj) throws IOException {
        this.out.writeByte(101);
        this.writeClassDesc(obj.getClass());
        this.handles.assign(obj);
        obj.marshal(this);
    }

    private void writeExternalData(Externalizable obj) throws IOException {
        this.out.writeByte(68);
        this.writeClassDesc(obj.getClass());
        this.handles.assign(obj);
        obj.writeExternal(this.out);
    }

    private void writeSerialData(Object obj) throws IOException {
        this.handles.assign(obj);
        this.out.writeByte(69);
        this.out.writeObject(obj);
    }

    private void writeFatalException(IOException ex) throws IOException {
        this.clear();
        this.out.writeByte(72);
        this.writeObject0(ex);
        this.clear();
    }

    private void writeBooleanObject(Boolean bool) throws IOException {
        this.out.writeByte(80);
        this.out.writeBoolean(bool);
    }

    private void writeByteObject(Byte b) throws IOException {
        this.out.writeByte(81);
        this.out.writeByte(b.byteValue());
    }

    private void writeShortObject(Short s) throws IOException {
        this.out.writeByte(83);
        this.out.writeShort(s.shortValue());
    }

    private void writeCharObject(Character c) throws IOException {
        this.out.writeByte(82);
        this.out.writeChar(c.charValue());
    }

    private void writeIntObject(Integer i) throws IOException {
        this.out.writeByte(84);
        this.out.writeInt(i);
    }

    private void writeFloatObject(Float f) throws IOException {
        this.out.writeByte(86);
        this.out.writeFloat(f.floatValue());
    }

    private void writeLongObject(Long l) throws IOException {
        this.handles.assign(l);
        this.out.writeByte(85);
        this.out.writeLong(l);
    }

    private void writeDoubleObject(Double d) throws IOException {
        this.handles.assign(d);
        this.out.writeByte(87);
        this.out.writeDouble(d);
    }

    private void writeBigInteger(BigInteger bi) throws IOException {
        this.handles.assign(bi);
        this.out.writeByte(88);
        byte[] ba = bi.toByteArray();
        this.out.writeInt(ba.length);
        for (int i = 0; i < ba.length; ++i) {
            this.out.writeByte(ba[i]);
        }
    }

    private void writeBigDecimal(BigDecimal dec) throws IOException {
        dec = BigDecimalUtil.rmNegativeScale(dec);
        this.handles.assign(dec);
        this.out.writeByte(89);
        byte[] ba = dec.unscaledValue().toByteArray();
        this.out.writeInt(ba.length);
        for (int i = 0; i < ba.length; ++i) {
            this.out.writeByte(ba[i]);
        }
        this.out.writeInt(dec.scale());
    }

    private void writeDate(Date date) throws IOException {
        this.handles.assign(date);
        this.out.writeByte(92);
        this.out.writeLong(date.getTime());
    }

    private void writeTime(Time time) throws IOException {
        this.handles.assign(time);
        this.out.writeByte(93);
        this.out.writeLong(time.getTime());
    }

    private void writeTimestamp(Timestamp timestamp) throws IOException {
        this.handles.assign(timestamp);
        this.out.writeByte(94);
        this.out.writeLong(((java.util.Date)timestamp).getTime());
        this.out.writeInt(timestamp.getNanos());
    }

    private void writeUtilDate(java.util.Date date) throws IOException {
        this.handles.assign(date);
        this.out.writeByte(90);
        this.out.writeLong(date.getTime());
    }

    private void writeLocale(Locale locale) throws IOException {
        this.handles.assign(locale);
        this.out.writeByte(91);
        this.out.writeUTF(LocaleUtils.getLocaleString(locale));
    }

    private void writeNullObject() throws IOException {
        this.out.writeByte(96);
    }

    private void writeUuid(Uuid uuid) throws IOException {
        this.handles.assign(uuid);
        this.out.writeByte(97);
        uuid.write(this.out);
    }

    private void writeEnum(Enum obj) throws IOException {
        this.out.writeByte(100);
        this.writeClassDesc(obj.getClass());
        this.writeString0(obj.getName());
        this.handles.assign(obj);
    }

    private void writeBOSObjectType(BOSObjectType type) throws IOException {
        this.handles.assign(type);
        this.out.writeByte(98);
        type.write(this.out);
    }

    private void writeBOSUuid(BOSUuid uuid) throws IOException {
        this.handles.assign(uuid);
        this.out.writeByte(99);
        uuid.write(this.out);
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.clear();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }

    static {
        try {
            Method method = ObjectStreamClass.class.getDeclaredMethod("hasWriteReplaceMethod", null);
            method.setAccessible(true);
            writeReplaceMethod = method;
            Method method1 = ObjectStreamClass.class.getDeclaredMethod("invokeWriteReplace", Object.class);
            method1.setAccessible(true);
            invokeWriteReplace = method1;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static final class Intern {
        private Map longMap;
        private Map doubleMap;
        private Map bigIntegerMap;
        private Map bigDecimalMap;
        private Map stringMap;
        private Map localeMap;
        private Map bosObjectTypeMap;
        private Map uuidMap;
        private Map bosUuidMap;

        Intern() {
        }

        Object intern(Object obj) {
            if (obj instanceof String) {
                return this.intern((String)obj);
            }
            if (obj instanceof BigDecimal) {
                return this.intern((BigDecimal)obj);
            }
            if (obj instanceof BOSUuid) {
                return this.intern((BOSUuid)obj);
            }
            if (obj instanceof BOSObjectType) {
                return this.intern((BOSObjectType)obj);
            }
            if (obj instanceof Locale) {
                return this.intern((Locale)obj);
            }
            if (obj instanceof Long) {
                return this.intern((Long)obj);
            }
            if (obj instanceof Double) {
                return this.intern((Double)obj);
            }
            if (obj instanceof BigInteger) {
                return this.intern((BigInteger)obj);
            }
            if (obj instanceof Uuid) {
                return this.intern((Uuid)obj);
            }
            return obj;
        }

        private Map longMap() {
            if (this.longMap == null) {
                this.longMap = new HashMap();
            }
            return this.longMap;
        }

        Long intern(Long o) {
            return (Long)this.objIntern(o, this.longMap());
        }

        private Map doubleMap() {
            if (this.doubleMap == null) {
                this.doubleMap = new HashMap();
            }
            return this.doubleMap;
        }

        Double intern(Double o) {
            return (Double)this.objIntern(o, this.doubleMap());
        }

        private Map bigIntegerMap() {
            if (this.bigIntegerMap == null) {
                this.bigIntegerMap = new HashMap();
            }
            return this.bigIntegerMap;
        }

        BigInteger intern(BigInteger o) {
            return (BigInteger)this.objIntern(o, this.bigIntegerMap());
        }

        private Map bigDecimalMap() {
            if (this.bigDecimalMap == null) {
                this.bigDecimalMap = new HashMap();
            }
            return this.bigDecimalMap;
        }

        BigDecimal intern(BigDecimal o) {
            return (BigDecimal)this.objIntern(o, this.bigDecimalMap());
        }

        private Map stringMap() {
            if (this.stringMap == null) {
                this.stringMap = new HashMap();
            }
            return this.stringMap;
        }

        String intern(String o) {
            return (String)this.objIntern(o, this.stringMap());
        }

        private Map localeMap() {
            if (this.localeMap == null) {
                this.localeMap = new HashMap();
            }
            return this.localeMap;
        }

        Locale intern(Locale o) {
            return (Locale)this.objIntern(o, this.localeMap());
        }

        private Map bosObjectTypeMap() {
            if (this.bosObjectTypeMap == null) {
                this.bosObjectTypeMap = new HashMap();
            }
            return this.bosObjectTypeMap;
        }

        BOSObjectType intern(BOSObjectType o) {
            return (BOSObjectType)this.objIntern(o, this.bosObjectTypeMap());
        }

        private Map uuidMap() {
            if (this.uuidMap == null) {
                this.uuidMap = new HashMap();
            }
            return this.uuidMap;
        }

        Uuid intern(Uuid o) {
            return (Uuid)this.objIntern(o, this.uuidMap());
        }

        private Map bosUuidMap() {
            if (this.bosUuidMap == null) {
                this.bosUuidMap = new HashMap();
            }
            return this.bosUuidMap;
        }

        BOSUuid intern(BOSUuid o) {
            return (BOSUuid)this.objIntern(o, this.bosUuidMap());
        }

        private Object objIntern(Object obj, Map map) {
            if (!map.containsKey(obj)) {
                map.put(obj, obj);
                return obj;
            }
            return map.get(obj);
        }
    }

    private static class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object obj, int handle) {
            int index = this.hash(obj) % this.spine.length;
            this.objs[handle] = obj;
            this.next[handle] = this.spine[index];
            this.spine[index] = handle;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }
}

