/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.objbuddy;

import com.kingdee.util.objbuddy.BuddyEvent;
import com.kingdee.util.objbuddy.BuddyObjectRegistry;
import com.kingdee.util.objbuddy.IBuddyObject;

public class BuddyObjectFactory {
    private BuddyObjectFactory() {
    }

    public static IBuddyObject getInstance(Object source) {
        return new ObjectBuddyDelegate(BuddyObjectRegistry.getObjectBuddyInstance(source), source);
    }

    private static class ObjectBuddyDelegate
    implements IBuddyObject {
        private IBuddyObject buddy;
        private final Object source;

        public ObjectBuddyDelegate(IBuddyObject buddy, Object source) {
            this.buddy = buddy;
            this.source = source;
        }

        private IBuddyObject getBuddy() {
            if (this.buddy != null) {
                return this.buddy;
            }
            this.buddy = BuddyObjectRegistry.getObjectBuddyInstance(this.source);
            this.initialize();
            return this.buddy;
        }

        @Override
        public void actionPerformed(BuddyEvent event) {
            this.getBuddy();
            if (this.buddy != null) {
                this.buddy.actionPerformed(event);
            }
        }

        @Override
        public Object getSource() {
            this.getBuddy();
            if (this.buddy != null) {
                return this.buddy.getSource();
            }
            return null;
        }

        @Override
        public void initialize() {
            if (this.buddy != null) {
                this.buddy.initialize();
            }
        }

        @Override
        public void propertyChanged(String propertyName, String propertyType, Object oldValue, Object newValue) {
            this.getBuddy();
            if (this.buddy != null) {
                this.buddy.propertyChanged(propertyName, propertyType, oldValue, newValue);
            }
        }

        @Override
        public void operationPerformed(String operationName) {
            this.getBuddy();
            if (this.buddy != null) {
                this.buddy.operationPerformed(operationName);
            }
        }

        @Override
        public void operationPerformed(String operationName, Object[] args) {
            this.getBuddy();
            if (this.buddy != null) {
                this.buddy.operationPerformed(operationName, args);
            }
        }

        @Override
        public void terminate() {
            if (this.buddy != null) {
                this.buddy.terminate();
            }
        }
    }
}

