/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.util.profile;

import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.profile.ThreadProfileContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DBExporter {
    private static Logger logger = Logger.getLogger(DBExporter.class);
    static final String DRIVER_CLASS = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    private final String host;
    private final String port;
    private final String dbName;
    private final String user;
    private final String password;
    private final String profileDir;
    private final String profileFile;

    public static void main(String[] args) throws Exception {
    }

    public DBExporter(String host, String port, String dbName, String user, String password, String profileDir, String profileFile) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.user = user;
        this.password = password;
        this.profileDir = profileDir;
        this.profileFile = profileFile;
    }

    public DBExporter() {
        this(System.getProperty("host"), System.getProperty("port", "1433"), System.getProperty("dbName"), System.getProperty("user", "sa"), System.getProperty("password"), System.getProperty("profileDir"), System.getProperty("profileFile", "profile.csv"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt() throws SQLException, IOException {
        Connection cn = null;
        try {
            cn = this.getConnection(this.url());
            this.createTable(cn);
            File dir = new File(this.profileDir);
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(this.profileDir);
            }
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(DBExporter.this.profileFile);
                }
            });
            for (int i = 0; i < files.length; ++i) {
                this.importOneFile(cn, files[i]);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup(cn);
    }

    private void createTable(Connection cn) throws SQLException, IOException {
        SQLUtils.execute(cn, this.getSQL("droptable.sql"));
        SQLUtils.execute(cn, this.getSQL("createtable.sql"));
    }

    private void importOneFile(Connection cn, File file) throws SQLException, IOException {
        String line;
        FileInputStream is = new FileInputStream(file);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((line = in.readLine()) != null) {
            this.importLine(cn, line.split(","));
        }
        in.close();
        ((InputStream)is).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importLine(Connection cn, String[] values) throws SQLException, IOException {
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(this.getSQL("insert.sql"));
            Object[] objs = ThreadProfileContext.toValues(values);
            for (int i = 0; i < objs.length; ++i) {
                stmt.setObject(i + 1, objs[i]);
            }
            stmt.execute();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt);
            throw throwable;
        }
        SQLUtils.cleanup(stmt);
    }

    private String url() {
        return "jdbc:microsoft:sqlserver://" + this.host + ":" + this.port + ";DatabaseName=" + this.dbName + ";Charset=GBK";
    }

    private Connection getConnection(String url) throws SQLException {
        try {
            Driver driver = (Driver)Class.forName(DRIVER_CLASS).newInstance();
            DriverManager.registerDriver(driver);
            return DriverManager.getConnection(url, this.user, this.password);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage());
        }
    }

    private String getSQL(String fileName) throws IOException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        InputStream is = DBExporter.class.getResourceAsStream(fileName);
        BufferedReader in = new BufferedReader(new InputStreamReader(is, "8859_1"));
        do {
            line = in.readLine();
            sbuf.append(line);
        } while (line != null);
        in.close();
        is.close();
        return sbuf.toString();
    }
}

