/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.datawizard.common.model;

import com.kingdee.bos.datawizard.common.model.AbstractDatasetModel;
import com.kingdee.bos.datawizard.common.model.DatasetDb;
import com.kingdee.bos.datawizard.common.model.DatasetOutputField;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.xml.DesignParameterIO;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDatasetModelIo {
    protected final IXmlElement toXmlOfParams(AbstractDatasetModel model) {
        List<DesignParameter> params = model.getParams();
        return DesignParameterIO.makeParameters(params);
    }

    protected final IXmlElement toXmlOfOutputFields(AbstractDatasetModel model) {
        IXmlElement xmlOutputs = XmlUtil.createNode((String)"Outputs");
        List<DatasetOutputField> outputFields = model.getOutputFields();
        if (outputFields != null) {
            IXmlElement xmlColumns = XmlUtil.createNode((String)"Columns");
            xmlOutputs.addChild(xmlColumns);
            for (DatasetOutputField of : outputFields) {
                IXmlElement xmlField = XmlUtil.createNode((String)"Column");
                xmlField.setAttribute("name", of.getName());
                xmlField.setAttribute("alias", of.getAlias());
                xmlField.setAttribute("dataType", of.getDataType().getName());
                xmlColumns.addChild(xmlField);
            }
        }
        return xmlOutputs;
    }

    protected final IXmlElement toXmlOfOutsideDb(DatasetDb datasetDb) {
        IXmlElement xmlDb = XmlUtil.createNode((String)"OutsideDatabase");
        if (!StringUtil.isEmptyString((String)datasetDb.getDbName())) {
            xmlDb.setAttribute("name", datasetDb.getDbName());
        }
        return xmlDb;
    }

    protected final void fromXmlOfParams(AbstractDatasetModel model, IXmlElement xmlParent) {
        IXmlElement xmlParams = xmlParent.getChild("Parameters");
        if (xmlParams != null) {
            List params = DesignParameterIO.parseParameters(xmlParams);
            model.setParams(params);
        }
    }

    protected final void fromXmlOfOutputFields(AbstractDatasetModel model, IXmlElement xmlParent) {
        IXmlElement xmlColumns;
        model.setOutputFields(null);
        IXmlElement xmlOutputs = xmlParent.getChild("Outputs");
        if (xmlOutputs != null && (xmlColumns = xmlOutputs.getChild("Columns")) != null) {
            ArrayList<DatasetOutputField> outputFields = new ArrayList<DatasetOutputField>(10);
            model.setOutputFields(outputFields);
            Iterator it = xmlColumns.searchChildren("Column").iterator();
            while (it.hasNext()) {
                DatasetOutputField of = new DatasetOutputField();
                IXmlElement xmlField = (IXmlElement)it.next();
                of.setName(xmlField.getAttribute("name"));
                of.setDataType(DataType.fromName((String)xmlField.getAttribute("dataType")));
                String alias = xmlField.getAttribute("alias");
                if (alias.equals("#1")) {
                    alias = xmlField.getAttribute("alias.zh_CN");
                }
                of.setAlias(alias);
                outputFields.add(of);
            }
        }
    }

    protected final DatasetDb fromXmlOfOutsideDb(IXmlElement xmlParent) {
        IXmlElement xmlDb = xmlParent.getChild("OutsideDatabase");
        String name = xmlDb.getAttribute("name");
        if (name == null) {
            return null;
        }
        DatasetDb datasetDb = new DatasetDb();
        datasetDb.setDbName(name);
        return datasetDb;
    }
}

